/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.cmd.ColonSplitter;
import org.rrd4j.cmd.RrdToolCmd;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Util;

class RrdCreateCmd
extends RrdToolCmd {
    static final String DEFAULT_START = "now-10s";
    static final String DEFAULT_STEP = "300";
    private RrdDef rrdDef;

    RrdCreateCmd() {
    }

    String getCmdType() {
        return "create";
    }

    Object execute() throws IOException {
        String startStr = this.getOptionValue("b", "start", DEFAULT_START);
        long start = Util.getTimestamp(startStr);
        String stepStr = this.getOptionValue("s", "step", DEFAULT_STEP);
        long step = RrdCreateCmd.parseLong(stepStr);
        String[] words = this.getRemainingWords();
        if (words.length < 2) {
            throw new IllegalArgumentException("RRD file path not specified");
        }
        String path = words[1];
        this.rrdDef = new RrdDef(path, start, step);
        int i = 2;
        while (i < words.length) {
            if (words[i].startsWith("DS:")) {
                this.parseDef(words[i]);
            } else if (words[i].startsWith("RRA:")) {
                this.parseRra(words[i]);
            } else {
                throw new IllegalArgumentException("Invalid rrdcreate syntax: " + words[i]);
            }
            ++i;
        }
        return this.createRrdDb();
    }

    private void parseDef(String word) {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length < 6) {
            throw new IllegalArgumentException("Invalid DS definition: " + word);
        }
        String dsName = tokens[1];
        DsType dsType = DsType.valueOf(tokens[2]);
        long heartbeat = RrdCreateCmd.parseLong(tokens[3]);
        double min = RrdCreateCmd.parseDouble(tokens[4]);
        double max = RrdCreateCmd.parseDouble(tokens[5]);
        this.rrdDef.addDatasource(dsName, dsType, heartbeat, min, max);
    }

    private void parseRra(String word) {
        String[] tokens = new ColonSplitter(word).split();
        if (tokens.length < 5) {
            throw new IllegalArgumentException("Invalid RRA definition: " + word);
        }
        ConsolFun cf = ConsolFun.valueOf(tokens[1]);
        double xff = RrdCreateCmd.parseDouble(tokens[2]);
        int steps = RrdCreateCmd.parseInt(tokens[3]);
        int rows = RrdCreateCmd.parseInt(tokens[4]);
        this.rrdDef.addArchive(cf, xff, steps, rows);
    }

    private String createRrdDb() throws IOException {
        RrdDb rrdDb = RrdCreateCmd.getRrdDbReference(this.rrdDef);
        RrdCreateCmd.releaseRrdDbReference(rrdDb);
        return this.rrdDef.getPath();
    }
}

