/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.convertor;

import java.io.File;
import java.text.DecimalFormat;
import java.util.Date;
import org.rrd4j.core.RrdDb;

public class Convertor {
    private static final String FACTORY_NAME = "FILE";
    private static final String SUFFIX = ".jrb";
    private static final DecimalFormat secondsFormatter = new DecimalFormat("##0.000");
    private static final DecimalFormat countFormatter = new DecimalFormat("0000");
    private String[] files;
    private int totalCount;
    private int badCount;
    private int goodCount;

    private Convertor(String[] files) {
        try {
            RrdDb.setDefaultFactory(FACTORY_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.files = files;
    }

    private void convertAll() {
        Date t1 = new Date();
        String ruler = "=======================================================================";
        Convertor.println("=======================================================================");
        Convertor.println("Converting RRDTool files to Rrd4j native format.");
        Convertor.println("Original RRDTool files will not be modified in any way");
        Convertor.println("RRD4J files created during the process will have a .jrb suffix");
        Convertor.println("=======================================================================");
        String[] stringArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            this.convertFile(file);
            ++n2;
        }
        Convertor.println("=======================================================================");
        Convertor.println("Finished: " + this.totalCount + " total, " + this.goodCount + " OK, " + this.badCount + " failed");
        Date t2 = new Date();
        double secs = (double)(t2.getTime() - t1.getTime()) / 1000.0;
        Convertor.println("Conversion took " + secondsFormatter.format(secs) + " sec");
        if (this.totalCount > 0) {
            double avgSec = secs / (double)this.totalCount;
            Convertor.println("Average per-file conversion time: " + secondsFormatter.format(avgSec) + " sec");
        }
    }

    private void convertFile(String path) {
        long start = System.currentTimeMillis();
        ++this.totalCount;
        try {
            File rrdFile = new File(path);
            Convertor.print(String.valueOf(countFormatter.format(this.totalCount)) + "/" + countFormatter.format(this.files.length) + " " + rrdFile.getName() + " ");
            String sourcePath = rrdFile.getCanonicalPath();
            String destPath = String.valueOf(sourcePath) + SUFFIX;
            RrdDb rrd = new RrdDb(destPath, "rrdtool:/" + sourcePath);
            rrd.close();
            ++this.goodCount;
            double seconds = (double)(System.currentTimeMillis() - start) / 1000.0;
            Convertor.println("[OK, " + secondsFormatter.format(seconds) + " sec]");
        }
        catch (Exception e) {
            ++this.badCount;
            Convertor.println("[" + e + "]");
        }
    }

    private static void println(String msg) {
        System.out.println(msg);
    }

    private static void print(String msg) {
        System.out.print(msg);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Convertor.println("Usage  : java -jar convertor.jar <RRD file pattern> ...");
            Convertor.println("Example: java -jar convertor.jar files/*.rrd");
            System.exit(1);
        }
        Convertor c = new Convertor(args);
        c.convertAll();
    }
}

