/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Util;
import org.rrd4j.core.jrrd.RRDatabase;

class RrdToolReader
extends DataImporter {
    private RRDatabase rrd;

    RrdToolReader(String rrdPath) throws IOException {
        this.rrd = new RRDatabase(rrdPath);
    }

    String getVersion() {
        return this.rrd.getHeader().getVersion();
    }

    long getLastUpdateTime() {
        return Util.getTimestamp(this.rrd.getLastUpdate());
    }

    long getStep() {
        return this.rrd.getHeader().getPDPStep();
    }

    int getDsCount() {
        return this.rrd.getHeader().getDSCount();
    }

    int getArcCount() throws IOException {
        return this.rrd.getNumArchives();
    }

    String getDsName(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getName();
    }

    String getDsType(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getType().toString();
    }

    long getHeartbeat(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMinimumHeartbeat();
    }

    double getMinValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMinimum();
    }

    double getMaxValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getMaximum();
    }

    double getLastValue(int dsIndex) {
        String valueStr = this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getLastReading();
        return Util.parseDouble(valueStr);
    }

    double getAccumValue(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getValue();
    }

    long getNanSeconds(int dsIndex) {
        return this.rrd.getDataSource(dsIndex).getPDPStatusBlock().getUnknownSeconds();
    }

    ConsolFun getConsolFun(int arcIndex) {
        return ConsolFun.valueOf(this.rrd.getArchive(arcIndex).getType().toString());
    }

    double getXff(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getXff();
    }

    int getSteps(int arcIndex) {
        return this.rrd.getArchive(arcIndex).getPdpCount();
    }

    int getRows(int arcIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getRowCount();
    }

    double getStateAccumValue(int arcIndex, int dsIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getCDPStatusBlock(dsIndex).getValue();
    }

    int getStateNanSteps(int arcIndex, int dsIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getCDPStatusBlock(dsIndex).getUnknownDatapoints();
    }

    double[] getValues(int arcIndex, int dsIndex) throws IOException {
        return this.rrd.getArchive(arcIndex).getValues()[dsIndex];
    }

    void release() throws IOException {
        if (this.rrd != null) {
            this.rrd.close();
            this.rrd = null;
        }
    }

    protected void finalize() throws Throwable {
        this.release();
    }
}

