/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.RrdNode;
import org.rrd4j.inspector.Util;

class MainTreeModel
extends DefaultTreeModel {
    private static final DefaultMutableTreeNode INVALID_NODE = new DefaultMutableTreeNode("No valid RRD file specified");
    private File file;

    MainTreeModel() {
        super(INVALID_NODE);
    }

    boolean setFile(File newFile) {
        try {
            this.file = newFile;
            RrdDb rrd = new RrdDb(this.file.getAbsolutePath(), true);
            try {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(new RrdNode(rrd));
                int dsCount = rrd.getRrdDef().getDsCount();
                int arcCount = rrd.getRrdDef().getArcCount();
                int dsIndex = 0;
                while (dsIndex < dsCount) {
                    DefaultMutableTreeNode dsNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex));
                    int arcIndex = 0;
                    while (arcIndex < arcCount) {
                        DefaultMutableTreeNode arcNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex, arcIndex));
                        dsNode.add(arcNode);
                        ++arcIndex;
                    }
                    root.add(dsNode);
                    ++dsIndex;
                }
                this.setRoot(root);
            }
            finally {
                rrd.close();
            }
        }
        catch (Exception e) {
            this.setRoot(INVALID_NODE);
            Util.error(null, e);
            return false;
        }
    }
}

