/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthworm.message;

import gov.usgs.earthworm.message.Message;
import gov.usgs.earthworm.message.MessageLogo;
import gov.usgs.earthworm.message.TraceBuf;
import java.io.IOException;

public class MessageFactory {
    public static Message createMessage(byte[] b, int i, int seq) throws IOException {
        MessageLogo logo = new MessageLogo(b);
        Message msg = null;
        switch (logo.getType()) {
            case TYPE_TRACEBUF: {
                msg = TraceBuf.createFromBytes(b, i, seq);
                break;
            }
            case TYPE_TRACEBUF2: {
                msg = TraceBuf.createFromBytesAsTraceBuf2(b, i, seq);
                break;
            }
            case TYPE_HEARTBEAT: {
                msg = new Message(b, i, seq);
                break;
            }
            default: {
                System.out.println("Unknown logo type: " + (Object)((Object)logo.getType()));
                msg = new Message(b, i, seq);
            }
        }
        return msg;
    }
}

