/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

public class SunriseSunset {
    public static final float OFFICIAL = 90.833336f;
    public static final float CIVIL = 96.0f;
    public static final float NAUTICAL = 102.0f;
    public static final float ASTRONOMICAL = 108.0f;

    public static float[] getSunriseSunset(int day, int month, int year, float zenith, float lon, float lat) {
        float N1 = (float)Math.floor(275.0f * ((float)month / 9.0f));
        float N2 = (float)Math.floor(((float)month + 9.0f) / 12.0f);
        float N3 = (float)(1.0 + Math.floor(((double)year - 4.0 * Math.floor((float)year / 4.0f) + 2.0) / 3.0));
        float N = N1 - N2 * N3 + (float)day - 30.0f;
        float lngHour = lon / 15.0f;
        float tRise = N + (6.0f - lngHour) / 24.0f;
        float tSet = N + (18.0f - lngHour) / 24.0f;
        float sunrise = SunriseSunset.getTime(tRise, zenith, lat, lngHour, true);
        float sunset = SunriseSunset.getTime(tSet, zenith, lat, lngHour, false);
        return new float[]{sunrise, sunset};
    }

    private static float getTime(float t, float zenith, float lat, float lngHour, boolean rise) {
        float UT;
        float RA;
        float L;
        float M = 0.9856f * t - 3.289f;
        for (L = M + (float)(1.916 * Math.sin(Math.toRadians(M)) + 0.02 * Math.toRadians(2.0f * M) + 282.634); L >= 360.0f; L -= 360.0f) {
        }
        while (L < 0.0f) {
            L += 360.0f;
        }
        for (RA = (float)Math.toDegrees(Math.atan(0.91764 * Math.tan(Math.toRadians(L)))); RA >= 360.0f; RA -= 360.0f) {
        }
        while (L < 0.0f) {
            RA += 360.0f;
        }
        float Lquadrant = (float)Math.floor(L / 90.0f) * 90.0f;
        float RAquadrant = (float)Math.floor(RA / 90.0f) * 90.0f;
        RA += Lquadrant - RAquadrant;
        float sinDec = 0.39782f * (float)Math.sin(Math.toRadians(L));
        float cosDec = (float)Math.cos(Math.asin(sinDec));
        float cosH = (float)(Math.cos(Math.toRadians(zenith)) - (double)sinDec * Math.sin(Math.toRadians(lat)) / ((double)cosDec * Math.cos(Math.toRadians(lat))));
        float H = rise ? 360.0f - (float)Math.toDegrees(Math.acos(cosH)) : (float)Math.toDegrees(Math.acos(cosH));
        float T = (H /= 15.0f) + (RA /= 15.0f) - 0.06571f * t - 6.622f;
        for (UT = T - lngHour; UT >= 24.0f; UT -= 24.0f) {
        }
        while (UT < 0.0f) {
            UT += 24.0f;
        }
        return UT;
    }

    public static void main(String[] args) {
        float lat = 37.461113f;
        float lon = -122.11506f;
        float[] t = SunriseSunset.getSunriseSunset(24, 4, 2007, 90.833336f, lon, lat);
        System.out.println(t[0] - 7.0f);
        System.out.println(t[1] - 7.0f + 24.0f);
    }
}

