/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.math;

public class Util {
    public static double LN10 = Math.log(10.0);
    public static double LOG10 = Math.log(10.0);
    public static double LOG2 = Math.log(2.0);

    public static double getNextPowerOf2(double arg) {
        return Math.pow(2.0, Math.ceil(Math.log(arg) / LOG2));
    }

    public static double getPreviousPowerOf2(double arg) {
        return Math.pow(2.0, Math.floor(Math.log(arg) / LOG2));
    }

    public static double getExp(double d) {
        return Math.floor(Math.log(Math.abs(d)) / LN10);
    }

    public static double getMantissa(double d) {
        return d / Math.pow(10.0, Util.getExp(d));
    }

    public static double bessi0(double x) {
        if (x == 0.0) {
            return 1.0;
        }
        if (Math.abs(x) <= 15.0) {
            double z = x * x;
            double numerator = z * (z * (z * (z * (z * (z * (z * (z * (z * (z * (z * (z * (z * (z * 2.10580722890567E-23 + 3.80715242345326E-20) + 4.794402575483E-17) + 4.35125971262668E-14) + 3.0093112711296E-11) + 1.60224679395361E-8) + 6.54858370096785E-6) + 0.00202591084143397) + 0.463076284721) + 75.4337328948189) + 8307.92541809429) + 571661.130563785) + 2.16415572361227E7) + 3.56644482244025E8) + 1.44048298227235E9;
            double denominator = z * (z * (z - 3076.46912682801) + 3476263.32405882) - 1.44048298227235E9;
            return -numerator / denominator;
        }
        return Math.exp(Math.abs(x)) * Util.nonexpbessi0(x);
    }

    public static double nonexpbessi0(double x) {
        double br;
        int i;
        if (x == 0.0) {
            return 1.0;
        }
        if (Math.abs(x) <= 15.0) {
            return Math.exp(-Math.abs(x)) * Util.bessi0(x);
        }
        double[] ar1 = new double[]{0.2439260769778, -115.591978104435, 7840.34249005088, -143464.631313583};
        double[] ar2 = new double[]{1.0, -325.197333369824, 20312.8436100794, -361847.779219653};
        x = Math.abs(x);
        double sqrtx = Math.sqrt(x);
        double br2 = 0.0;
        double br1 = 0.0;
        double z = 30.0 / x - 1.0;
        double z2 = z + z;
        for (i = 0; i <= 3; ++i) {
            br = z2 * br1 - br2 + ar1[i];
            br2 = br1;
            br1 = br;
        }
        double numerator = z * br1 - br2 + 346519.833357379;
        br2 = 0.0;
        br1 = 0.0;
        for (i = 0; i <= 3; ++i) {
            br = z2 * br1 - br2 + ar2[i];
            br2 = br1;
            br1 = br;
        }
        double denominator = z * br1 - br2 + 865665.274832055;
        return numerator / denominator / sqrtx;
    }

    public static double[] kaiser(int windowLength, double beta) {
        double[] window = new double[windowLength];
        double B0 = Math.abs(Util.bessi0(beta));
        double xind = (windowLength - 1) * (windowLength - 1);
        int odd = windowLength % 2;
        int n = (windowLength + odd) / 2;
        window[n - 1] = 1.0;
        for (int i = 0; i < n - odd; ++i) {
            window[i + n] = Math.abs(Util.bessi0(beta * Math.sqrt(1.0 - Math.pow(2 * i + 1 + odd, 2.0) / xind)) / B0);
            window[n - i - 1 - odd] = window[i + n];
        }
        return window;
    }
}

