/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.plot.render;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.plot.Plot;
import gov.usgs.plot.color.ColorCycler;
import gov.usgs.plot.render.BasicFrameRenderer;
import gov.usgs.plot.render.DataPointRenderer;
import gov.usgs.plot.render.LegendRenderer;
import gov.usgs.plot.render.PointRenderer;
import gov.usgs.plot.render.ShapeRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Arrays;

public class MatrixRenderer
extends BasicFrameRenderer {
    private DoubleMatrix2D data;
    private boolean NO_DATA = false;
    private boolean[] visible;
    private int offset;
    protected ShapeRenderer[] lineRenderers;
    protected DataPointRenderer[] pointRenderers;

    protected MatrixRenderer() {
    }

    public MatrixRenderer(DoubleMatrix2D d, boolean ranks) {
        this.offset = ranks ? 2 : 1;
        this.setData(d);
    }

    public void setData(DoubleMatrix2D d) {
        if (d == null) {
            throw new IllegalArgumentException("data must not be null");
        }
        if (d.rows() == 1 && Double.isNaN(d.getQuick(0, 0))) {
            this.NO_DATA = true;
        }
        this.data = d;
        this.visible = new boolean[this.data.columns() - this.offset];
        Arrays.fill(this.visible, true);
    }

    public DoubleMatrix2D getData() {
        return this.data;
    }

    public void setAllVisible(boolean b) {
        Arrays.fill(this.visible, b);
    }

    public void setVisible(int col, boolean v) {
        if (col < this.data.columns() - this.offset) {
            this.visible[col] = v;
        }
    }

    public ShapeRenderer[] getLineRenderers() {
        return this.lineRenderers;
    }

    public void setLineRenderers(ShapeRenderer[] r) {
        this.lineRenderers = r;
    }

    public void setLineRenderer(int col, ShapeRenderer r) {
        if (col < this.data.columns() - this.offset) {
            this.lineRenderers[col] = r;
        }
    }

    public PointRenderer[] getPointRenderers() {
        return this.pointRenderers;
    }

    public void setPointRenderers(DataPointRenderer[] r) {
        this.pointRenderers = r;
    }

    public void setPointRenderer(int col, PointRenderer r) {
        if (col < this.data.columns() - this.offset) {
            this.pointRenderers[col] = (DataPointRenderer)r;
        }
    }

    public void createLineRenderer(int col, Stroke s, Color color) {
        if (this.visible[col]) {
            int ic = 1000;
            if (this.data != null) {
                ic = this.data.rows() + 1;
            }
            ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, ic));
            sr.antiAlias = true;
            sr.color = color;
            sr.stroke = s;
            this.lineRenderers[col] = sr;
        }
    }

    public void createPointRenderer(int col, DataPointRenderer dr) {
        if (this.visible[col]) {
            dr.transformer = this;
            this.pointRenderers[col] = dr;
        }
    }

    public void createDefaultLineRenderers(Color color) {
        this.createDefaultLineRenderers(0, color);
    }

    public void createDefaultLineRenderers(int start, Color color) {
        this.lineRenderers = new ShapeRenderer[this.data.columns() - this.offset];
        ColorCycler cc = new ColorCycler(start);
        for (int i = 0; i < this.data.columns() - this.offset; ++i) {
            if (!this.visible[i]) continue;
            int ic = 1000;
            if (this.data != null) {
                ic = this.data.rows() + 1;
            }
            ShapeRenderer sr = new ShapeRenderer(new GeneralPath(1, ic));
            sr.color = color == null ? cc.getNextColor() : color;
            this.lineRenderers[i] = sr;
        }
    }

    public void createDefaultPointRenderers(Color color) {
        this.createDefaultPointRenderers(0, 'o', color);
    }

    public void createDefaultPointRenderers(char shape, Color color) {
        this.createDefaultPointRenderers(0, shape, color);
    }

    public void createDefaultPointRenderers(int start, Color color) {
        this.createDefaultPointRenderers(start, 'o', color);
    }

    public void createDefaultPointRenderers(int start, char shape, Color color) {
        this.pointRenderers = new DataPointRenderer[this.data.columns() - this.offset];
        ColorCycler cc = new ColorCycler(start);
        for (int i = 0; i < this.data.columns() - this.offset; ++i) {
            if (!this.visible[i]) continue;
            DataPointRenderer dpr = new DataPointRenderer(shape, 8.0f);
            dpr.color = color == null ? cc.getNextColor() : color;
            dpr.transformer = this;
            this.pointRenderers[i] = dpr;
        }
    }

    @Override
    public void createDefaultLegendRenderer(String[] s) {
        this.createDefaultLegendRenderer(s, 0);
    }

    public void createDefaultLegendRenderer(String[] s, int leftLines) {
        double additionalYOffset = 0.0;
        if (leftLines > 0) {
            additionalYOffset = ((double)leftLines + 0.5) * 16.0;
        }
        this.setLegendRenderer(new LegendRenderer(this.NO_DATA));
        this.getLegendRenderer().x = this.graphX + 6;
        this.getLegendRenderer().y = (double)(this.graphY + 6) + additionalYOffset;
        this.addToLegendRenderer(this.getLegendRenderer(), s, leftLines);
    }

    public void addToLegendRenderer(LegendRenderer lr, String[] s, int leftLines) {
        for (int i = 0; i < this.data.columns() - this.offset; ++i) {
            if (!this.visible[i]) continue;
            ShapeRenderer sr = null;
            if (this.lineRenderers != null) {
                sr = this.lineRenderers[i];
            }
            DataPointRenderer dpr = null;
            if (this.pointRenderers != null) {
                dpr = this.pointRenderers[i];
            }
            if (i >= s.length) continue;
            lr.addLine(sr, dpr, s[i]);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean[] getVisible() {
        return this.visible;
    }

    @Override
    public void render(Graphics2D g) {
        AffineTransform origAT = g.getTransform();
        Color origColor = g.getColor();
        Stroke origStroke = g.getStroke();
        Shape origClip = g.getClip();
        if (this.axis != null) {
            this.axis.render(g);
        }
        g.clip(new Rectangle(this.graphX, this.graphY, this.graphWidth, this.graphHeight));
        if (!this.NO_DATA) {
            for (int j = 0; j < this.data.columns() - this.offset; ++j) {
                if (!this.visible[j]) continue;
                ShapeRenderer sr = null;
                if (this.lineRenderers != null) {
                    sr = this.lineRenderers[j];
                }
                DataPointRenderer dpr = null;
                if (this.pointRenderers != null) {
                    dpr = this.pointRenderers[j];
                }
                GeneralPath gp = null;
                if (sr != null) {
                    gp = (GeneralPath)sr.shape;
                    gp.reset();
                    gp.moveTo((float)this.getXPixel(this.data.getQuick(0, 0)), (float)this.getYPixel(this.data.getQuick(0, j + this.offset)));
                }
                boolean lastnd = false;
                for (int i = 0; i < this.data.rows(); ++i) {
                    double x = this.data.getQuick(i, 0);
                    double y = this.data.getQuick(i, j + this.offset);
                    if (dpr != null && !Double.isNaN(y) && y != Double.NEGATIVE_INFINITY) {
                        dpr.x = x;
                        dpr.y = y;
                        dpr.render(g);
                    }
                    if (gp == null || y == Double.NEGATIVE_INFINITY) continue;
                    if (!Double.isNaN(y)) {
                        if (lastnd || i == 0) {
                            gp.moveTo((float)this.getXPixel(x), (float)this.getYPixel(y));
                        } else {
                            gp.lineTo((float)this.getXPixel(x), (float)this.getYPixel(y));
                        }
                        lastnd = false;
                        continue;
                    }
                    lastnd = true;
                }
                if (sr == null) continue;
                sr.render(g);
            }
        }
        if (this.getLegendRenderer() != null) {
            this.getLegendRenderer().render(g);
        }
        g.setClip(origClip);
        if (this.axis != null) {
            this.axis.postRender(g);
        }
        g.setStroke(origStroke);
        g.setColor(origColor);
        g.setTransform(origAT);
    }

    public static void main(String[] args) {
        try {
            int size = 100000;
            DoubleMatrix2D d = DoubleFactory2D.dense.make(size, 4);
            for (int i = 0; i < size; ++i) {
                d.setQuick(i, 0, (double)(i * 60));
                d.setQuick(i, 1, Math.sin(Math.PI * 8 * ((double)i / (double)size)));
                d.setQuick(i, 2, Math.cos(Math.PI * 8 * ((double)i / (double)size)));
                d.setQuick(i, 3, Math.cos(Math.PI * 8 * ((double)i / (double)size)) + 0.25 * Math.sin(87.96459430051421 * ((double)i / (double)size)));
            }
            Plot plot = new Plot();
            plot.setSize(1000, 250);
            MatrixRenderer mr = new MatrixRenderer(d, false);
            mr.setLocation(50, 20, 900, 210);
            mr.setExtents(0.0, size * 60, -1.1, 1.1);
            mr.createDefaultAxis();
            mr.setVisible(1, false);
            mr.setXAxisToTime(8);
            mr.createDefaultLineRenderers(null);
            plot.addRenderer(mr);
            for (int i = 0; i < 10; ++i) {
                plot.writePNG("test.png");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

