/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.util.ui;

import gov.usgs.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class BaseDialog
extends JDialog {
    private static final long serialVersionUID = -1L;
    protected int height;
    protected int width;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JPanel mainPanel;
    protected JFrame parent;
    private boolean okClicked;

    protected BaseDialog(JFrame parent, String title, boolean modal, int w, int h) {
        super(parent, title, modal);
        this.parent = parent;
        this.width = w;
        this.height = h;
        this.createUI();
    }

    protected void createUI() {
        this.setSize(this.width, this.height);
        Dimension parentSize = this.parent.getSize();
        Point parentLoc = this.parent.getLocation();
        this.setLocation(parentLoc.x + (parentSize.width / 2 - this.width / 2), parentLoc.y + (parentSize.height / 2 - this.height / 2));
        this.mainPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton("OK");
        this.okButton.setMnemonic('O');
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseDialog.this.allowOK()) {
                    BaseDialog.this.dispose();
                    BaseDialog.this.okClicked = true;
                    BaseDialog.this.wasOK();
                }
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseDialog.this.allowCancel()) {
                    BaseDialog.this.dispose();
                    BaseDialog.this.wasCancelled();
                }
            }
        });
        Util.mapKeyStrokeToButton(this.mainPanel, "ESCAPE", "cancel1", this.cancelButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                BaseDialog.this.okButton.requestFocus();
                JRootPane root = SwingUtilities.getRootPane(BaseDialog.this.okButton);
                if (root != null) {
                    root.setDefaultButton(BaseDialog.this.okButton);
                }
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!BaseDialog.this.okClicked) {
                    BaseDialog.this.wasCancelled();
                }
            }
        });
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.mainPanel.add((Component)buttonPanel, "South");
        this.setContentPane(this.mainPanel);
    }

    protected boolean allowOK() {
        return true;
    }

    protected boolean allowCancel() {
        return true;
    }

    protected void wasOK() {
    }

    protected void wasCancelled() {
    }
}

