/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.MetaDatum;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SuppDatum;
import gov.usgs.vdx.db.VDXDatabase;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SQLDataSource
implements DataSource {
    protected VDXDatabase database;
    protected String vdxName;
    protected String dbName;
    protected static Logger logger = Logger.getLogger("gov.usgs.vdx.data.SQLDataSource");
    protected Statement st;
    protected PreparedStatement ps;
    protected ResultSet rs;
    protected String sql;
    protected String sqlCount;
    private int maxrows = 0;

    @Override
    public abstract void initialize(ConfigFile var1);

    @Override
    public abstract String getType();

    public abstract boolean getChannelsFlag();

    public abstract boolean getTranslationsFlag();

    public abstract boolean getRanksFlag();

    public abstract boolean getColumnsFlag();

    public abstract boolean getMenuColumnsFlag();

    public abstract boolean getChannelTypesFlag();

    public abstract boolean databaseExists();

    public abstract boolean createDatabase();

    public abstract void disconnect();

    @Override
    public int getMaxRows() {
        return this.maxrows;
    }

    protected void setMaxRows(int maxrows) {
        this.maxrows = maxrows;
    }

    public static int getResultSetSize(ResultSet rs) throws SQLException {
        int size = 0;
        int currentRow = rs.getRow();
        if (rs != null) {
            rs.beforeFirst();
            rs.last();
            size = rs.getRow();
            if (currentRow == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(currentRow);
            }
        }
        return size;
    }

    public static RequestResult getErrorResult(String errMessage) {
        ArrayList<String> text = new ArrayList<String>();
        text.add(errMessage);
        TextResult result = new TextResult(text);
        result.setError(true);
        return result;
    }

    public static String getDownsamplingSQL(String sql, String time_column, DownsamplingType ds, int dsInt) throws UtilException {
        if (!ds.equals((Object)DownsamplingType.NONE) && dsInt <= 1) {
            throw new UtilException("Downsampling interval should be more than 1");
        }
        if (ds.equals((Object)DownsamplingType.NONE)) {
            return sql;
        }
        if (ds.equals((Object)DownsamplingType.DECIMATE)) {
            return "SELECT * FROM(SELECT fullQuery.*, @row := @row+1 AS rownum FROM (" + sql + ") fullQuery, (SELECT @row:=0) r) ranked WHERE rownum % " + dsInt + " = 1";
        }
        if (ds.equals((Object)DownsamplingType.MEAN)) {
            String sql_select_clause = sql.substring(6, sql.toUpperCase().indexOf("FROM") - 1);
            String sql_from_where_clause = sql.substring(sql.toUpperCase().indexOf("FROM") - 1, sql.toUpperCase().lastIndexOf("ORDER BY") - 1);
            String[] columns = sql_select_clause.split(",");
            String avg_sql = "SELECT ";
            for (String column : columns) {
                String groupFunction = "AVG";
                String[] column_parts = column.trim().split("\\sas\\s");
                if (column_parts[0].equals(time_column)) {
                    groupFunction = "MIN";
                } else if (column_parts[0].equals("rid") || column_parts[0].endsWith(".rid")) {
                    groupFunction = "MIN";
                }
                avg_sql = column_parts.length > 1 ? avg_sql + groupFunction + "(" + column_parts[0] + ") as " + column_parts[1] + ", " : avg_sql + groupFunction + "(" + column_parts[0] + "), ";
            }
            avg_sql = avg_sql + "(((" + time_column + ") - ?) DIV ?) intNum ";
            avg_sql = avg_sql + sql_from_where_clause;
            avg_sql = avg_sql + " GROUP BY intNum";
            return avg_sql;
        }
        throw new UtilException("Unknown downsampling type: " + (Object)((Object)ds));
    }

    public void defaultInitialize(ConfigFile params) {
        String driver = params.getString("vdx.driver");
        String url = params.getString("vdx.url");
        String prefix = params.getString("vdx.prefix");
        this.database = new VDXDatabase(driver, url, prefix);
        this.vdxName = params.getString("vdx.name");
        this.dbName = this.vdxName + "$" + this.getType();
        this.maxrows = Util.stringToInt(params.getString("maxrows"), 0);
    }

    public void defaultDisconnect() {
        this.database.close();
    }

    public boolean defaultDatabaseExists() {
        return this.database.useDatabase(this.dbName);
    }

    public boolean defaultCreateDatabase(boolean channels, boolean translations, boolean channelTypes, boolean ranks, boolean columns, boolean menuColumns) {
        try {
            this.database.useRootDatabase();
            this.ps = this.database.getPreparedStatement("CREATE DATABASE " + this.database.getDatabasePrefix() + "_" + this.dbName);
            this.ps.execute();
            this.database.useDatabase(this.dbName);
            if (channels) {
                this.sql = "CREATE TABLE channels (cid INT PRIMARY KEY AUTO_INCREMENT, code VARCHAR(16) UNIQUE, name VARCHAR(255), lon DOUBLE, lat DOUBLE, height DOUBLE, active TINYINT(1) NOT NULL DEFAULT 1";
                if (translations) {
                    this.sql = this.sql + ", tid INT DEFAULT 1 NOT NULL";
                }
                if (channelTypes) {
                    this.sql = this.sql + ", ctid INT DEFAULT 1 NOT NULL";
                    this.ps.execute("CREATE TABLE channel_types (ctid INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(16) UNIQUE, user_default TINYINT(1) DEFAULT 0 NOT NULL)");
                    this.ps.execute("INSERT INTO channel_types (name) VALUES ('DEFAULT')");
                }
                this.sql = this.sql + ")";
                this.ps.execute(this.sql);
            }
            if (columns) {
                this.ps.execute("CREATE TABLE columns (colid INT PRIMARY KEY AUTO_INCREMENT, idx INT, name VARCHAR(255) UNIQUE, description VARCHAR(255), unit VARCHAR(255), checked TINYINT, active TINYINT, bypassmanipulations TINYINT, accumulate TINYINT)");
            }
            if (menuColumns) {
                this.ps.execute("CREATE TABLE columns_menu (colid INT PRIMARY KEY AUTO_INCREMENT, idx INT, name VARCHAR(255) UNIQUE, description VARCHAR(255), unit VARCHAR(255), checked TINYINT, active TINYINT, bypassmanipulations TINYINT, accumulate TINYINT)");
            }
            if (ranks) {
                this.ps.execute("CREATE TABLE ranks (rid INT PRIMARY KEY AUTO_INCREMENT,name VARCHAR(24) UNIQUE, rank INT(10) UNSIGNED DEFAULT 0 NOT NULL, user_default TINYINT(1) DEFAULT 0 NOT NULL)");
            }
            this.ps.execute("CREATE TABLE supp_data (sdid INT NOT NULL AUTO_INCREMENT, st DOUBLE NOT NULL, et DOUBLE, sdtypeid INT NOT NULL, sd_short VARCHAR(90) NOT NULL, sd TEXT NOT NULL, PRIMARY KEY (sdid))");
            this.ps.execute("CREATE TABLE supp_data_type (sdtypeid INT NOT NULL AUTO_INCREMENT, supp_data_type VARCHAR(20), supp_color VARCHAR(6) NOT NULL, draw_line TINYINT, PRIMARY KEY (sdtypeid), UNIQUE KEY (supp_data_type) )");
            this.sql = "CREATE TABLE supp_data_xref ( sdid INT NOT NULL, cid INT NOT NULL, colid INT NOT NULL, ";
            String key = "UNIQUE KEY (sdid,cid,colid";
            if (ranks) {
                this.sql = this.sql + "rid INT NOT NULL, ";
                key = key + ",rid";
            }
            this.ps.execute(this.sql + key + "))");
            this.sql = "CREATE TABLE channelmetadata ( cmid INT NOT NULL AUTO_INCREMENT, cid INT NOT NULL, colid INT NOT NULL, ";
            if (ranks) {
                this.sql = this.sql + "rid INT NOT NULL, ";
            }
            this.sql = this.sql + "name VARCHAR(20) NOT NULL, value TEXT NOT NULL, UNIQUE KEY (cmid,cid,colid";
            if (ranks) {
                this.sql = this.sql + ",rid";
            }
            this.ps.execute(this.sql + "))");
            logger.log(Level.INFO, "SQLDataSource.defaultCreateDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded. ");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultCreateDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") failed.", e);
            return false;
        }
    }

    public String getChannelName(boolean plural) {
        return plural ? "Channels" : "Channel";
    }

    public boolean defaultCreateChannel(Channel channel, int tid, boolean channels, boolean translations, boolean ranks, boolean columns) {
        return this.defaultCreateChannel(channel.getCode(), channel.getName(), channel.getLon(), channel.getLat(), channel.getHeight(), channel.getActive(), tid, channels, translations, ranks, columns);
    }

    public boolean defaultCreateChannel(String channelCode, String channelName, double lon, double lat, double height, int active, int tid, boolean channels, boolean translations, boolean ranks, boolean columns) {
        try {
            List<Column> columnsList;
            if (channelCode == null || channelCode.length() == 0) {
                return false;
            }
            if (channelName == null || channelName.length() == 0) {
                channelName = channelCode;
            }
            this.database.useDatabase(this.dbName);
            if (channels) {
                String columnList = "code, name, lon, lat, height, active";
                String variableList = "?,?,?,?,?,?";
                if (translations) {
                    columnList = columnList + ",tid";
                    variableList = variableList + ",?";
                }
                this.ps = this.database.getPreparedStatement("INSERT INTO channels (" + columnList + ") VALUES (" + variableList + ")");
                this.ps.setString(1, channelCode);
                this.ps.setString(2, channelName);
                if (Double.isNaN(lon)) {
                    this.ps.setNull(3, 8);
                } else {
                    this.ps.setDouble(3, lon);
                }
                if (Double.isNaN(lat)) {
                    this.ps.setNull(4, 8);
                } else {
                    this.ps.setDouble(4, lat);
                }
                if (Double.isNaN(height)) {
                    this.ps.setNull(5, 8);
                } else {
                    this.ps.setDouble(5, height);
                }
                this.ps.setInt(6, active);
                if (translations) {
                    this.ps.setInt(7, tid);
                }
                this.ps.execute();
            }
            if (columns && (columnsList = this.defaultGetColumns(true, false)).size() > 0) {
                String sql = "CREATE TABLE " + channelCode + " (j2ksec DOUBLE";
                for (int i = 0; i < columnsList.size(); ++i) {
                    sql = sql + "," + columnsList.get((int)i).name + " DOUBLE";
                }
                if (translations) {
                    sql = sql + ",tid INT DEFAULT 1 NOT NULL";
                }
                sql = ranks ? sql + ",rid INT DEFAULT 1 NOT NULL,PRIMARY KEY(j2ksec,rid)" : sql + ",PRIMARY KEY(j2ksec)";
                sql = sql + ",KEY index_j2ksec (j2ksec))";
                this.ps = this.database.getPreparedStatement(sql);
                this.ps.execute(sql);
            }
            logger.log(Level.INFO, "SQLDataSource.defaultCreateChannel(" + channelCode + "," + lon + "," + lat + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultCreateChannel(" + channelCode + "," + lon + "," + lat + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultCreateTiltChannel(Channel channel, int tid, double azimuth, boolean channels, boolean translations, boolean ranks, boolean columns) {
        try {
            this.defaultCreateChannel(channel, tid, channels, translations, ranks, columns);
            Channel ch = this.defaultGetChannel(channel.getCode(), false);
            String azimuth_column_name = null;
            azimuth_column_name = this.dbName.toLowerCase().contains("tensorstrain") ? "natural_azimuth" : "azimuth";
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("UPDATE channels SET " + azimuth_column_name + "  = ? WHERE cid = ?");
            this.ps.setDouble(1, azimuth);
            this.ps.setInt(2, ch.getCID());
            this.ps.execute();
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultCreateTiltChannel() failed.", e);
            return false;
        }
    }

    public boolean defaultUpdateChannelTranslationID(String channelCode, int tid) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("UPDATE channels SET tid = ? WHERE code = ?");
            this.ps.setInt(1, tid);
            this.ps.setString(2, channelCode);
            this.ps.execute();
            logger.log(Level.INFO, "SQLDataSource.defaultUpdateChannelTranslationID(" + channelCode + "," + tid + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultUpdateChannelTranslationID(" + channelCode + "," + tid + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultCreateTranslation() {
        try {
            this.database.useDatabase(this.dbName);
            boolean exists = false;
            this.rs = this.database.getPreparedStatement("SHOW TABLES LIKE 'translations'").executeQuery();
            if (this.rs.next()) {
                exists = true;
            }
            this.rs.close();
            if (exists) {
                return true;
            }
            List<Column> columns = this.defaultGetColumns(true, false);
            if (columns.size() > 0) {
                this.sql = "CREATE TABLE translations (tid INT PRIMARY KEY AUTO_INCREMENT, name VARCHAR(255)";
                for (int i = 0; i < columns.size(); ++i) {
                    this.sql = this.sql + ",c" + columns.get((int)i).name + " DOUBLE DEFAULT 1,";
                    this.sql = this.sql + " d" + columns.get((int)i).name + " DOUBLE DEFAULT 0 ";
                }
                this.sql = this.sql + ")";
                this.ps.execute(this.sql);
                this.ps.execute("INSERT INTO translations (name) VALUES ('DEFAULT')");
            }
            logger.log(Level.INFO, "SQLDataSource.defaultCreateTranslation() succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultCreateTranslation() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultInsertColumn(Column column) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO columns (idx, name, description, unit, checked, active, bypassmanipulations, accumulate) VALUES (?,?,?,?,?,?,?,?)");
            this.ps.setInt(1, column.idx);
            this.ps.setString(2, column.name);
            this.ps.setString(3, column.description);
            this.ps.setString(4, column.unit);
            this.ps.setBoolean(5, column.checked);
            this.ps.setBoolean(6, column.active);
            this.ps.setBoolean(7, column.bypassmanip);
            this.ps.setBoolean(8, column.accumulate);
            this.ps.execute();
            logger.log(Level.INFO, "SQLDataSource.defaultInsertColumn(" + column.name + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultInsertColumn(" + column.name + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public boolean defaultInsertMenuColumn(Column column) {
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT IGNORE INTO columns_menu (idx, name, description, unit, checked, active, bypassmanipulations, accumulate) VALUES (?,?,?,?,?,?,?,?)");
            this.ps.setInt(1, column.idx);
            this.ps.setString(2, column.name);
            this.ps.setString(3, column.description);
            this.ps.setString(4, column.unit);
            this.ps.setBoolean(5, column.checked);
            this.ps.setBoolean(6, column.active);
            this.ps.setBoolean(7, column.bypassmanip);
            this.ps.setBoolean(8, column.accumulate);
            this.ps.execute();
            logger.log(Level.INFO, "SQLDataSource.defaultInsertPlotColumn(" + column.name + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultInsertPlotColumn(" + column.name + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return false;
        }
    }

    public int defaultInsertChannelType(String name) {
        int result = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("INSERT INTO channel_types (name) VALUES (?)");
            this.ps.setString(1, name);
            this.ps.execute();
            this.rs = this.database.getPreparedStatement("SELECT LAST_INSERT_ID()").executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
            logger.log(Level.INFO, "SQLDataSource.defaultInsertChannelType(" + name + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultInsertChannelType(" + name + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public Rank defaultInsertRank(Rank rank) {
        return this.defaultInsertRank(rank.getName(), rank.getRank(), rank.getUserDefault());
    }

    public Rank defaultInsertRank(String name, int rank, int user_default) {
        Rank result = null;
        try {
            int rid = this.defaultGetRankID(rank);
            if (rid > 0) {
                return this.defaultGetRank(rid);
            }
            this.database.useDatabase(this.dbName);
            if (user_default == 1) {
                this.ps = this.database.getPreparedStatement("UPDATE ranks set user_default = 0");
                this.ps.execute();
            }
            this.ps = this.database.getPreparedStatement("INSERT INTO ranks (name, rank, user_default) VALUES (?,?,?)");
            this.ps.setString(1, name);
            this.ps.setInt(2, rank);
            this.ps.setInt(3, user_default);
            this.ps.execute();
            this.rs = this.database.getPreparedStatement("SELECT LAST_INSERT_ID()").executeQuery();
            if (this.rs.next()) {
                result = this.defaultGetRank(this.rs.getInt(1));
            }
            this.rs.close();
            logger.log(Level.INFO, "SQLDataSource.defaultInsertRank(" + name + "," + rank + "," + user_default + ") succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultInsertRank(" + name + "," + rank + "," + user_default + ") failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultInsertTranslation(String channelCode, GenericDataMatrix gdm) {
        int tid = 1;
        String columns = "";
        String values = "";
        try {
            this.database.useDatabase(this.dbName);
            DoubleMatrix2D dm = gdm.getData();
            String[] columnNames = gdm.getColumnNames();
            for (int i = 0; i < columnNames.length; ++i) {
                columns = columns + columnNames[i] + ",";
                values = values + dm.get(0, i) + ",";
            }
            columns = columns + "name";
            values = values + "'" + channelCode + "'";
            this.ps = this.database.getPreparedStatement("INSERT INTO translations (" + columns + ") VALUES (" + values + ")");
            this.ps.execute();
            tid = this.defaultGetTranslation(channelCode, gdm);
            logger.log(Level.INFO, "SQLDataSource.defaultInsertTranslation() succeeded. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultInsertTranslation() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return tid;
    }

    public Channel defaultGetChannel(int cid, boolean channelTypes) {
        Channel ch = null;
        int ctid = 0;
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT code, name, lon, lat, height, active ";
            if (channelTypes) {
                this.sql = this.sql + ",ctid ";
            }
            this.sql = this.sql + "FROM  channels ";
            this.sql = this.sql + "WHERE cid = ?";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setInt(1, cid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                String code = this.rs.getString(1);
                String name = this.rs.getString(2);
                double lon = this.rs.getDouble(3);
                if (this.rs.wasNull()) {
                    lon = Double.NaN;
                }
                double lat = this.rs.getDouble(4);
                if (this.rs.wasNull()) {
                    lat = Double.NaN;
                }
                double height = this.rs.getDouble(5);
                if (this.rs.wasNull()) {
                    height = Double.NaN;
                }
                int active = this.rs.getInt(6);
                if (channelTypes) {
                    ctid = this.rs.getInt(7);
                }
                ch = new Channel(cid, code, name, lon, lat, height, active, ctid);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannel(cid) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return ch;
    }

    public Channel defaultGetChannel(String code, boolean channelTypes) {
        Channel ch = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT cid FROM channels WHERE code = ? ");
            this.ps.setString(1, code);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                int cid = this.rs.getInt(1);
                ch = this.defaultGetChannel(cid, channelTypes);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannel(code) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return ch;
    }

    public List<Channel> defaultGetChannelsList(boolean channelTypes) {
        ArrayList<Channel> result = new ArrayList<Channel>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT cid, code, name, lon, lat, height, active ";
            this.sql = this.dbName.toLowerCase().contains("tensorstrain") ? this.sql + ", natural_azimuth " : (this.dbName.toLowerCase().contains("tilt") ? this.sql + ", azimuth " : this.sql + ", 0 ");
            if (channelTypes) {
                this.sql = this.sql + ",ctid ";
            }
            this.sql = this.sql + "FROM  channels ";
            this.sql = this.sql + "ORDER BY code ";
            this.rs = this.database.getPreparedStatement(this.sql).executeQuery();
            while (this.rs.next()) {
                int cid = this.rs.getInt(1);
                String code = this.rs.getString(2);
                String name = this.rs.getString(3);
                double lon = this.rs.getDouble(4);
                if (this.rs.wasNull()) {
                    lon = Double.NaN;
                }
                double lat = this.rs.getDouble(5);
                if (this.rs.wasNull()) {
                    lat = Double.NaN;
                }
                double height = this.rs.getDouble(6);
                if (this.rs.wasNull()) {
                    height = Double.NaN;
                }
                int active = this.rs.getInt(7);
                double azimuth = this.rs.getDouble(8);
                if (this.rs.wasNull()) {
                    azimuth = Double.NaN;
                }
                int ctid = channelTypes ? this.rs.getInt(9) : 0;
                Channel ch = new Channel(cid, code, name, lon, lat, height, active, azimuth, ctid);
                result.add(ch);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannelsList() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetChannels(boolean channelTypes) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<Channel> channelsList = this.defaultGetChannelsList(channelTypes);
            for (Channel channel : channelsList) {
                result.add(channel.toString());
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannels() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetChannelTypes() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT ctid, name, user_default FROM channel_types ORDER BY name").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%s:%d", this.rs.getInt(1), this.rs.getString(2), this.rs.getInt(3)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannelTypes() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public Rank defaultGetRank(Rank rank) {
        return this.defaultGetRank(this.defaultGetRankID(rank.getRank()));
    }

    public Rank defaultGetRank(int rid) {
        Rank result = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT rid, name, rank, user_default FROM ranks WHERE rid = ?");
            this.ps.setInt(1, rid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = new Rank(this.rs.getInt(1), this.rs.getString(2), this.rs.getInt(3), this.rs.getInt(4));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetRank() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetRankID(int rank) {
        int result = -1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT rid FROM ranks WHERE rank = ?");
            this.ps.setInt(1, rank);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetRankID() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetRanks() {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT rid, name, rank, user_default FROM ranks ORDER BY rank").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%s:%d:%d", this.rs.getInt(1), this.rs.getString(2), this.rs.getInt(3), this.rs.getInt(4)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetRanks() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetNumberOfRanks() {
        int result = 1;
        try {
            this.database.useDatabase(this.dbName);
            this.rs = this.database.getPreparedStatement("SELECT COUNT(*) FROM ranks").executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetNumberOfRanks() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetTranslation(String channelCode, GenericDataMatrix gdm) {
        int result = 1;
        try {
            this.database.useDatabase(this.dbName);
            DoubleMatrix2D dm = gdm.getData();
            String[] columnNames = gdm.getColumnNames();
            this.sql = "";
            for (int i = 0; i < columnNames.length; ++i) {
                this.sql = this.sql + "AND " + columnNames[i] + " = " + dm.get(0, i) + " ";
            }
            this.ps = this.database.getPreparedStatement("SELECT tid FROM translations WHERE name = ? " + this.sql);
            this.ps.setString(1, channelCode);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetTranslation() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public int defaultGetChannelTranslationID(String channelCode) {
        int result = 1;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT tid FROM channels WHERE code = ?");
            this.ps.setString(1, channelCode);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                result = this.rs.getInt(1);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannelTranslationID() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public List<String> defaultGetMenuColumns(boolean menuColumns) {
        List<Column> columns = this.defaultGetColumns(false, menuColumns);
        ArrayList<String> columnsString = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            columnsString.add(columns.get(i).toString());
        }
        return columnsString;
    }

    public List<Column> defaultGetColumns(boolean allColumns, boolean menuColumns) {
        ArrayList<Column> columns = new ArrayList<Column>();
        String tableName = "";
        tableName = menuColumns ? "columns_menu" : "columns";
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT idx, name, description, unit, checked, active, bypassmanipulations, accumulate ";
            this.sql = this.sql + "FROM " + tableName + " ";
            if (!allColumns && !menuColumns) {
                this.sql = this.sql + "WHERE active = 1 ";
            }
            this.sql = this.sql + "ORDER BY idx, name";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                boolean checked = this.rs.getInt(5) != 0;
                boolean active = this.rs.getInt(6) != 0;
                boolean bypassmanipulations = this.rs.getInt(7) != 0;
                boolean accumulate = this.rs.getInt(8) != 0;
                Column column = new Column(this.rs.getInt(1), this.rs.getString(2), this.rs.getString(3), this.rs.getString(4), checked, active, bypassmanipulations, accumulate);
                columns.add(column);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetColumns() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return columns;
    }

    public Column defaultGetColumn(int colid) {
        Column col = null;
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT idx, name, description, unit, checked, active, bypassmanipulations, accumulate ";
            this.sql = this.sql + "FROM  columns ";
            this.sql = this.sql + "WHERE colid = ?";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.setInt(1, colid);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                int idx = this.rs.getInt(1);
                String name = this.rs.getString(2);
                String description = this.rs.getString(3);
                String unit = this.rs.getString(4);
                boolean checked = this.rs.getInt(5) != 0;
                boolean active = this.rs.getInt(6) != 0;
                boolean bypassmanipulations = this.rs.getInt(7) != 0;
                boolean accumulate = this.rs.getInt(8) != 0;
                col = new Column(idx, name, description, unit, checked, active, bypassmanipulations, accumulate);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetColumn(colid) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return col;
    }

    public Column defaultGetColumn(String name) {
        Column col = null;
        try {
            this.database.useDatabase(this.dbName);
            this.ps = this.database.getPreparedStatement("SELECT colid FROM columns WHERE name = ? ");
            this.ps.setString(1, name);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                int colid = this.rs.getInt(1);
                col = this.defaultGetColumn(colid);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetChannel(name) failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return col;
    }

    public List<String> defaultGetOptions(String type) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT idx, code, name ";
            this.sql = this.sql + "FROM   options_" + type + " ";
            this.sql = this.sql + "ORDER BY idx";
            this.rs = this.database.getPreparedStatement(this.sql).executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d:%s:%s", this.rs.getInt(1), this.rs.getString(2), this.rs.getString(3)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetOptions() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public synchronized Date defaultGetLastDataTime(String channelCode, String nullField, boolean pollhist) {
        Date lastDataTime;
        if (pollhist) {
            lastDataTime = new Date(0L);
            try {
                this.database.useDatabase(this.dbName);
                this.sql = "SELECT max(j2ksec) FROM " + channelCode;
                if (nullField.length() > 0) {
                    this.sql = this.sql + " WHERE " + nullField + " IS NOT NULL";
                }
                this.ps = this.database.getPreparedStatement(this.sql);
                this.rs = this.ps.executeQuery();
                this.rs.next();
                double result = this.rs.getDouble(1);
                if (!this.rs.wasNull()) {
                    lastDataTime = Util.j2KToDate(result);
                }
                this.rs.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "SQLDataSource.defaultGetLastDataTime() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            }
        } else {
            lastDataTime = new Date();
        }
        return lastDataTime;
    }

    public GenericDataMatrix defaultGetData(int cid, int rid, double st, double et, boolean translations, boolean ranks, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        ArrayList<double[]> pts = new ArrayList<double[]>();
        GenericDataMatrix result = null;
        List<Object> columns = new ArrayList();
        int columnsReturned = 0;
        try {
            int i;
            double[] dataRow;
            this.database.useDatabase(this.dbName);
            Channel channel = this.defaultGetChannel(cid, false);
            columns = this.defaultGetColumns(false, false);
            int tempmaxrows = rid != 0 ? maxrows : maxrows * this.defaultGetNumberOfRanks();
            columnsReturned = ranks ? columns.size() + 2 : columns.size() + 1;
            this.sql = "SELECT j2ksec";
            if (ranks) {
                this.sql = this.sql + ", c.rid";
            }
            for (int i2 = 0; i2 < columns.size(); ++i2) {
                Column column = (Column)columns.get(i2);
                this.sql = translations ? this.sql + ",a." + column.name + " * b.c" + column.name + " + b.d" + column.name + " as " + column.name + " " : this.sql + ",a." + column.name + " ";
            }
            this.sql = this.sql + "FROM " + channel.getCode() + " a ";
            if (translations) {
                this.sql = this.sql + "INNER JOIN translations b on a.tid = b.tid ";
            }
            if (ranks) {
                this.sql = this.sql + "INNER JOIN ranks        c on a.rid = c.rid ";
            }
            this.sql = this.sql + "WHERE j2ksec >= ? ";
            this.sql = this.sql + "AND   j2ksec <= ? ";
            this.sqlCount = "SELECT COUNT(*) FROM (SELECT 1 FROM " + channel.getCode() + " a INNER JOIN ranks c ON a.rid=c.rid ";
            this.sqlCount = this.sqlCount + "WHERE j2ksec >= ? AND j2ksec <= ? ";
            if (ranks && rid != 0) {
                this.sql = this.sql + "AND   c.rid  = ? ";
                this.sqlCount = this.sqlCount + "AND c.rid = ? ";
            }
            this.sql = this.sql + "ORDER BY a.j2ksec ASC";
            this.sqlCount = this.sqlCount + "ORDER BY a.j2ksec ASC";
            if (ranks && rid == 0) {
                this.sql = this.sql + ", c.rank DESC";
                this.sqlCount = this.sqlCount + ", c.rank DESC";
            }
            if (ranks && rid != 0) {
                try {
                    this.sql = SQLDataSource.getDownsamplingSQL(this.sql, "j2ksec", ds, dsInt);
                }
                catch (UtilException e) {
                    throw new UtilException("Can't downsample dataset: " + e.getMessage());
                }
            }
            if (maxrows != 0) {
                this.sql = this.sql + " LIMIT " + (tempmaxrows + 1);
                if (ds.equals((Object)DownsamplingType.NONE)) {
                    this.ps = this.database.getPreparedStatement(this.sqlCount + " LIMIT " + (tempmaxrows + 1) + ") as T");
                    this.ps.setDouble(1, st);
                    this.ps.setDouble(2, et);
                    if (ranks && rid != 0) {
                        this.ps.setInt(3, rid);
                    }
                    this.rs = this.ps.executeQuery();
                    if (this.rs.next() && this.rs.getInt(1) > tempmaxrows) {
                        throw new UtilException("Max rows (" + maxrows + " rows) for source '" + this.dbName + "' exceeded. Please use downsampling.");
                    }
                }
            }
            this.ps = this.database.getPreparedStatement(this.sql);
            if (ds.equals((Object)DownsamplingType.MEAN)) {
                this.ps.setDouble(1, st);
                this.ps.setInt(2, dsInt);
                this.ps.setDouble(3, st);
                this.ps.setDouble(4, et);
                if (ranks && rid != 0) {
                    this.ps.setInt(5, rid);
                }
            } else {
                this.ps.setDouble(1, st);
                this.ps.setDouble(2, et);
                if (ranks && rid != 0) {
                    this.ps.setInt(3, rid);
                }
            }
            this.rs = this.ps.executeQuery();
            if (!ds.equals((Object)DownsamplingType.NONE) && maxrows != 0 && SQLDataSource.getResultSetSize(this.rs) > tempmaxrows) {
                throw new UtilException("Max rows (" + maxrows + " rows) for source '" + this.dbName + "' exceeded. Please downsample further.");
            }
            double tempJ2ksec = Double.MAX_VALUE;
            while (this.rs.next()) {
                if (Double.compare(tempJ2ksec, this.rs.getDouble(1)) != 0) {
                    dataRow = new double[columnsReturned];
                    for (i = 0; i < columnsReturned; ++i) {
                        dataRow[i] = this.getDoubleNullCheck(this.rs, i + 1);
                    }
                    pts.add(dataRow);
                }
                tempJ2ksec = this.rs.getDouble(1);
            }
            this.rs.close();
            if (pts.size() == 0) {
                dataRow = new double[columnsReturned];
                for (i = 0; i < columnsReturned; ++i) {
                    dataRow[i] = Double.NaN;
                }
                pts.add(dataRow);
            }
            result = new GenericDataMatrix(pts);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetData() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return result;
    }

    public double getDoubleNullCheck(ResultSet rs, int columnIndex) throws SQLException {
        double value = rs.getDouble(columnIndex);
        if (rs.wasNull()) {
            value = Double.NaN;
        }
        return value;
    }

    public int getIntNullCheck(ResultSet rs, int columnIndex) throws SQLException {
        int value = rs.getInt(columnIndex);
        if (rs.wasNull()) {
            value = Integer.MIN_VALUE;
        }
        return value;
    }

    public void defaultInsertData(String channelCode, GenericDataMatrix gdm, boolean translations, boolean ranks, int rid) {
        int tid = 1;
        String[] columnNames = gdm.getColumnNames();
        DoubleMatrix2D data = gdm.getData();
        StringBuffer columnBuffer = new StringBuffer();
        StringBuffer valuesBuffer = new StringBuffer();
        StringBuffer dupsBuffer = new StringBuffer();
        try {
            int i;
            this.database.useDatabase(this.dbName);
            for (i = 0; i < columnNames.length; ++i) {
                if (i == 0) {
                    columnBuffer.append(columnNames[i]);
                    valuesBuffer.append("?");
                    continue;
                }
                columnBuffer.append("," + columnNames[i]);
                valuesBuffer.append(",?");
            }
            for (i = 0; i < columnNames.length; ++i) {
                if (columnNames[i].equals("j2ksec")) continue;
                dupsBuffer.append(columnNames[i] + "=VALUES(" + columnNames[i] + "),");
            }
            if (translations) {
                tid = this.defaultGetChannelTranslationID(channelCode);
                columnBuffer.append(",tid");
                valuesBuffer.append("," + tid);
            }
            if (ranks) {
                columnBuffer.append(",rid");
                valuesBuffer.append("," + rid);
            }
            this.sql = "INSERT INTO " + channelCode + " (" + columnBuffer.toString() + ") VALUES (" + valuesBuffer.toString() + ") ";
            this.sql = this.sql + "ON DUPLICATE KEY UPDATE " + dupsBuffer.toString().substring(0, dupsBuffer.toString().length() - 1);
            String base = channelCode + "(";
            this.ps = this.database.getPreparedStatement(this.sql);
            for (i = 0; i < gdm.rows(); ++i) {
                String output = base;
                for (int j = 0; j < columnNames.length; ++j) {
                    double value = data.getQuick(i, j);
                    if (Double.isNaN(value)) {
                        this.ps.setNull(j + 1, 8);
                    } else {
                        this.ps.setDouble(j + 1, value);
                    }
                    output = output + value + ",";
                }
                this.ps.execute();
                if (translations) {
                    output = output + tid + ",";
                }
                if (!ranks) continue;
                output = output + rid + ",";
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultInsertData() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
    }

    public void insertMetaDatum(MetaDatum md) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "INSERT INTO channelmetadata (cid,colid,rid,name,value) VALUES (" + md.cid + "," + md.colid + "," + md.rid + ",\"" + md.name + "\",\"" + md.value + "\");";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.execute();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.insertMetaDatum() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
    }

    public void updateMetaDatum(MetaDatum md) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "UPDATE channelmetadata SET cid='" + md.cid + "', colid='" + md.colid + "', rid='" + md.rid + "', name='" + md.name + "', value='" + md.value + "' WHERE cmid='" + md.cmid + "'";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.execute();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.updateMetaDatum() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
    }

    public MetaDatum getMetaDatum(int cmid) {
        try {
            this.database.useDatabase(this.dbName);
            MetaDatum md = null;
            this.sql = "SELECT * FROM channelmetadata WHERE cmid = " + cmid;
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            if (this.rs.next()) {
                md = new MetaDatum();
                md.cmid = this.rs.getInt(1);
                md.cid = this.rs.getInt(2);
                md.colid = this.rs.getInt(3);
                md.rid = this.rs.getInt(4);
                md.name = this.rs.getString(5);
                md.value = this.rs.getString(6);
                md.chName = this.rs.getString(7);
                md.colName = this.rs.getString(8);
                md.rkName = this.rs.getString(9);
            }
            this.rs.close();
            return md;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.getMetaDatum() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return null;
        }
    }

    public List<MetaDatum> getMatchingMetaData(MetaDatum md, boolean cm, String source) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT MD.*, CH.code, ";
            this.sql = source.contains("rsam") ? this.sql + "COL.name FROM channelmetadata MD INNER JOIN channels CH ON MD.cid=CH.cid INNER JOIN columns" + (cm ? "_menu" : "") + " COL ON MD.colid=COL.colid WHERE " : (source.contains("hypocenters") ? "SELECT MD.*, RK.name FROM channelmetadata MD INNER JOIN ranks RK ON MD.rid=RK.rid WHERE " : this.sql + "COL.name, RK.name FROM channelmetadata MD INNER JOIN channels CH ON MD.cid=CH.cid INNER JOIN columns" + (cm ? "_menu" : "") + " COL ON MD.colid=COL.colid INNER JOIN ranks RK ON " + "MD.rid=RK.rid WHERE ");
            ArrayList<String> wheres = new ArrayList<String>();
            if (md.chName != null) {
                if (md.cid < 0) {
                    wheres.add("CH.code='" + md.chName + "'");
                } else {
                    wheres.add("CH.cid IN (" + md.chName + ")");
                }
            } else if (md.cid >= 0) {
                wheres.add("MD.cid=" + md.cid);
            }
            if (md.colName != null) {
                if (md.colid < 0) {
                    wheres.add("COL.name='" + md.colName + "'");
                } else {
                    wheres.add("MD.colid IN (" + md.colName + ")");
                }
            } else if (md.colid >= 0) {
                wheres.add("MD.colid=" + md.colid);
            }
            if (md.rkName != null) {
                wheres.add("RK.name='" + md.rkName + "'");
            } else if (md.rid >= 0) {
                wheres.add("MD.rid=" + md.rid);
            }
            if (md.name != null) {
                wheres.add("MD.name=" + md.name);
            }
            if (md.value != null) {
                wheres.add("MD.value=" + md.value);
            }
            StringBuffer where = new StringBuffer();
            boolean first = true;
            for (String s : wheres) {
                if (first) {
                    where.append(s);
                    first = false;
                    continue;
                }
                where.append(" AND " + s);
            }
            logger.info("SQL: " + this.sql + where.toString());
            this.ps = this.database.getPreparedStatement(this.sql + where);
            this.rs = this.ps.executeQuery();
            ArrayList<MetaDatum> result = new ArrayList<MetaDatum>();
            while (this.rs.next()) {
                if (source.contains("rsam")) {
                    md = new MetaDatum();
                    md.cmid = this.rs.getInt(1);
                    md.cid = this.rs.getInt(2);
                    md.colid = this.rs.getInt(3);
                    md.name = this.rs.getString(4);
                    md.value = this.rs.getString(5);
                    md.chName = this.rs.getString(6);
                    md.colName = this.rs.getString(7);
                    result.add(md);
                    continue;
                }
                if (source.contains("hypocenters")) {
                    md = new MetaDatum();
                    md.cmid = this.rs.getInt(1);
                    md.rid = this.rs.getInt(2);
                    md.name = this.rs.getString(3);
                    md.value = this.rs.getString(4);
                    md.rkName = this.rs.getString(5);
                    result.add(md);
                    continue;
                }
                md = new MetaDatum();
                md.cmid = this.rs.getInt(1);
                md.cid = this.rs.getInt(2);
                md.colid = this.rs.getInt(3);
                md.rid = this.rs.getInt(4);
                md.name = this.rs.getString(5);
                md.value = this.rs.getString(6);
                md.chName = this.rs.getString(7);
                md.colName = this.rs.getString(8);
                md.rkName = this.rs.getString(9);
                result.add(md);
            }
            this.rs.close();
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.getMatchingMetaData() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return null;
        }
    }

    protected RequestResult getMetaData(Map<String, String> params, boolean cm) {
        MetaDatum md_s;
        String source = params.get("source");
        List<MetaDatum> data = null;
        ArrayList<String> result = new ArrayList<String>();
        String arg = params.get("byID");
        if (arg != null && arg.equals("true")) {
            md_s = new MetaDatum(-1, -1, -1);
            arg = params.get("ch");
            if (arg == null || arg.equals("") || source.contains("hypocenters")) {
                md_s.cid = -1;
            } else {
                md_s.chName = arg;
                md_s.cid = 0;
            }
            arg = params.get("col");
            if (arg == null || arg.equals("")) {
                md_s.colid = -1;
            } else {
                md_s.colName = arg;
                md_s.colid = 0;
            }
            arg = params.get("rk");
            md_s.rid = arg == null || arg.equals("") || source.contains("rsam") ? -1 : Integer.parseInt(arg);
        } else {
            String chName = params.get("ch");
            String colName = params.get("col");
            String rkName = params.get("rk");
            md_s = new MetaDatum(chName, colName, rkName);
        }
        data = this.getMatchingMetaData(md_s, cm, source);
        if (data != null) {
            for (MetaDatum md : data) {
                result.add(String.format("%d,%d,%d,%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", md.cmid, md.cid, md.colid, md.rid, md.name, md.value, md.chName, md.colName, md.rkName));
            }
        }
        return new TextResult(result);
    }

    public List<SuppDatum> getMatchingSuppData(SuppDatum sd, boolean cm) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT SD.sdid, SD.sdtypeid, SD.st, SD.et, SD.sd_short, SD.sd, CH.code, COL.name, RK.name, ST.supp_data_type, ST.supp_color, SX.cid, SX.colid, SX.rid, ST.draw_line FROM supp_data as SD, channels as CH, columns" + (cm ? "_menu" : "") + " as COL, ranks as RK, supp_data_type as ST, supp_data_xref as SX ";
            String where = "WHERE SD.et >= " + sd.st + " AND SD.st <= " + sd.et + " AND SD.sdid=SX.sdid AND SD.sdtypeid=ST.sdtypeid AND SX.cid=CH.cid AND SX.colid=COL.colid AND SX.rid=RK.rid";
            if (sd.chName != null) {
                where = sd.cid < 0 ? where + " AND CH.code='" + sd.chName + "'" : where + " AND CH.cid IN (" + sd.chName + ")";
            } else if (sd.cid >= 0) {
                where = where + " AND SX.cid=" + sd.cid;
            }
            if (sd.colName != null) {
                where = sd.colid < 0 ? where + " AND COL.name='" + sd.colName + "'" : where + " AND COL.colid IN (" + sd.colName + ")";
            } else if (sd.colid >= 0) {
                where = where + " AND SX.colid=" + sd.colid;
            }
            if (sd.rkName != null) {
                where = sd.rid < 0 ? where + " AND RK.name='" + sd.rkName + "'" : where + " AND RK.rid IN (" + sd.rkName + ")";
            } else if (sd.rid >= 0) {
                where = where + " AND SX.rid=" + sd.rid;
            }
            if (sd.name != null) {
                where = where + " AND SD.sd_short=" + sd.name;
            }
            if (sd.value != null) {
                where = where + " AND SD.sd=" + sd.value;
            }
            String type_filter = null;
            if (sd.typeName != null) {
                if (sd.typeName.length() != 0) {
                    type_filter = sd.tid == -1 ? "ST.supp_data_type='" + sd.typeName + "'" : "ST.sdtypeid IN (" + sd.typeName + ")";
                }
            } else if (sd.tid >= 0) {
                type_filter = "SD.sdtypeid=" + sd.tid;
            }
            if (sd.dl == -1) {
                if (type_filter != null) {
                    where = where + " AND " + type_filter;
                }
            } else if (sd.dl < 2) {
                if (type_filter != null) {
                    where = where + " AND " + type_filter;
                }
                where = where + " AND ST.dl='" + sd.dl;
            } else {
                where = type_filter != null ? where + " AND (" + type_filter + " OR ST.draw_line='0')" : where + " AND ST.draw_line='0'";
            }
            this.ps = this.database.getPreparedStatement(this.sql + where);
            this.rs = this.ps.executeQuery();
            ArrayList<SuppDatum> result = new ArrayList<SuppDatum>();
            while (this.rs.next()) {
                result.add(new SuppDatum(this.rs));
            }
            this.rs.close();
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.getMatchingSuppData() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return null;
        }
    }

    public int insertSuppDatum(SuppDatum sd) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "INSERT INTO supp_data (sdtypeid,st,et,sd_short,sd) VALUES (" + sd.tid + "," + sd.st + "," + sd.et + ",\"" + sd.name + "\",\"" + sd.value + "\")";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.execute();
            this.rs = this.ps.getGeneratedKeys();
            this.rs.next();
            return this.rs.getInt(1);
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals("23000")) {
                logger.log(Level.SEVERE, "SQLDataSource.insertSuppDatum() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
                return 0;
            }
            try {
                this.sql = "SELECT sdid FROM supp_data WHERE sdtypeid=" + sd.tid + " AND st=" + sd.st + " AND et=" + sd.et + " AND sd_short='" + sd.name + "'";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.rs = this.ps.executeQuery();
                this.rs.next();
                return -this.rs.getInt(1);
            }
            catch (SQLException e2) {
                logger.log(Level.SEVERE, "SQLDataSource.insertSuppDatum() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e2);
                return 0;
            }
        }
    }

    public int updateSuppDatum(SuppDatum sd) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "UPDATE supp_data SET sdtypeid='" + sd.tid + "',st='" + sd.st + "',et='" + sd.et + "',sd_short='" + sd.name + "',sd='" + sd.value + "' WHERE sdid='" + sd.sdid + "'";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.execute();
            return sd.sdid;
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "SQLDataSource.updateSuppDatum() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return 0;
        }
    }

    public boolean insertSuppDatumXref(SuppDatum sd) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "INSERT INTO supp_data_xref (sdid, cid, colid, rid) VALUES (" + sd.sdid + "," + sd.cid + "," + sd.colid + "," + sd.rid + ");";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.execute();
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals("23000")) {
                logger.log(Level.SEVERE, "SQLDataSource.insertSuppDatumXref() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
                return false;
            }
            logger.info("SQLDataSource.insertSuppDatumXref: SDID " + sd.sdid + " xref already exists for given parameters");
        }
        return true;
    }

    public int insertSuppDataType(SuppDatum sd) {
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "INSERT INTO supp_data_type (supp_data_type,supp_color,draw_line) VALUES (\"" + sd.typeName + "\",\"" + sd.color + "\"," + sd.dl + ");";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.ps.execute();
            this.rs = this.ps.getGeneratedKeys();
            this.rs.next();
            return this.rs.getInt(1);
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals("23000")) {
                logger.log(Level.SEVERE, "SQLDataSource.insertSuppDataType() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
                return 0;
            }
            try {
                this.sql = "SELECT sdid FROM supp_data WHERE sdtypeid=" + sd.tid + " AND st=" + sd.st + " AND et=" + sd.et + " AND sd_short='" + sd.name + "'";
                this.ps = this.database.getPreparedStatement(this.sql);
                this.rs = this.ps.executeQuery();
                this.rs.next();
                return -this.rs.getInt(1);
            }
            catch (SQLException e2) {
                logger.log(Level.SEVERE, "SQLDataSource.insertSuppDataType() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e2);
                return 0;
            }
        }
    }

    protected RequestResult getSuppData(Map<String, String> params, boolean cm) {
        SuppDatum sd_s;
        double et;
        double st;
        String arg = null;
        List<SuppDatum> data = null;
        String tz = params.get("tz");
        if (tz == null || tz.equals("")) {
            tz = "UTC";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        df.setTimeZone(TimeZone.getTimeZone(tz));
        try {
            arg = params.get("st");
            st = Util.dateToJ2K(df.parse(arg));
            arg = params.get("et");
            et = arg == null || arg.equals("") ? Double.MAX_VALUE : Util.dateToJ2K(df.parse(arg));
        }
        catch (Exception e) {
            return SQLDataSource.getErrorResult("Illegal time string: " + arg + ", " + e);
        }
        arg = params.get("byID");
        if (arg != null && arg.equals("true")) {
            sd_s = new SuppDatum((Double)st, (Double)et, -1, -1, -1, -1);
            String[] args = new String[]{"ch", "col", "rk", "type"};
            for (int i = 0; i < 4; ++i) {
                arg = params.get(args[i]);
                args[i] = arg == null || arg.equals("") ? null : arg;
            }
            sd_s.chName = args[0];
            if (sd_s.chName != null) {
                sd_s.cid = 0;
            }
            sd_s.colName = args[1];
            if (sd_s.colName != null) {
                sd_s.colid = 0;
            }
            sd_s.rkName = args[2];
            if (sd_s.rkName != null) {
                sd_s.rid = 0;
            }
            sd_s.typeName = args[3];
            if (sd_s.typeName != null) {
                sd_s.tid = 0;
            }
        } else {
            String chName = params.get("ch");
            String colName = params.get("col");
            String rkName = params.get("rk");
            String typeName = params.get("type");
            sd_s = new SuppDatum((Double)st, (Double)et, chName, colName, rkName, typeName);
        }
        arg = params.get("dl");
        if (arg != null) {
            sd_s.dl = Integer.parseInt(arg);
        }
        if ((data = this.getMatchingSuppData(sd_s, cm)) != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (SuppDatum sd : data) {
                result.add(String.format("%d,%1.3f,%1.3f,%d,%d,%d,%d,%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", sd.sdid, sd.st, sd.et, sd.cid, sd.tid, sd.colid, sd.rid, sd.dl, sd.name, sd.value.replace('\n', '\u0000'), sd.chName, sd.typeName, sd.colName, sd.rkName, sd.color));
            }
            return new TextResult(result);
        }
        return null;
    }

    public List<SuppDatum> getSuppDataTypes() {
        ArrayList<SuppDatum> types = new ArrayList<SuppDatum>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT sdtypeid, supp_data_type, supp_color, draw_line FROM supp_data_type";
            this.ps = this.database.getPreparedStatement(this.sql);
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                SuppDatum sd = new SuppDatum((Double)0.0, (Double)0.0, -1, -1, -1, this.rs.getInt(1));
                sd.typeName = this.rs.getString(2);
                sd.color = this.rs.getString(3);
                sd.dl = this.rs.getInt(4);
                types.add(sd);
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.getSuppDataTypes() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
            return null;
        }
        return types;
    }

    public RequestResult getSuppTypes(boolean drawOnly) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.database.useDatabase(this.dbName);
            this.sql = "SELECT sdtypeid, supp_data_type, supp_color, draw_line FROM supp_data_type";
            if (drawOnly) {
                this.sql = this.sql + " WHERE draw_line=1";
            }
            this.rs = this.database.getPreparedStatement(this.sql + " ORDER BY supp_data_type").executeQuery();
            while (this.rs.next()) {
                result.add(String.format("%d\"%d\"%s\"%s", this.rs.getInt(1), this.rs.getInt(4), this.rs.getString(2), this.rs.getString(3)));
            }
            this.rs.close();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLDataSource.defaultGetSuppdataTypes() failed. (" + this.database.getDatabasePrefix() + "_" + this.dbName + ")", e);
        }
        return new TextResult(result);
    }
}

