/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import java.sql.ResultSet;
import java.sql.SQLException;

public class SuppDatum {
    public int sdid;
    public int cid;
    public String chName;
    public int colid;
    public String colName;
    public int rid;
    public String rkName;
    public String name;
    public String value;
    public Double st;
    public Double et;
    public int tid;
    public String typeName;
    public String color;
    public int dl;
    public int frame_y;
    public int frame_h;

    public SuppDatum() {
    }

    private String empty2null(String s) {
        if (s.length() == 0) {
            return null;
        }
        return s;
    }

    private int str2int(String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        return Integer.parseInt(s);
    }

    private double str2dbl(String s) {
        if (s == null || s.length() == 0) {
            return -1.0;
        }
        return Double.parseDouble(s);
    }

    public SuppDatum(String str) {
        String[] qp = str.replace('\u0000', '\n').split("\"");
        this.name = this.empty2null(qp[1]);
        this.value = this.empty2null(qp[3]);
        this.chName = this.empty2null(qp[5]);
        this.typeName = this.empty2null(qp[7]);
        this.colName = this.empty2null(qp[9]);
        this.rkName = this.empty2null(qp[11]);
        this.color = this.empty2null(qp[13]);
        qp = qp[0].split(",");
        this.sdid = this.str2int(qp[0]);
        this.st = this.str2dbl(qp[1]);
        this.et = this.str2dbl(qp[2]);
        this.cid = this.str2int(qp[3]);
        this.tid = this.str2int(qp[4]);
        this.colid = this.str2int(qp[5]);
        this.rid = this.str2int(qp[6]);
        this.dl = this.str2int(qp[7]);
    }

    public SuppDatum(Double st, Double et, int cid, int colid, int rid, int tid) {
        this.sdid = 0;
        this.cid = cid;
        this.chName = null;
        this.colid = colid;
        this.colName = null;
        this.rid = rid;
        this.rkName = null;
        this.name = null;
        this.value = null;
        this.st = st;
        this.et = et;
        this.tid = tid;
        this.typeName = null;
        this.dl = -1;
    }

    public SuppDatum(Double st, Double et, String chName, String colName, String rkName, String typeName) {
        this.sdid = 0;
        this.cid = -1;
        this.chName = chName;
        this.colid = -1;
        this.colName = colName;
        this.rid = -1;
        this.rkName = rkName;
        this.name = null;
        this.value = null;
        this.st = st;
        this.et = et;
        this.tid = -1;
        this.typeName = typeName;
        this.dl = -1;
    }

    public SuppDatum(ResultSet rs) throws SQLException {
        this.sdid = rs.getInt(1);
        this.tid = rs.getInt(2);
        this.st = rs.getDouble(3);
        this.et = rs.getDouble(4);
        this.name = rs.getString(5);
        this.value = rs.getString(6);
        this.chName = rs.getString(7);
        this.colName = rs.getString(8);
        this.rkName = rs.getString(9);
        this.typeName = rs.getString(10);
        this.color = rs.getString(11);
        this.cid = rs.getInt(12);
        this.colid = rs.getInt(13);
        this.rid = rs.getInt(14);
        this.dl = rs.getInt(15);
    }

    public void adjustTime(double adj) {
        this.st = this.st + adj;
        this.et = this.et + adj;
    }

    public String toXML() {
        return this.toXML(false);
    }

    public String toXML(boolean addFrameInfo) {
        String[] names;
        StringBuffer sb = new StringBuffer();
        sb.append("<suppdatum>\n");
        sb.append("<![CDATA[" + this.sdid + "\"" + this.tid + "\"" + this.st + "\"" + this.et + "\"" + this.cid + "\"" + this.colid + "\"" + this.rid + "\"" + this.dl);
        for (String s : names = new String[]{this.name, this.value, this.chName, this.colName, this.rkName, this.typeName, this.color}) {
            sb.append("\"" + (s == null ? "" : s));
        }
        if (addFrameInfo) {
            sb.append("\"" + this.frame_y + "\"" + this.frame_h);
        }
        sb.append("]]>\n</suppdatum>\n");
        return sb.toString();
    }
}

