/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data;

import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.BinaryDataSet;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.MetaDatum;
import gov.usgs.vdx.data.SuppDatum;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import gov.usgs.winston.Channel;
import gov.usgs.winston.db.Channels;
import gov.usgs.winston.db.Data;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public abstract class VDXSource
implements DataSource {
    protected WinstonDatabase winston;
    protected Data data;
    protected Channels channels;
    protected String vdxName;
    private int maxrows = 0;

    @Override
    public void initialize(ConfigFile cf) {
        if (this.winston == null) {
            String driver = cf.getString("driver");
            String prefix = cf.getString("prefix");
            String url = cf.getString("url");
            this.vdxName = cf.getName();
            this.maxrows = Util.stringToInt(cf.getString("maxrows"), 0);
            int cacheCap = Util.stringToInt(cf.getString("statementCacheCap"), 100);
            this.winston = new WinstonDatabase(driver, url, prefix, cacheCap);
        }
        this.data = new Data(this.winston);
        this.data.setVdxName(this.vdxName);
        this.channels = new Channels(this.winston);
    }

    public void defaultDisconnect() {
        this.winston.close();
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action.equals("channels")) {
            List<Channel> chs = this.channels.getChannels();
            ArrayList<String> result = new ArrayList<String>();
            for (Channel ch : chs) {
                result.add(ch.toVDXString());
            }
            return new TextResult(result);
        }
        if (action.equals("data") || action == null) {
            int cid = Integer.parseInt(params.get("ch"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.NONE;
            int dsInt = 0;
            try {
                ds = DownsamplingType.fromString(params.get("ds"));
                dsInt = Integer.parseInt(params.get("dsInt"));
            }
            catch (Exception e) {
                // empty catch block
            }
            String code = this.channels.getChannelCode(cid);
            BinaryDataSet data = null;
            try {
                data = this.getData(code, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return this.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else {
            if (action.equals("suppdata")) {
                SuppDatum sd_s;
                double et;
                double st;
                String arg = null;
                List<SuppDatum> data = null;
                String tz = params.get("tz");
                if (tz == null || tz.equals("")) {
                    tz = "UTC";
                }
                SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
                df.setTimeZone(TimeZone.getTimeZone(tz));
                try {
                    arg = params.get("st");
                    st = Util.dateToJ2K(df.parse(arg));
                    arg = params.get("et");
                    et = arg == null || arg.equals("") ? Double.MAX_VALUE : Util.dateToJ2K(df.parse(arg));
                }
                catch (Exception e) {
                    return this.getErrorResult("Illegal time string: " + arg + ", " + e);
                }
                arg = params.get("byID");
                if (arg != null && arg.equals("true")) {
                    sd_s = new SuppDatum((Double)st, (Double)et, -1, -1, -1, -1);
                    String[] args = new String[]{"ch", "col", "rk", "type"};
                    for (int i = 0; i < 4; ++i) {
                        arg = params.get(args[i]);
                        args[i] = arg == null || arg.equals("") ? null : arg;
                    }
                    sd_s.chName = args[0];
                    if (sd_s.chName != null) {
                        sd_s.cid = 0;
                    }
                    sd_s.colName = args[1];
                    if (sd_s.colName != null) {
                        sd_s.colid = 0;
                    }
                    sd_s.rkName = args[2];
                    if (sd_s.rkName != null) {
                        sd_s.rid = 0;
                    }
                    sd_s.typeName = args[3];
                    if (sd_s.typeName != null) {
                        sd_s.tid = 0;
                    }
                } else {
                    String chName = params.get("ch");
                    String colName = params.get("col");
                    String rkName = params.get("rk");
                    String typeName = params.get("type");
                    sd_s = new SuppDatum((Double)st, (Double)et, chName, colName, rkName, typeName);
                }
                arg = params.get("dl");
                if (arg != null) {
                    sd_s.dl = Integer.parseInt(arg);
                }
                try {
                    data = this.getMatchingSuppData(sd_s, false);
                }
                catch (Exception e) {
                    return this.getErrorResult(e.getMessage());
                }
                if (data != null) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (SuppDatum sd : data) {
                        result.add(String.format("%d,%1.3f,%1.3f,%d,%d,%d,%d,%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", sd.sdid, sd.st, sd.et, sd.cid, sd.tid, sd.colid, sd.rid, sd.dl, sd.name, sd.value.replace('\n', '\u0000'), sd.chName, sd.typeName, sd.colName, sd.rkName, sd.color));
                    }
                    return new TextResult(result);
                }
                return null;
            }
            if (action.equals("metadata")) {
                MetaDatum md_s;
                String arg = params.get("byID");
                List<MetaDatum> data = null;
                if (arg != null && arg.equals("true")) {
                    int cid = Integer.parseInt(params.get("ch"));
                    md_s = new MetaDatum(cid, -1, -1);
                } else {
                    String chName = params.get("ch");
                    md_s = new MetaDatum(chName, null, null);
                }
                try {
                    data = this.getMatchingMetaData(md_s, false);
                }
                catch (Exception e) {
                    return this.getErrorResult(e.getMessage());
                }
                if (data != null) {
                    ArrayList<String> result = new ArrayList<String>();
                    for (MetaDatum md : data) {
                        result.add(md.cmid + "," + md.cid + ",\"" + md.name + "\",\"" + md.value + "\",\"" + md.chName + "\"");
                    }
                    return new TextResult(result);
                }
            } else if (action.equals("supptypes")) {
                try {
                    return this.getSuppTypes(true);
                }
                catch (Exception e) {
                    return this.getErrorResult(e.getMessage());
                }
            }
        }
        return null;
    }

    @Override
    public int getMaxRows() {
        return this.maxrows;
    }

    protected void setMaxRows(int maxrows) {
        this.maxrows = maxrows;
    }

    public RequestResult getErrorResult(String errMessage) {
        ArrayList<String> text = new ArrayList<String>();
        text.add(errMessage);
        TextResult result = new TextResult(text);
        result.setError(true);
        return result;
    }

    private List<MetaDatum> getMatchingMetaData(MetaDatum md, boolean cm) throws Exception {
        this.winston.useRootDatabase();
        String sql = "SELECT MD.cmid, MD.sid, -1, -1, MD.name, MD.value, CH.code, \"\", \"\" FROM channelmetadata as MD, channels as CH ";
        String where = "WHERE MD.sid=CH.sid";
        if (md.chName != null) {
            where = where + " AND CH.code='" + md.chName + "'";
        } else if (md.cid >= 0) {
            where = where + " AND MD.cid=" + md.cid;
        }
        if (md.name != null) {
            where = where + " AND MD.name=" + md.name;
        }
        if (md.name != null) {
            where = where + " AND MD.value=" + md.value;
        }
        PreparedStatement ps = this.winston.getPreparedStatement(sql + where);
        ResultSet rs = ps.executeQuery();
        ArrayList<MetaDatum> result = new ArrayList<MetaDatum>();
        while (rs.next()) {
            md = new MetaDatum();
            md.cmid = rs.getInt(1);
            md.cid = rs.getInt(2);
            md.colid = rs.getInt(3);
            md.rid = rs.getInt(4);
            md.name = rs.getString(5);
            md.value = rs.getString(6);
            md.chName = rs.getString(7);
            md.colName = rs.getString(8);
            md.rkName = rs.getString(9);
            result.add(md);
        }
        rs.close();
        return result;
    }

    private List<SuppDatum> getMatchingSuppData(SuppDatum sd, boolean cm) {
        this.winston.useRootDatabase();
        String sql = "SELECT SD.sdid, -1, SD.st, SD.et, SD.sd_short, SD.sd, CH.code, \"\", \"\", ST.supp_data_type, ST.supp_color, SX.cid, -1, -1, ST.draw_line FROM supp_data as SD, channels as CH, supp_data_type as ST, supp_data_xref as SX ";
        String where = "WHERE SD.et >= " + sd.st + " AND SD.st <= " + sd.et + " AND SD.sdid=SX.sdid AND SD.sdtypeid=ST.sdtypeid AND SX.cid=CH.sid";
        if (sd.chName != null) {
            where = sd.cid < 0 ? where + " AND CH.code='" + sd.chName + "'" : where + " AND CH.sid IN (" + sd.chName + ")";
        } else if (sd.cid >= 0) {
            where = where + " AND CH.sid=" + sd.cid;
        }
        if (sd.name != null) {
            where = where + " AND SD.sd_short=" + sd.name;
        }
        if (sd.value != null) {
            where = where + " AND SD.sd=" + sd.value;
        }
        String type_filter = null;
        if (sd.typeName != null) {
            if (sd.typeName.length() != 0) {
                type_filter = sd.tid == -1 ? "ST.supp_data_type='" + sd.typeName + "'" : "ST.sdtypeid IN (" + sd.typeName + ")";
            }
        } else if (sd.tid >= 0) {
            type_filter = "SD.sdtypeid=" + sd.tid;
        }
        if (sd.dl == -1) {
            if (type_filter != null) {
                where = where + " AND " + type_filter;
            }
        } else if (sd.dl < 2) {
            if (type_filter != null) {
                where = where + " AND " + type_filter;
            }
            where = where + " AND ST.dl='" + sd.dl;
        } else {
            where = type_filter != null ? where + " AND (" + type_filter + " OR ST.draw_line='0')" : where + " AND ST.draw_line='0'";
        }
        PreparedStatement ps = this.winston.getPreparedStatement(sql + where);
        ArrayList<SuppDatum> result = new ArrayList<SuppDatum>();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new SuppDatum(rs));
            }
            rs.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return result;
    }

    public void insertMetaDatum(MetaDatum md) throws Exception {
        this.winston.useRootDatabase();
        String sql = "INSERT INTO channelmetadata (sid,name,value) VALUES (" + md.cid + ",\"" + md.name + "\",\"" + md.value + "\");";
        PreparedStatement ps = this.winston.getPreparedStatement(sql);
        ps.execute();
    }

    public void updateMetaDatum(MetaDatum md) throws Exception {
        this.winston.useRootDatabase();
        String sql = "UPDATE channelmetadata SET sid='" + md.cid + "', name='" + md.name + "', value='" + md.value + "' WHERE cmid='" + md.cmid + "'";
        PreparedStatement ps = this.winston.getPreparedStatement(sql);
        ps.execute();
    }

    public Channels getChannels() {
        return this.channels;
    }

    public List<SuppDatum> getSuppDataTypes() throws Exception {
        ArrayList<SuppDatum> types = new ArrayList<SuppDatum>();
        this.winston.useRootDatabase();
        String sql = "SELECT * FROM supp_data_type ORDER BY supp_data_type";
        PreparedStatement ps = this.winston.getPreparedStatement(sql);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            SuppDatum sd = new SuppDatum((Double)0.0, (Double)0.0, -1, -1, -1, rs.getInt(1));
            sd.typeName = rs.getString(2);
            sd.color = rs.getString(3);
            sd.dl = rs.getInt(4);
            types.add(sd);
        }
        rs.close();
        return types;
    }

    public int insertSuppDatum(SuppDatum sd) throws Exception {
        try {
            this.winston.useRootDatabase();
            String sql = "INSERT INTO supp_data (sdtypeid,st,et,sd_short,sd) VALUES (" + sd.tid + "," + sd.st + "," + sd.et + ",\"" + sd.name + "\",\"" + sd.value + "\")";
            PreparedStatement ps = this.winston.getPreparedStatement(sql);
            ps.execute();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals("23000")) {
                throw e;
            }
            String sql = "SELECT sdid FROM supp_data WHERE sdtypeid=" + sd.tid + " AND st=" + sd.st + " AND et=" + sd.et + " AND sd_short='" + sd.name + "'";
            PreparedStatement ps = this.winston.getPreparedStatement(sql);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return -rs.getInt(1);
        }
    }

    public int updateSuppDatum(SuppDatum sd) throws Exception {
        this.winston.useRootDatabase();
        String sql = "UPDATE supp_data SET sdtypeid='" + sd.tid + "',st='" + sd.st + "',et='" + sd.et + "',sd_short='" + sd.name + "',sd='" + sd.value + "' WHERE sdid='" + sd.sdid + "'";
        PreparedStatement ps = this.winston.getPreparedStatement(sql);
        ps.execute();
        return sd.sdid;
    }

    public boolean insertSuppDatumXref(SuppDatum sd) throws Exception {
        try {
            this.winston.useRootDatabase();
            String sql = "INSERT INTO supp_data_xref (sdid, cid) VALUES (" + sd.sdid + "," + sd.cid + ");";
            PreparedStatement ps = this.winston.getPreparedStatement(sql);
            ps.execute();
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals("23000")) {
                throw e;
            }
            return false;
        }
        return true;
    }

    public int insertSuppDataType(SuppDatum sd) throws Exception {
        try {
            String sql = "INSERT INTO supp_data_type (supp_data_type,supp_color,draw_line) VALUES (\"" + sd.typeName + "\",\"" + sd.color + "\"," + sd.dl + ");";
            PreparedStatement ps = this.winston.getPreparedStatement(sql);
            ps.execute();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            return rs.getInt(1);
        }
        catch (SQLException e) {
            if (!e.getSQLState().equals("23000")) {
                throw e;
            }
            String sql = "SELECT sdid FROM supp_data WHERE sdtypeid=" + sd.tid + " AND st=" + sd.st + " AND et=" + sd.et + " AND sd_short='" + sd.name + "'";
            PreparedStatement ps = this.winston.getPreparedStatement(sql);
            ResultSet rs = ps.executeQuery();
            rs.next();
            return -rs.getInt(1);
        }
    }

    protected RequestResult getSuppData(Map<String, String> params, boolean cm) {
        SuppDatum sd_s;
        double et;
        double st;
        String arg = null;
        List<SuppDatum> data = null;
        String tz = params.get("tz");
        if (tz == null || tz == "") {
            tz = "UTC";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        df.setTimeZone(TimeZone.getTimeZone(tz));
        try {
            arg = params.get("st");
            st = Util.dateToJ2K(df.parse(arg));
            arg = params.get("et");
            et = arg == null || arg == "" ? Double.MAX_VALUE : Util.dateToJ2K(df.parse(arg));
        }
        catch (Exception e) {
            return this.getErrorResult("Illegal time string: " + arg + ", " + e);
        }
        arg = params.get("byID");
        if (arg != null && arg.equals("true")) {
            int cid = Integer.parseInt(params.get("ch"));
            arg = params.get("et");
            et = arg == null || arg == "" ? Double.MAX_VALUE : Double.parseDouble(arg);
            arg = params.get("type");
            int tid = arg == null || arg == "" ? -1 : Integer.parseInt(arg);
            sd_s = new SuppDatum((Double)st, (Double)et, cid, -1, -1, tid);
        } else {
            String chName = params.get("ch");
            String typeName = params.get("type");
            sd_s = new SuppDatum((Double)st, (Double)et, chName, null, null, typeName);
        }
        data = this.getMatchingSuppData(sd_s, cm);
        if (data != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (SuppDatum sd : data) {
                result.add(String.format("%d,%1.3f,%1.3f,%d,%d,%d,%d,%d,\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\",\"%s\"", sd.sdid, sd.st, sd.et, sd.cid, sd.tid, sd.colid, sd.rid, sd.dl, sd.name, sd.value.replace('\n', '\u0000'), sd.chName, sd.typeName, sd.colName, sd.rkName, sd.color));
            }
            return new TextResult(result);
        }
        return null;
    }

    public RequestResult getSuppTypes(boolean drawOnly) throws Exception {
        this.winston.useRootDatabase();
        ArrayList<String> result = new ArrayList<String>();
        String sql = "SELECT * FROM supp_data_type";
        if (drawOnly) {
            sql = sql + " WHERE draw_line=1";
        }
        ResultSet rs = this.winston.getPreparedStatement(sql + " ORDER BY supp_data_type").executeQuery();
        while (rs.next()) {
            result.add(String.format("%d\"%d\"%s\"%s", rs.getInt(1), rs.getInt(4), rs.getString(2), rs.getString(3)));
        }
        rs.close();
        return new TextResult(result);
    }

    public abstract void disconnect();

    protected abstract BinaryDataSet getData(String var1, double var2, double var4, int var6, DownsamplingType var7, int var8) throws UtilException;
}

