/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.generic.fixed;

import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.DataSource;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.server.BinaryResult;
import gov.usgs.vdx.server.RequestResult;
import gov.usgs.vdx.server.TextResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class SQLGenericFixedDataSource
extends SQLDataSource
implements DataSource {
    public final String DATABASE_NAME = "genericfixed";
    public final boolean channels = true;
    public final boolean translations = true;
    public final boolean channelTypes = false;
    public final boolean ranks = true;
    public final boolean columns = true;
    public final boolean menuColumns = false;

    @Override
    public String getType() {
        return "genericfixed";
    }

    @Override
    public boolean getChannelsFlag() {
        return true;
    }

    @Override
    public boolean getTranslationsFlag() {
        return true;
    }

    @Override
    public boolean getChannelTypesFlag() {
        return false;
    }

    @Override
    public boolean getRanksFlag() {
        return true;
    }

    @Override
    public boolean getColumnsFlag() {
        return true;
    }

    @Override
    public boolean getMenuColumnsFlag() {
        return false;
    }

    @Override
    public void initialize(ConfigFile params) {
        this.defaultInitialize(params);
        if (!this.databaseExists()) {
            this.createDatabase();
        }
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    public boolean databaseExists() {
        return this.defaultDatabaseExists();
    }

    @Override
    public boolean createDatabase() {
        try {
            this.defaultCreateDatabase(true, true, false, true, true, false);
            logger.log(Level.INFO, "SQLGenericFixedDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") succeeded.");
            return true;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "SQLGenericFixedDataSource.createDatabase(" + this.database.getDatabasePrefix() + "_" + this.dbName + ") failed.", e);
            return false;
        }
    }

    public boolean createChannel(String channelCode, String channelName, double lon, double lat, double height, int active, int tid) {
        return this.defaultCreateChannel(channelCode, channelName, lon, lat, height, active, tid, true, true, true, true);
    }

    public boolean createTranslation() {
        return this.defaultCreateTranslation();
    }

    @Override
    public RequestResult getData(Map<String, String> params) {
        String action = params.get("action");
        if (action == null) {
            return null;
        }
        if (action.equals("channels")) {
            return new TextResult(this.defaultGetChannels(false));
        }
        if (action.equals("columns")) {
            return new TextResult(this.defaultGetMenuColumns(false));
        }
        if (action.equals("ranks")) {
            return new TextResult(this.defaultGetRanks());
        }
        if (action.equals("data")) {
            int cid = Integer.parseInt(params.get("ch"));
            int rid = Integer.parseInt(params.get("rk"));
            double st = Double.parseDouble(params.get("st"));
            double et = Double.parseDouble(params.get("et"));
            DownsamplingType ds = DownsamplingType.fromString(params.get("ds"));
            int dsInt = Integer.parseInt(params.get("dsInt"));
            GenericDataMatrix data = null;
            try {
                data = this.getGenericFixedData(cid, rid, st, et, this.getMaxRows(), ds, dsInt);
            }
            catch (UtilException e) {
                return SQLGenericFixedDataSource.getErrorResult(e.getMessage());
            }
            if (data != null) {
                return new BinaryResult(data);
            }
        } else {
            if (action.equals("genericMenu")) {
                return new TextResult(this.getGenericMenu());
            }
            if (action.equals("supptypes")) {
                return this.getSuppTypes(true);
            }
            if (action.equals("suppdata")) {
                return this.getSuppData(params, false);
            }
            if (action.equals("metadata")) {
                return this.getMetaData(params, false);
            }
        }
        return null;
    }

    private List<String> getGenericMenu() {
        ArrayList<String> genericMenuString = new ArrayList<String>();
        return genericMenuString;
    }

    public GenericDataMatrix getGenericFixedData(int cid, int rid, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        return this.defaultGetData(cid, rid, st, et, true, true, maxrows, ds, dsInt);
    }

    public String getChannelString(Map<String, String> metadata) {
        String ss = metadata.get("channelString");
        if (ss == null) {
            return "Channels";
        }
        return ss;
    }

    public String getDescription(Map<String, String> metadata) {
        String d = metadata.get("description");
        if (d == null) {
            return "no description";
        }
        return d;
    }

    public String getTitle(Map<String, String> metadata) {
        String t = metadata.get("title");
        if (t == null) {
            return "Generic Data";
        }
        return t;
    }

    public String getTimeShortcuts(Map<String, String> metadata) {
        String ts = metadata.get("timeShortcuts");
        if (ts == null) {
            return "-6h,-24h,-3d,-1w,-1m,-1y";
        }
        return ts;
    }
}

