/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.data.rsam;

import gov.usgs.math.DownsamplingType;
import gov.usgs.plot.data.BinaryDataSet;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.util.UtilException;
import gov.usgs.vdx.data.VDXSource;

public class RatSAMSource
extends VDXSource {
    @Override
    public String getType() {
        return "rsam";
    }

    @Override
    public void disconnect() {
        this.defaultDisconnect();
    }

    @Override
    protected BinaryDataSet getData(String channel, double st, double et, int maxrows, DownsamplingType ds, int dsInt) throws UtilException {
        RSAMData d1 = null;
        RSAMData d2 = null;
        String[] channels = channel.split(",");
        if (channels.length == 2) {
            d1 = this.data.getRSAMData(channels[0], st, et, maxrows, ds, dsInt);
            d2 = this.data.getRSAMData(channels[1], st, et, maxrows, ds, dsInt);
        }
        return d1.getRatSAM(d2);
    }
}

