/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.util.Time;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Rank;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLNullDataSource;
import gov.usgs.vdx.data.rsam.SQLEWRSAMDataSource;
import gov.usgs.vdx.in.ImportFile;
import gov.usgs.vdx.in.Importer;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportBob
implements Importer {
    public ResourceReader rr;
    public static Set<String> flags = new HashSet<String>();
    public static Set<String> keys = new HashSet<String>();
    public String vdxConfig;
    public ConfigFile params;
    public ConfigFile vdxParams;
    public ConfigFile rankParams;
    public ConfigFile columnParams;
    public ConfigFile channelParams;
    public ConfigFile dataSourceParams;
    public ConfigFile translationParams;
    public String driver;
    public String prefix;
    public String url;
    public SimpleDateFormat dateIn;
    public SimpleDateFormat dateOut;
    public Date date;
    public Double j2ksec;
    public String filenameMask;
    public int headerLines;
    public String timestamp;
    public String timezone;
    public Rank rank;
    public String rankName;
    public int rankValue;
    public int rankDefault;
    public int rid;
    public SQLDataSource sqlDataSource;
    public Logger logger;
    public int goodCount;
    public double[] t;
    public float[] d;
    private int year;
    private static final String CONFIG_FILE = "VDX.config";
    Map<String, SQLDataSource> sources;

    public ImportBob(String cf, int y, String n, String t) {
        this.year = y;
        this.params = new ConfigFile(cf);
        this.params.put("vdx.name", n);
        if (this.params == null) {
            System.out.println("Can't parse config file " + cf);
        }
        this.params.put("type", t);
        this.sources = new HashMap<String, SQLDataSource>();
        this.sources.put("ewrsamEvents", new SQLEWRSAMDataSource("Events"));
        this.sources.put("ewrsamValues", new SQLEWRSAMDataSource("Values"));
        this.sources.put("null", new SQLNullDataSource());
    }

    @Override
    public void initialize(String importerClass, String configFile, boolean verbose) {
        this.logger = Logger.getLogger(importerClass);
        this.logger.log(Level.INFO, "ImportBob.initialize() succeeded.");
        this.processConfigFile(configFile);
    }

    @Override
    public void deinitialize() {
        this.sqlDataSource.disconnect();
    }

    @Override
    public void processConfigFile(String configFile) {
        this.logger.log(Level.INFO, "Reading config file " + configFile);
        this.params = new ConfigFile(configFile);
        if (!this.params.wasSuccessfullyRead()) {
            this.logger.log(Level.SEVERE, configFile + " was not successfully read");
            System.exit(-1);
        }
        this.vdxConfig = Util.stringToString(this.params.getString("vdx.config"), CONFIG_FILE);
        if (this.vdxConfig == null) {
            this.logger.log(Level.SEVERE, "vdx.config parameter missing from config file");
            System.exit(-1);
        }
        this.vdxParams = new ConfigFile(this.vdxConfig);
        this.driver = this.vdxParams.getString("vdx.driver");
        this.url = this.vdxParams.getString("vdx.url");
        this.prefix = this.vdxParams.getString("vdx.prefix");
        this.filenameMask = Util.stringToString(this.params.getString("filenameMask"), "");
        this.headerLines = Util.stringToInt(this.params.getString("headerLines"), 0);
        this.timestamp = Util.stringToString(this.params.getString("timestamp"), "yyyy-MM-dd HH:mm:ss");
        this.timezone = Util.stringToString(this.params.getString("timezone"), "GMT");
        this.dateIn = new SimpleDateFormat(this.timestamp);
        this.dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateIn.setTimeZone(TimeZone.getTimeZone(this.timezone));
        this.dateOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.rankParams = this.params.getSubConfig("rank");
        this.rankName = Util.stringToString(this.rankParams.getString("name"), "DEFAULT");
        this.rankValue = Util.stringToInt(this.rankParams.getString("value"), 1);
        this.rankDefault = Util.stringToInt(this.rankParams.getString("default"), 0);
        this.rank = new Rank(0, this.rankName, this.rankValue, this.rankDefault);
    }

    @Override
    public void process(String filename) {
    }

    @Override
    public void outputInstructions(String importerClass, String message) {
        if (message == null) {
            System.err.println(message);
        }
        System.err.println(importerClass + " -c configfile filelist");
    }

    public void process(String c, String f) {
        String type = this.params.getString("type");
        String name = this.params.getString("name");
        SQLDataSource sds = this.sources.get(type);
        if (sds == null) {
            System.out.println("I don't know what to do with type " + type);
            System.exit(-1);
        }
    }

    public DoubleMatrix2D parseFile(String fn) {
        DoubleMatrix2D data = null;
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fn)));
            short absoluteRecordSize = Util.swap(dis.readShort());
            int samplesPerRecord = absoluteRecordSize / 4;
            double dt = 86400.0 / (double)samplesPerRecord;
            double time = Time.parse("yyyyMMDD", this.year + "0101");
            dis.readShort();
            dis.skip(absoluteRecordSize - 4);
            GregorianCalendar cal = new GregorianCalendar();
            boolean leapYear = cal.isLeapYear(this.year);
            int numRecords = 365;
            if (leapYear) {
                ++numRecords;
            }
            data = DoubleFactory2D.dense.make(numRecords * samplesPerRecord, 2);
            System.err.println("records: " + numRecords);
            System.err.println("record size: " + absoluteRecordSize);
            System.err.println("expected samples: " + numRecords * samplesPerRecord);
            System.err.println("expected filesize: " + absoluteRecordSize * (numRecords + 1));
            this.goodCount = 0;
            for (int i = 0; i < numRecords * samplesPerRecord; ++i) {
                float value = Float.intBitsToFloat(Util.swap(dis.readInt()));
                if (value != -998.0f) {
                    data.setQuick(this.goodCount, 0, time);
                    data.setQuick(this.goodCount++, 1, (double)value);
                }
                time += dt;
            }
            System.err.println("good count: " + this.goodCount);
            dis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static void main(String[] as) {
        ImportFile importer = new ImportFile();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        if (args.contains("-c")) {
            importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
            importer.outputInstructions(importer.getClass().getName(), "Config file required");
            System.exit(-1);
        }
        importer.initialize(importer.getClass().getName(), args.get("-c"), args.flagged("-v"));
        List<String> files = args.unused();
        for (String file : files) {
            importer.process(file);
        }
        importer.deinitialize();
    }

    static {
        keys.add("-c");
        flags.add("-h");
        flags.add("-v");
    }
}

