/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in;

import gov.usgs.util.Arguments;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.ResourceReader;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.Column;
import gov.usgs.vdx.data.DataSourceDescriptor;
import gov.usgs.vdx.data.DataSourceHandler;
import gov.usgs.vdx.data.SQLDataSource;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.data.SuppDatum;
import gov.usgs.vdx.data.VDXSource;
import gov.usgs.vdx.db.VDXDatabase;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportSuppdata {
    private static Set<String> flags = new HashSet<String>();
    private static Set<String> keys = new HashSet<String>();
    private Logger logger;
    private Map<String, Integer> channelMap;
    private Map<String, Integer> columnMap;
    private Map<String, Integer> rankMap;
    private Map<String, Integer> sdtypeMap;
    private VDXDatabase database;
    private ConfigFile vdxParams;
    private DataSourceHandler dataSourceHandler;
    private SQLDataSourceHandler sqlDataSourceHandler;

    public void initialize(String importerClass, String configFile) {
        this.logger = Logger.getLogger(importerClass);
        this.logger.info("ImportSuppdata.initialize() succeeded.");
        this.processConfigFile(configFile);
    }

    public void deinitialize() {
        this.database.close();
    }

    public void processConfigFile(String vdxConfig) {
        this.vdxParams = new ConfigFile(vdxConfig);
        String driver = this.vdxParams.getString("vdx.driver");
        String url = this.vdxParams.getString("vdx.url");
        String prefix = this.vdxParams.getString("vdx.prefix");
        this.database = new VDXDatabase(driver, url, prefix);
        this.dataSourceHandler = new DataSourceHandler(driver, url, prefix);
        this.sqlDataSourceHandler = new SQLDataSourceHandler(driver, url, prefix);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(String pathname) {
        int lineLen2;
        int lineLen1;
        File file = new File(pathname);
        String filename = file.getName();
        String source = filename.substring(5, filename.length() - 19);
        SQLDataSourceDescriptor dsd = this.sqlDataSourceHandler.getDataSourceDescriptor(source);
        if (dsd == null) {
            this.logger.log(Level.SEVERE, "skipping: " + pathname + " (datasource is invalid)");
            return;
        }
        SQLDataSource ds = null;
        VDXSource vds = null;
        try {
            SQLDataSource ods = dsd.getSQLDataSource();
            if (ods != null) {
                ds = dsd.getSQLDataSource();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int defaultRank = 0;
        if (ds != null) {
            this.channelMap = new HashMap<String, Integer>();
            for (Channel ch : ds.defaultGetChannelsList(false)) {
                this.channelMap.put(ch.getCode(), ch.getCID());
            }
            this.logger.info("Channels mapped: " + this.channelMap.size());
            this.columnMap = new HashMap<String, Integer>();
            for (Column col : ds.defaultGetColumns(true, ds.getMenuColumnsFlag())) {
                this.columnMap.put(col.name, col.idx);
            }
            this.logger.info("Columns mapped: " + this.columnMap.size());
            this.rankMap = new HashMap<String, Integer>();
            for (String rk : ds.defaultGetRanks()) {
                String[] rkBits = rk.split(":");
                int id = Integer.parseInt(rkBits[0]);
                this.rankMap.put(rkBits[1], id);
                if (!rkBits[3].equals("1")) continue;
                defaultRank = id;
            }
            this.logger.info("Ranks mapped: " + this.rankMap.size());
            lineLen1 = 7;
            lineLen2 = 9;
            this.sdtypeMap = new HashMap<String, Integer>();
            for (SuppDatum sdt : ds.getSuppDataTypes()) {
                this.sdtypeMap.put(sdt.typeName, sdt.tid);
            }
            this.logger.info("Suppdata types mapped: " + this.sdtypeMap.size());
        } else {
            DataSourceDescriptor vdsd = this.dataSourceHandler.getDataSourceDescriptor(source);
            try {
                vds = (VDXSource)vdsd.getDataSource();
                if (vds == null) {
                    this.logger.log(Level.SEVERE, "skipping: " + pathname + " (datasource is invalid)");
                    return;
                }
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "skipping: " + pathname + " (datasource is invalid)");
                return;
            }
            this.channelMap = new HashMap<String, Integer>();
            for (gov.usgs.winston.Channel ch : vds.getChannels().getChannels()) {
                this.channelMap.put(ch.getCode(), ch.getSID());
            }
            this.logger.info("Channels mapped: " + this.channelMap.size());
            lineLen2 = 7;
            lineLen1 = 7;
            this.sdtypeMap = new HashMap<String, Integer>();
            try {
                for (SuppDatum sdt : vds.getSuppDataTypes()) {
                    this.sdtypeMap.put(sdt.typeName, sdt.tid);
                }
                this.logger.info("Suppdata types mapped: " + this.sdtypeMap.size());
            }
            catch (Exception e3) {
                this.logger.log(Level.SEVERE, "skipping: " + pathname + " (problem reading supplemental data types)");
                return;
            }
        }
        ResourceReader rr = ResourceReader.getResourceReader(pathname);
        if (rr == null) {
            this.logger.log(Level.SEVERE, "skipping: " + pathname + " (resource is invalid)");
            return;
        }
        String line = rr.nextLine();
        int lineNumber = 0;
        if (line == null) {
            this.logger.log(Level.SEVERE, "skipping: " + pathname + " (resource is empty)");
            return;
        }
        this.logger.info("importing: " + filename);
        SuppDatum sd = new SuppDatum();
        int success = 0;
        String[] valueArray = new String[lineLen2];
        while (true) {
            block72: {
                block74: {
                    block75: {
                        if (line == null) {
                            this.logger.info("" + success + " of " + lineNumber + " lines successfully processed");
                            return;
                        }
                        ++lineNumber;
                        String[] quoteParts = line.split("'", -1);
                        if (quoteParts.length % 2 != 1) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", mismatched quotes");
                            continue;
                        }
                        int valueArrayLength = 0;
                        boolean ok = true;
                        for (int j = 0; ok && j < quoteParts.length; j += 2) {
                            String[] parts = quoteParts[j].split(",", -1);
                            int k1 = 1;
                            int k2 = parts.length - 1;
                            boolean middle = true;
                            if (j == 0) {
                                middle = false;
                                if (parts.length > 1 && parts[0].trim().length() == 0) {
                                    this.logger.warning("Aborting import of line " + lineNumber + ", leading comma");
                                    ok = false;
                                    break;
                                }
                                --k1;
                            }
                            if (j == quoteParts.length - 1) {
                                middle = false;
                                if (parts.length > 1 && parts[parts.length - 1].trim().length() == 0) {
                                    this.logger.warning("Aborting import of line " + lineNumber + ", trailing comma");
                                    ok = false;
                                    break;
                                }
                                ++k2;
                            }
                            if (middle) {
                                if (parts.length == 1) {
                                    this.logger.warning("Aborting import of line " + lineNumber + ", missing comma between quotes");
                                    ok = false;
                                    break;
                                }
                                if (parts[0].trim().length() != 0) {
                                    this.logger.warning("Aborting import of line " + lineNumber + ", missing comma after a quote");
                                    ok = false;
                                    break;
                                }
                                if (parts[parts.length - 1].trim().length() != 0) {
                                    this.logger.warning("Aborting import of line " + lineNumber + ", missing comma before a quote");
                                    ok = false;
                                    break;
                                }
                            }
                            for (int k = k1; ok && k < k2; ++k) {
                                if (valueArrayLength == lineLen2) {
                                    this.logger.warning("Aborting import of line " + lineNumber + ", too many elements");
                                    ok = false;
                                    break;
                                }
                                valueArray[valueArrayLength++] = parts[k];
                            }
                            if (j + 1 >= quoteParts.length) continue;
                            if (valueArrayLength == lineLen2) {
                                this.logger.warning("Aborting import of line " + lineNumber + ", too many elements");
                                ok = false;
                                break;
                            }
                            valueArray[valueArrayLength++] = quoteParts[j + 1];
                        }
                        line = rr.nextLine();
                        if (!ok) continue;
                        if (valueArrayLength < lineLen1) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", too few elements (" + valueArrayLength + ")");
                            continue;
                        }
                        try {
                            sd.cid = this.channelMap.get(valueArray[3].trim());
                        }
                        catch (Exception e) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", unknown channel: '" + valueArray[3] + "'");
                            continue;
                        }
                        try {
                            sd.st = Double.parseDouble(valueArray[1].trim());
                        }
                        catch (Exception e) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", invalid start time: '" + valueArray[1] + "'");
                            continue;
                        }
                        try {
                            String et = valueArray[2].trim();
                            sd.et = et.length() == 0 ? Double.valueOf(Double.MAX_VALUE) : Double.valueOf(Double.parseDouble(et));
                        }
                        catch (Exception e) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", invalid end time: '" + valueArray[2] + "'");
                            continue;
                        }
                        try {
                            sd.typeName = valueArray[4].trim();
                            Integer tid = this.sdtypeMap.get(sd.typeName);
                            if (tid == null) {
                                sd.color = "000000";
                                sd.dl = 1;
                                sd.tid = -1;
                            } else {
                                sd.tid = tid;
                            }
                        }
                        catch (Exception e) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", couldn't create type: '" + valueArray[4] + "'");
                            continue;
                        }
                        if (ds == null) break block74;
                        if (valueArrayLength <= lineLen1) break block75;
                        try {
                            sd.colid = this.columnMap.get(valueArray[7].trim());
                        }
                        catch (Exception e) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", unknown column: '" + valueArray[7] + "'");
                            continue;
                        }
                        if (valueArrayLength < lineLen2) {
                            sd.rid = defaultRank;
                            break block72;
                        } else {
                            try {
                                sd.rid = this.rankMap.get(valueArray[8].trim());
                                break block72;
                            }
                            catch (Exception e) {
                                this.logger.warning("Aborting import of line " + lineNumber + ", unknown rank: '" + valueArray[8] + "'");
                                continue;
                            }
                        }
                    }
                    sd.colid = -1;
                    sd.rid = -1;
                    break block72;
                }
                sd.colid = -1;
                sd.rid = -1;
            }
            sd.name = valueArray[5].trim();
            sd.value = valueArray[6].trim();
            try {
                sd.sdid = Integer.parseInt(valueArray[0]);
            }
            catch (Exception e) {
                this.logger.warning("Aborting import of line " + lineNumber + ", unknown id: '" + valueArray[0] + "'");
                continue;
            }
            try {
                int read_sdid;
                if (ds != null) {
                    if (sd.tid == -1) {
                        sd.tid = ds.insertSuppDataType(sd);
                        if (sd.tid == 0) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", problem inserting datatype");
                            continue;
                        }
                        this.sdtypeMap.put(sd.typeName, sd.tid);
                        this.logger.info("Added supplemental datatype " + sd.typeName);
                    }
                    read_sdid = sd.sdid;
                    sd.sdid = sd.sdid == 0 ? ds.insertSuppDatum(sd) : ds.updateSuppDatum(sd);
                    if (sd.sdid < 0) {
                        sd.sdid = -sd.sdid;
                        this.logger.info("For import of line " + lineNumber + ", supp data record already exists as SDID " + sd.sdid + "; will create xref record");
                    } else {
                        if (sd.sdid == 0) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", problem " + (read_sdid == 0 ? "insert" : "updat") + "ing supp data");
                            continue;
                        }
                        if (read_sdid == 0) {
                            this.logger.info("Added supp data record SDID " + sd.sdid);
                        } else {
                            this.logger.info("Updated supp data record SDID " + sd.sdid);
                        }
                    }
                    if (!ds.insertSuppDatumXref(sd)) continue;
                    this.logger.info("Added xref for SDID " + sd.sdid);
                } else {
                    if (sd.tid == -1) {
                        sd.tid = vds.insertSuppDataType(sd);
                        if (sd.tid == 0) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", problem inserting datatype");
                            continue;
                        }
                        this.sdtypeMap.put(sd.typeName, sd.tid);
                        this.logger.info("Added supplemental datatype " + sd.typeName);
                    }
                    read_sdid = sd.sdid;
                    sd.sdid = sd.sdid == 0 ? vds.insertSuppDatum(sd) : vds.updateSuppDatum(sd);
                    if (sd.sdid < 0) {
                        sd.sdid = -sd.sdid;
                        this.logger.info("For import of line " + lineNumber + ", supp data record already exists as SDID " + sd.sdid + "; will create xref record");
                    } else {
                        if (sd.sdid == 0) {
                            this.logger.warning("Aborting import of line " + lineNumber + ", problem " + (read_sdid == 0 ? "insert" : "updat") + "ing supp data");
                            continue;
                        }
                        if (read_sdid == 0) {
                            this.logger.info("Added supp data record SDID " + sd.sdid);
                        } else {
                            this.logger.info("Updated supp data record SDID " + sd.sdid);
                        }
                    }
                    if (!vds.insertSuppDatumXref(sd)) continue;
                    this.logger.info("Added xref for SDID " + sd.sdid);
                }
            }
            catch (Exception e) {
                this.logger.warning("Failed import of line " + lineNumber + ", db failure: " + e);
                continue;
            }
            ++success;
        }
    }

    public void outputInstructions(String importerClass, String message) {
    }

    public static void main(String[] as) {
        ImportSuppdata importer = new ImportSuppdata();
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("-h")) {
            importer.outputInstructions(importer.getClass().getName(), null);
            System.exit(-1);
        }
        String configFile = "VDX.config";
        if (args.contains("-c")) {
            configFile = args.get("-c");
        }
        importer.initialize(importer.getClass().getName(), configFile);
        List<String> files = args.unused();
        for (String file : files) {
            importer.process(file);
        }
        importer.deinitialize();
    }

    static {
        keys.add("-c");
        flags.add("-h");
        flags.add("-cm");
        flags.add("-v");
    }
}

