/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hw;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.in.hw.Device;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class AGLILY
implements Device {
    protected final int MIN_MESSAGE_LENGTH = 40;
    protected String timestamp;
    protected String timezone;
    protected int timeout;
    protected int maxtries;
    protected int maxlines;
    protected int currentlines;
    protected int samplerate;
    protected String delimiter;
    protected String nullfield;
    protected boolean pollhist;
    protected String fields;
    protected Acquisition acquisition;
    protected String id;

    @Override
    public void initialize(ConfigFile params) throws Exception {
        this.id = Util.stringToString(params.getString("id"), "0");
        this.timestamp = Util.stringToString(params.getString("timestamp"), "MM/dd/yy HH:mm:ss");
        this.timezone = Util.stringToString(params.getString("timezone"), "GMT");
        this.timeout = Util.stringToInt(params.getString("timeout"), 60000);
        this.maxtries = Util.stringToInt(params.getString("maxtries"), 2);
        this.maxlines = Util.stringToInt(params.getString("maxlines"), 30);
        this.samplerate = Util.stringToInt(params.getString("samplerate"), 60);
        this.delimiter = Util.stringToString(params.getString("delimiter"), ",");
        this.nullfield = Util.stringToString(params.getString("nullfield"), "");
        this.pollhist = Util.stringToBoolean(params.getString("pollhist"), true);
        this.fields = Util.stringToString(params.getString("fields"), "");
        this.acquisition = Acquisition.fromString(Util.stringToString(params.getString("acquisition"), "poll"));
        if (this.fields.length() == 0) {
            throw new Exception("fields not defined");
        }
        if (this.acquisition == null) {
            throw new Exception("invalid acquisition type");
        }
    }

    @Override
    public String toString() {
        String settings = "id:" + this.id + "/";
        settings = settings + "acquisition:" + this.acquisition.toString() + "/";
        settings = settings + "timestamp:" + this.timestamp + "/";
        settings = settings + "timezone:" + this.timezone + "/";
        settings = settings + "timeout:" + this.timeout + "/";
        settings = settings + "maxtries:" + this.maxtries + "/";
        settings = settings + "maxlines:" + this.maxlines + "/";
        settings = settings + "samplerate:" + this.samplerate + "/";
        settings = settings + "delimiter:" + this.delimiter + "/";
        settings = settings + "nullfield:" + this.nullfield + "/";
        settings = settings + "pollhist:" + this.pollhist + "/";
        return settings;
    }

    @Override
    public String requestData(Date startDate) throws Exception {
        String cmd = "";
        switch (this.acquisition) {
            case POLL: {
                long secs = (System.currentTimeMillis() - startDate.getTime()) / 1000L;
                int samps = (int)Math.floor(secs / (long)this.samplerate);
                this.currentlines = Math.min(samps, this.maxlines);
                if (this.currentlines <= 0) {
                    throw new Exception("no data to poll");
                }
                cmd = cmd + "XY-DL-LAST," + this.currentlines;
            }
        }
        return this.make(cmd);
    }

    @Override
    public boolean messageCompleted(String message) {
        int length = message.length();
        switch (this.acquisition) {
            case STREAM: {
                if (length < 40) {
                    return false;
                }
                if (message.charAt(0) != '$') {
                    return false;
                }
                return message.substring(length - 2).contentEquals("\r\n");
            }
            case POLL: {
                if (length < 40) {
                    return false;
                }
                if (message.charAt(0) != '*') {
                    return false;
                }
                return message.substring(length - 15).contentEquals("$end download\r\n");
            }
        }
        return false;
    }

    @Override
    public boolean validateMessage(String message, boolean ignoreWrongAddress) throws Exception {
        int length = message.length();
        switch (this.acquisition) {
            case STREAM: {
                if (length < 40) {
                    throw new Exception("Too short. Length = " + length + "\n" + message);
                }
                if (message.charAt(0) != '$') {
                    throw new Exception("Wrong start character: " + message.charAt(0) + "\n" + message);
                }
                if (message.substring(length - 2).contentEquals("\r\n")) break;
                throw new Exception("Wrong end character: " + message.charAt(length - 2) + "\n" + message);
            }
            case POLL: {
                if (length < 40) {
                    throw new Exception("Too short. Length = " + length + "\n" + message);
                }
                if (message.charAt(0) != '*') {
                    throw new Exception("Wrong start character: " + message.charAt(0) + "\n" + message);
                }
                if (message.substring(length - 15).contentEquals("$end download\r\n")) break;
                throw new Exception("Wrong end character: " + message.substring(length - 15) + "\n" + message);
            }
        }
        return true;
    }

    @Override
    public void validateLine(String line) throws Exception {
        int length = line.length();
        if (length < 40) {
            throw new Exception("less than mininum message length");
        }
        if (line.charAt(0) != '$') {
            throw new Exception("does not begin begin with $");
        }
        if (!line.substring(length - 1).contentEquals("\r")) {
            throw new Exception("does not end with <CR>");
        }
    }

    @Override
    public String formatMessage(String message) {
        switch (this.acquisition) {
            case POLL: {
                message = message.substring(message.indexOf(10) + 1, message.length() - 16);
            }
        }
        return message;
    }

    @Override
    public String formatLine(String line) {
        int length = line.length();
        line = line.substring(1, length - 1);
        return line.trim();
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getMaxtries() {
        return this.maxtries;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public String getNullfield() {
        return this.nullfield;
    }

    @Override
    public boolean getPollhist() {
        return this.pollhist;
    }

    @Override
    public String getFields() {
        return this.fields;
    }

    public String make(String msg) {
        String completeStr = "";
        if (msg.length() > 0) {
            completeStr = completeStr + "*9900";
            completeStr = completeStr + msg;
            completeStr = completeStr + '\r';
            completeStr = completeStr + '\n';
        }
        return completeStr;
    }

    @Override
    public String setTime() {
        Calendar rightNow = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        SimpleDateFormat formatter = new SimpleDateFormat("ss,mm,HH,dd,MM,yy");
        formatter.setTimeZone(TimeZone.getTimeZone(this.timezone));
        String cmd = "SET-TIME,";
        cmd = cmd + formatter.format(rightNow.getTime());
        return this.make(cmd);
    }

    private static enum Acquisition {
        STREAM,
        POLL;


        public static Acquisition fromString(String s) {
            if (s.equalsIgnoreCase("stream")) {
                return STREAM;
            }
            if (s.equals("poll")) {
                return POLL;
            }
            return null;
        }
    }
}

