/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hw;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.in.hw.Device;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class CCSAIL
implements Device {
    protected final int MIN_MESSAGE_LENGTH = 20;
    protected String timestamp;
    protected String timezone;
    protected int timeout;
    protected int maxtries;
    protected int maxlines;
    protected int currentlines;
    protected int samplerate;
    protected String delimiter;
    protected String nullfield;
    protected boolean pollhist;
    protected String fields;
    protected Acquisition acquisition;
    protected String id;

    @Override
    public void initialize(ConfigFile params) throws Exception {
        int idval;
        this.id = Util.stringToString(params.getString("id"), "0");
        this.timestamp = Util.stringToString(params.getString("timestamp"), "yy/MM/dd HH:mm:ss");
        this.timezone = Util.stringToString(params.getString("timezone"), "GMT");
        this.timeout = Util.stringToInt(params.getString("timeout"), 60000);
        this.maxtries = Util.stringToInt(params.getString("maxtries"), 2);
        this.maxlines = Util.stringToInt(params.getString("maxlines"), 30);
        this.samplerate = Util.stringToInt(params.getString("samplerate"), 60);
        this.delimiter = Util.stringToString(params.getString("delimiter"), ",");
        this.nullfield = Util.stringToString(params.getString("nullfield"), "");
        this.pollhist = Util.stringToBoolean(params.getString("pollhist"), true);
        this.fields = Util.stringToString(params.getString("fields"), "");
        this.acquisition = Acquisition.fromString(Util.stringToString(params.getString("acquisition"), "poll"));
        if (this.fields.length() == 0) {
            throw new Exception("fields not defined");
        }
        if (this.acquisition == null) {
            throw new Exception("invalid acquisition type");
        }
        try {
            idval = Integer.valueOf(this.id);
        }
        catch (NumberFormatException e) {
            throw new Exception("invalid id");
        }
        if (idval <= 0 || idval >= 10000) {
            throw new Exception("Invalid id");
        }
        DecimalFormat stationNumberFormatter = new DecimalFormat("0000");
        this.id = stationNumberFormatter.format(idval);
    }

    @Override
    public String toString() {
        String settings = "id:" + this.id + "/";
        settings = settings + "acquisition:" + this.acquisition.toString() + "/";
        settings = settings + "timestamp:" + this.timestamp + "/";
        settings = settings + "timezone:" + this.timezone + "/";
        settings = settings + "timeout:" + this.timeout + "/";
        settings = settings + "maxtries:" + this.maxtries + "/";
        settings = settings + "maxlines:" + this.maxlines + "/";
        settings = settings + "samplerate:" + this.samplerate + "/";
        settings = settings + "delimiter:" + this.delimiter + "/";
        settings = settings + "nullfield:" + this.nullfield + "/";
        settings = settings + "pollhist:" + this.pollhist + "/";
        return settings;
    }

    @Override
    public String requestData(Date startDate) throws Exception {
        this.currentlines = this.maxlines;
        if (this.currentlines < 1 || this.currentlines > 9999) {
            throw new Exception("DA: number of lines (" + this.currentlines + ") not in range 1,...,9999");
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMddHHmmss");
        formatter.setTimeZone(TimeZone.getTimeZone(this.timezone));
        String cmd = "DA";
        cmd = cmd + formatter.format(startDate);
        cmd = cmd + this.currentlines;
        cmd = cmd + ",";
        return this.make(cmd);
    }

    @Override
    public boolean messageCompleted(String message) throws Exception {
        return message.charAt(message.length() - 1) == '\u0003';
    }

    @Override
    public boolean validateMessage(String message, boolean ignoreWrongAddress) throws Exception {
        int checkSumCalc;
        int len = message.length();
        if (message.startsWith("\r\n")) {
            message = message.substring(2, len);
            len -= 2;
        }
        if (len < 20) {
            throw new Exception("Too short. Len = " + len + "\n" + message);
        }
        if (message.charAt(0) != '#') {
            throw new Exception("Wrong ATN: " + message.charAt(0) + "\n" + message);
        }
        if (message.charAt(len - 1) != '\u0003') {
            throw new Exception("Wrong ETX: " + message.charAt(len - 1) + "\n" + message);
        }
        int checkSumIs = (message.charAt(len - 3) - 48) * 10;
        if ((checkSumIs += message.charAt(len - 2) - 48) != (checkSumCalc = this.calculateChecksum(message, true))) {
            throw new Exception("Wrong checksum: " + checkSumIs + " should be: " + checkSumCalc + "\n" + message);
        }
        String token = message.substring(1, 5);
        if (!token.equals("0000") && !ignoreWrongAddress) {
            throw new Exception("Wrong ADR: " + token + "\n" + message);
        }
        token = message.substring(5, 9);
        if (!token.equals(this.id) && !ignoreWrongAddress) {
            throw new Exception("Wrong RTN: " + token + "\n" + message);
        }
        return true;
    }

    @Override
    public void validateLine(String line) throws Exception {
        int length = line.length();
        if (length <= 1) {
            throw new Exception("length is 0");
        }
        if (line.startsWith("EOF")) {
            throw new Exception("begins with EOF");
        }
        if (line.startsWith("#")) {
            throw new Exception("begins with #");
        }
    }

    @Override
    public String formatMessage(String message) {
        if (message.startsWith("\r\n")) {
            message = message.substring(2, message.length());
        }
        if ((message = message.substring(11, message.length() - 3)).substring(message.length() - 5).contentEquals("\nEOF,")) {
            message = message.substring(0, message.length() - 5);
        }
        return message;
    }

    @Override
    public String formatLine(String line) {
        int length = line.length();
        if (line.charAt(length - 1) == '\r') {
            line = line.substring(0, length - 1);
        }
        return line.trim();
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getMaxtries() {
        return this.maxtries;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public String getNullfield() {
        return this.nullfield;
    }

    @Override
    public boolean getPollhist() {
        return this.pollhist;
    }

    @Override
    public String getFields() {
        return this.fields;
    }

    public String make(String msg) {
        String completeStr = "";
        completeStr = completeStr + '#';
        completeStr = completeStr + this.id;
        completeStr = completeStr + "0000";
        completeStr = completeStr + msg;
        int checksum = this.calculateChecksum(completeStr, false);
        completeStr = completeStr + (char)(48 + checksum / 10);
        completeStr = completeStr + (char)(48 + checksum % 10);
        completeStr = completeStr + '\u0003';
        return completeStr;
    }

    public String requestData(int numberOfValues) throws Exception {
        if (numberOfValues < 1 || numberOfValues > 9999) {
            throw new Exception("DL: number of values (" + numberOfValues + ") not in range 1,...,9999");
        }
        String cmd = "DL";
        cmd = cmd + numberOfValues;
        cmd = cmd + ',';
        return this.make(cmd);
    }

    public String requestData(Date startDate, Date stopDate) throws Exception {
        SimpleDateFormat formater = new SimpleDateFormat("yyMMddHHmmss");
        formater.setTimeZone(TimeZone.getTimeZone(this.timezone));
        String cmd = "DB";
        cmd = cmd + formater.format(startDate);
        cmd = cmd + formater.format(stopDate);
        return this.make(cmd);
    }

    @Override
    public String setTime() {
        Calendar rightNow = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        SimpleDateFormat formater = new SimpleDateFormat("yyMMddHHmmss");
        formater.setTimeZone(TimeZone.getTimeZone(this.timezone));
        String cmd = "TM";
        cmd = cmd + formater.format(rightNow.getTime());
        return this.make(cmd);
    }

    public String makeInvalid() {
        return this.make("TT");
    }

    public String makeSDO(boolean on, int outputNumber) throws Exception {
        if (outputNumber < 18 || outputNumber > 24) {
            throw new Exception("SDO: output number (" + outputNumber + ") not in range 18,...,24");
        }
        String cmd = "SDO";
        cmd = cmd + (on ? (char)'1' : '0');
        cmd = cmd + outputNumber;
        return this.make(cmd);
    }

    public String makeChangeTiltmeterGain(boolean high) {
        String cmd = "";
        try {
            cmd = this.makeSDO(high, 18);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmd;
    }

    private boolean checkChecksum(String str) {
        boolean chkOk = false;
        int len = str.length();
        chkOk = len >= 4;
        if (chkOk && (chkOk = '\u0003' == str.charAt(len - 1) && '#' == str.charAt(0))) {
            int chkIs = (str.charAt(len - 3) - 48) * 10;
            chkOk = (chkIs += str.charAt(len - 2) - 48) == this.calculateChecksum(str, true);
        }
        return chkOk;
    }

    private int calculateChecksum(String str, boolean ignoreEnd) {
        int checksum = 0;
        char c = '\u0000';
        int len = str.length();
        if (ignoreEnd) {
            len -= 3;
        }
        for (int i = 1; i < len; ++i) {
            c = str.charAt(i);
            checksum += c;
        }
        return checksum %= 100;
    }

    private static enum Acquisition {
        STREAM,
        POLL;


        public static Acquisition fromString(String s) {
            if (s.equalsIgnoreCase("stream")) {
                return STREAM;
            }
            if (s.equals("poll")) {
                return POLL;
            }
            return null;
        }
    }
}

