/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.hw;

import gov.usgs.util.ConfigFile;
import gov.usgs.util.Util;
import gov.usgs.vdx.in.hw.Device;
import gov.usgs.vdx.in.hw.ESC8832DataPacket;
import gov.usgs.vdx.in.hw.ESC8832DataPacketComparator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Logger;

public class ESC8832
implements Device {
    protected final int MIN_MESSAGE_LENGTH = 40;
    protected String timestamp;
    protected String timezone;
    protected int timeout;
    protected int maxtries;
    protected int maxlines;
    protected int currentlines;
    protected int samplerate;
    protected String delimiter;
    protected String nullfield;
    protected boolean pollhist;
    protected String calchannel;
    protected String fields;
    protected Acquisition acquisition;
    protected String id;
    protected SimpleDateFormat dateIn = new SimpleDateFormat("DDDHHmmss");
    protected SimpleDateFormat dateOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public Logger logger;

    @Override
    public void initialize(ConfigFile params) throws Exception {
        this.id = Util.stringToString(params.getString("id"), "");
        this.timestamp = Util.stringToString(params.getString("timestamp"), "yyyy-MM-dd HH:mm:ss");
        this.timezone = Util.stringToString(params.getString("timezone"), "GMT");
        this.timeout = Util.stringToInt(params.getString("timeout"), 60000);
        this.maxtries = Util.stringToInt(params.getString("maxtries"), 2);
        this.maxlines = Util.stringToInt(params.getString("maxlines"), 30);
        this.samplerate = Util.stringToInt(params.getString("samplerate"), 60);
        this.delimiter = Util.stringToString(params.getString("delimiter"), ",");
        this.nullfield = Util.stringToString(params.getString("nullfield"), "");
        this.pollhist = Util.stringToBoolean(params.getString("pollhist"), true);
        this.calchannel = Util.stringToString(params.getString("calchannel"), "");
        this.fields = Util.stringToString(params.getString("fields"), "");
        this.acquisition = Acquisition.fromString(Util.stringToString(params.getString("acquisition"), "poll"));
        if (this.fields.length() == 0) {
            throw new Exception("fields not defined");
        }
        if (this.acquisition == null) {
            throw new Exception("invalid acquisition type");
        }
        if (this.id.length() != 2) {
            throw new Exception("id must be 2 characters");
        }
        if (this.calchannel.length() != 2) {
            throw new Exception("calchannel must be 2 characters");
        }
        this.logger = Logger.getLogger("gov.usgs.vdx.in.hw.ESC8832");
    }

    @Override
    public String toString() {
        String settings = "id:" + this.id + "/";
        settings = settings + "acquisition:" + this.acquisition.toString() + "/";
        settings = settings + "timestamp:" + this.timestamp + "/";
        settings = settings + "timezone:" + this.timezone + "/";
        settings = settings + "timeout:" + this.timeout + "/";
        settings = settings + "maxtries:" + this.maxtries + "/";
        settings = settings + "maxlines:" + this.maxlines + "/";
        settings = settings + "samplerate:" + this.samplerate + "/";
        settings = settings + "delimiter:" + this.delimiter + "/";
        settings = settings + "nullfield:" + this.nullfield + "/";
        settings = settings + "pollhist:" + this.pollhist + "/";
        settings = settings + "calchannel:" + this.calchannel + "/";
        return settings;
    }

    @Override
    public String requestData(Date startDate) throws Exception {
        String cmd = "";
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        switch (this.acquisition) {
            case POLL: {
                long startSeconds = startDate.getTime();
                startSeconds -= startSeconds % (long)(1000 * this.samplerate);
                startDate = new Date(startSeconds);
                calendar.setTime(startDate);
                ((Calendar)calendar).add(13, -this.samplerate);
                startDate = calendar.getTime();
                long secs = (System.currentTimeMillis() - startDate.getTime()) / 1000L;
                int samps = (int)Math.floor(secs / (long)this.samplerate);
                this.currentlines = Math.min(samps, this.maxlines);
                if (this.currentlines == 0) {
                    throw new Exception("no data to poll");
                }
                calendar.setTime(startDate);
                ((Calendar)calendar).add(13, this.samplerate * this.currentlines);
                Date endDate = calendar.getTime();
                cmd = cmd + "!5600015M";
                cmd = cmd + this.dateIn.format(startDate);
                cmd = cmd + "|Y|";
                cmd = cmd + this.dateIn.format(endDate);
                cmd = cmd + "&";
            }
        }
        return this.make(cmd);
    }

    @Override
    public boolean messageCompleted(String message) {
        int length = message.length();
        switch (this.acquisition) {
            case POLL: {
                if (length < 40) {
                    return false;
                }
                if (message.charAt(0) != '@') {
                    return false;
                }
                return message.charAt(length - 1) == '$';
            }
        }
        return false;
    }

    @Override
    public boolean validateMessage(String message, boolean ignoreWrongAddress) throws Exception {
        int length = message.length();
        switch (this.acquisition) {
            case POLL: {
                if (length < 40) {
                    throw new Exception("Too short. Length = " + length + "\n" + message);
                }
                if (message.charAt(0) != '@') {
                    throw new Exception("Wrong start character: " + message.charAt(0) + "\n" + message);
                }
                if (message.charAt(length - 1) == '$') break;
                throw new Exception("Wrong end character: " + message.charAt(length - 1) + "\n" + message);
            }
        }
        return true;
    }

    @Override
    public void validateLine(String line) throws Exception {
        int length = line.length();
        if (length < 40) {
            throw new Exception("less than mininum message length");
        }
    }

    @Override
    public String formatMessage(String message) {
        Date currentDate = new Date();
        String currentDay = new SimpleDateFormat("DDD").format(currentDate);
        String currentYear = new SimpleDateFormat("yyyy").format(currentDate);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone(this.timezone));
        calendar.setTime(currentDate);
        switch (this.acquisition) {
            case POLL: {
                ESC8832DataPacket dataPacket;
                Double dataValue;
                Date dataDate;
                String dataChannel;
                message = message.substring(5);
                message = message.substring(0, message.lastIndexOf("&") + 1);
                StringTokenizer st = new StringTokenizer(message, "!");
                ArrayList<ESC8832DataPacket> dataPacketList = new ArrayList<ESC8832DataPacket>();
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    if (!line.startsWith("56") || !line.endsWith("&")) continue;
                    dataChannel = line.substring(2, 4);
                    try {
                        String dataDay = line.substring(8, 11);
                        if (Integer.valueOf(dataDay) > Integer.valueOf(currentDay)) {
                            calendar.set(1, Integer.valueOf(currentYear) - 1);
                        } else {
                            calendar.set(1, Integer.valueOf(currentYear));
                        }
                        calendar.set(6, Integer.valueOf(dataDay));
                        calendar.set(11, Integer.valueOf(line.substring(11, 13)));
                        calendar.set(12, Integer.valueOf(line.substring(13, 15)));
                        calendar.set(13, Integer.valueOf(line.substring(15, 17)));
                        ((Calendar)calendar).add(13, this.samplerate);
                        dataDate = calendar.getTime();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    try {
                        dataValue = Double.valueOf(line.substring(17, 27));
                    }
                    catch (Exception e) {
                        dataValue = Double.NaN;
                    }
                    String dataFlag = line.indexOf("&") > 27 ? line.substring(27, line.length() - 1) : "";
                    if (dataFlag.length() > 0 && dataFlag.indexOf(">") < 0) {
                        dataValue = Double.NaN;
                    }
                    if (dataChannel.equals(this.calchannel)) {
                        Double calValue = dataFlag.indexOf("C") >= 0 ? Double.valueOf(0.0) : Double.valueOf(1.0);
                        dataPacket = new ESC8832DataPacket("00", dataDate, calValue);
                        dataPacketList.add(dataPacket);
                    }
                    dataPacket = new ESC8832DataPacket(dataChannel, dataDate, dataValue);
                    dataPacketList.add(dataPacket);
                }
                if (dataPacketList.size() > 0) {
                    Object[] dataPacketArray = dataPacketList.toArray();
                    Arrays.sort(dataPacketArray, new ESC8832DataPacketComparator());
                    dataPacket = (ESC8832DataPacket)dataPacketArray[0];
                    currentDate = dataPacket.dataDate;
                    message = this.dateOut.format(currentDate);
                    for (int i = 0; i < dataPacketArray.length; ++i) {
                        dataPacket = (ESC8832DataPacket)dataPacketArray[i];
                        dataDate = dataPacket.dataDate;
                        dataValue = dataPacket.dataValue;
                        dataChannel = dataPacket.dataChannel;
                        if (dataDate.compareTo(currentDate) != 0) {
                            currentDate = dataDate;
                            message = message + "\n";
                            message = message + this.dateOut.format(currentDate);
                        }
                        message = message + "," + dataValue;
                    }
                    break;
                }
                message = "";
            }
        }
        return message;
    }

    @Override
    public String formatLine(String line) {
        return line.trim();
    }

    @Override
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    @Override
    public int getMaxtries() {
        return this.maxtries;
    }

    @Override
    public String getDelimiter() {
        return this.delimiter;
    }

    @Override
    public String getNullfield() {
        return this.nullfield;
    }

    @Override
    public boolean getPollhist() {
        return this.pollhist;
    }

    @Override
    public String getFields() {
        return this.fields;
    }

    public String make(String msg) {
        String completeStr = "";
        if (msg.length() > 0) {
            completeStr = completeStr + "@";
            completeStr = completeStr + this.id;
            completeStr = completeStr + msg;
            completeStr = completeStr + "$";
        }
        return completeStr;
    }

    @Override
    public String setTime() {
        String cmd = "";
        return this.make(cmd);
    }

    private static enum Acquisition {
        STREAM,
        POLL;


        public static Acquisition fromString(String s) {
            if (s.equalsIgnoreCase("stream")) {
                return STREAM;
            }
            if (s.equals("poll")) {
                return POLL;
            }
            return null;
        }
    }
}

