/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.vdx.in.rsam;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix2D;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import gov.usgs.earthworm.ImportGeneric;
import gov.usgs.earthworm.MessageListener;
import gov.usgs.earthworm.message.Message;
import gov.usgs.earthworm.message.MessageType;
import gov.usgs.earthworm.message.TraceBuf;
import gov.usgs.plot.data.GenericDataMatrix;
import gov.usgs.util.CodeTimer;
import gov.usgs.util.ConfigFile;
import gov.usgs.util.CurrentTime;
import gov.usgs.util.Log;
import gov.usgs.util.Util;
import gov.usgs.vdx.data.Channel;
import gov.usgs.vdx.data.SQLDataSourceDescriptor;
import gov.usgs.vdx.data.SQLDataSourceHandler;
import gov.usgs.vdx.data.rsam.SQLRSAMDataSource;
import gov.usgs.winston.in.ew.ChannelStatus;
import gov.usgs.winston.in.ew.Options;
import gov.usgs.winston.in.ew.OptionsFilter;
import gov.usgs.winston.in.ew.TraceBufFilter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportEWRSAM
extends Thread {
    public static final String DEFAULT_CONFIG_FILENAME = "ImportEWRSAM.config";
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 16022;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 30000;
    public static final int DEFAULT_EXPECTED_HEARTBEAT_INTERVAL = 30000;
    public static final int DEFAULT_STATUS_INTERVAL = 60;
    public static final String DEFAULT_RECEIVE_ID = "MSG_FROM_EXPORT";
    public static final String DEFAULT_SEND_ID = "MSG_TO_EXPORT";
    public static final String DEFAULT_DRIVER = "com.mysql.jdbc.Driver";
    public static final String DEFAULT_TABLE_ENGINE = "MyISAM";
    public static final int DEFAULT_MAX_DAYS = 0;
    public static final int DEFAULT_MAX_BACKLOG = 100;
    public static final String DEFAULT_LOG_LEVEL = "WARNING";
    public static final String DEFAULT_LOG_FILE = "ImportEWRSAM.log";
    public static final int DEFAULT_LOG_NUM_FILES = 10;
    public static final int DEFAULT_LOG_FILE_SIZE = 1000000;
    public static final double DEFAULT_TIME_THRESHOLD = 1.0;
    public static final int DEFAULT_BACKLOG_THRESHOLD = 1;
    public static final boolean DEFAULT_RSAM_ENABLE = true;
    public static final int DEFAULT_RSAM_DELTA = 10;
    public static final int DEFAULT_RSAM_DURATION = 60;
    public static final int DEFAULT_DROP_TABLE_DELAY = 10;
    public static final int DEFAULT_REPAIR_RETRY_INTERVAL = 600;
    public static String JSAP_PROGRAM_NAME = "java gov.usgs.vdx.in.rsam.ImportEWRSAM";
    public static String JSAP_EXPLANATION_PREFACE = "ImportEWRSAM\n\nThis program gets data from an Earthworm export process and imports\nit into a Valve database. See 'ImportEWRSAM.config' for more options.\n\n";
    private static final String DEFAULT_JSAP_EXPLANATION = "All output goes to both standard error and the file log.\n\nWhile the process is running (and accepting console input) you can enter\nthese commands into the console (followed by [Enter]):\n0: turn logging off.\n1: normal logging level (WARNING).\n2: high logging level (FINE).\n3: log everything.\ns: display status information.\nc[col][-]: channel list, sorted by col, - for descending. Examples: c, cl-, cx\ni: no longer accept console input.\nq: quit cleanly.\nctrl-c: quit now.\n\nNote that if console input is disabled the only way to\nterminate the program is with ctrl-c or by killing the process.\n";
    private static final Parameter[] DEFAULT_JSAP_PARAMETERS = new Parameter[]{new FlaggedOption("logLevel", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, 'l', "log-level", "The level of logging to start with\nThis may consist of either a java.util.logging.Level name or an integer value.\nFor example: \"SEVERE\", or \"1000\""), new Switch("logoff", '0', "logoff", "Turn logging off (equivalent to --log-level OFF)."), new Switch("lognormal", '1', "lognormal", "Normal (default) logging level (equivalent to --log-level WARNING)."), new Switch("loghigh", '2', "loghigh", "High logging level (equivalent to --log-level FINE)."), new Switch("logall", '3', "logall", "High logging level (equivalent to --log-level ALL)."), new Switch("noinput", 'i', "noinput", "Don't accept input from the console."), new UnflaggedOption("configFilename", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, false, false, "The config file name.")};
    protected String configFilename;
    protected ConfigFile config;
    public SQLRSAMDataSource sqlDataSource;
    public SQLDataSourceHandler sqlDataSourceHandler;
    public SQLDataSourceDescriptor sqlDataSourceDescriptor;
    protected ImportGeneric importGeneric;
    private final Set<String> existingChannels;
    private final Map<String, ConcurrentLinkedQueue<TraceBuf>> channelTraceBufs;
    protected final Logger logger;
    protected String logFile;
    protected int logNumFiles;
    protected int logSize;
    protected final CodeTimer inputTimer;
    protected int totalTraceBufsWritten = 0;
    protected int totalTraceBufs;
    protected int totalTraceBufsDropped;
    protected int totalTraceBufsAccepted;
    protected int totalTraceBufsRejected;
    protected int totalTraceBufsFailed;
    protected final Map<String, ChannelStatus> channelStatus;
    protected final Date importStartTime;
    protected final DateFormat dateFormat;
    protected final DateFormat vdxDateFormat;
    protected int dropTableDelay = 10000;
    protected boolean enableValarmView;
    protected Options defaultOptions;
    protected final Map<String, Options> channelOptions;
    protected Map<String, Map<String, String>> channelMetadata;
    private volatile boolean quit = false;
    protected List<TraceBufFilter> traceBufFilters;
    protected List<OptionsFilter> optionFilters;

    public ImportEWRSAM(String fn) {
        this();
        this.configFilename = Util.stringToString(fn, DEFAULT_CONFIG_FILENAME);
        this.importGeneric = new ImportGeneric(){

            @Override
            public void outOfMemoryErrorOccurred(OutOfMemoryError e) {
                ImportEWRSAM.this.handleOutOfMemoryError(e);
            }
        };
        this.importGeneric.setLogger(this.logger);
        this.config = new ConfigFile(this.configFilename);
        this.channelMetadata = new HashMap<String, Map<String, String>>();
        this.processConfigFile();
    }

    public ImportEWRSAM() {
        this.setName("ImportEWRSAM");
        this.importStartTime = CurrentTime.getInstance().nowDate();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.vdxDateFormat = new SimpleDateFormat("yyyy_MM_dd");
        this.vdxDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.channelOptions = new HashMap<String, Options>();
        this.channelStatus = new HashMap<String, ChannelStatus>();
        this.inputTimer = new CodeTimer("inputTimer", false);
        this.channelTraceBufs = new ConcurrentHashMap<String, ConcurrentLinkedQueue<TraceBuf>>(200, 0.75f, 1);
        this.existingChannels = Collections.synchronizedSet(new HashSet());
        this.logger = Log.getLogger("gov.usgs.vdx");
        this.logger.setLevel(Level.parse(DEFAULT_LOG_LEVEL));
    }

    public void handleOutOfMemoryError(OutOfMemoryError e) {
        this.channelTraceBufs.clear();
        this.logger.warning("Handled OutOfMemoryError, TraceBuf queues cleared.");
        e.printStackTrace();
    }

    protected void fatalError(String msg) {
        this.logger.severe(msg);
        System.exit(1);
    }

    protected void processConfigFile() {
        this.processLoggerConfig();
        this.processImportConfig();
        this.processVDXConfig();
        this.processDefaultOptions();
        this.processOptions();
        this.processFilters();
    }

    protected void processLoggerConfig() {
        String[] version;
        this.logFile = Util.stringToString(this.config.getString("import.log.name"), DEFAULT_LOG_FILE);
        this.logNumFiles = Util.stringToInt(this.config.getString("import.log.numFiles"), 10);
        this.logSize = Util.stringToInt(this.config.getString("import.log.maxSize"), 1000000);
        if (this.logNumFiles > 0) {
            Log.attachFileLogger(this.logger, this.logFile, this.logSize, this.logNumFiles, true);
        }
        if ((version = Util.getVersion("gov.usgs.vdx")) != null) {
            this.logger.info("Version: " + version[0] + " Built: " + version[1]);
        } else {
            this.logger.info("No version information available.");
        }
        this.logger.info("config: import.log.name=" + this.logFile);
        this.logger.info("config: import.log.numFiles=" + this.logNumFiles);
        this.logger.info("config: import.log.maxSize=" + this.logSize);
    }

    protected void processImportConfig() {
        String host = Util.stringToString(this.config.getString("import.host"), DEFAULT_HOST);
        int port = Util.stringToInt(this.config.getString("import.port"), 16022);
        this.logger.info("config: import.host=" + host);
        this.logger.info("config: import.port=" + port);
        this.importGeneric.setHostAndPort(host, port);
        String recvID = Util.stringToString(this.config.getString("import.receiveID"), DEFAULT_RECEIVE_ID);
        this.importGeneric.setRecvIDString(recvID);
        this.logger.info("config: import.receiveID=" + recvID);
        String sendID = Util.stringToString(this.config.getString("import.sendID"), DEFAULT_SEND_ID);
        this.importGeneric.setSendIDString(sendID);
        this.logger.info("config: import.sendID=" + sendID);
        int hbInt = Util.stringToInt(this.config.getString("import.heartbeatInterval"), 30000);
        this.importGeneric.setHeartbeatInterval(hbInt);
        this.logger.info("config: import.heartbeatInterval=" + hbInt);
        int ehbInt = Util.stringToInt(this.config.getString("import.expectedHeartbeatInterval"), 30000);
        this.importGeneric.setExpectedHeartbeatInterval(ehbInt);
        this.logger.info("config: import.expectedHeartbeatInterval=" + ehbInt);
        int to = Util.stringToInt(this.config.getString("import.timeout"), 2000);
        this.importGeneric.setTimeout(to);
        this.logger.info("config: import.timeout=" + to);
        this.dropTableDelay = Util.stringToInt(this.config.getString("import.dropTableDelay"), 10);
        this.dropTableDelay *= 1000;
        this.logger.info("config: import.dropTableDelay=" + this.dropTableDelay);
    }

    protected void processVDXConfig() {
        String vdxDriver = Util.stringToString(this.config.getString("vdx.driver"), DEFAULT_DRIVER);
        this.logger.info("config: vdx.driver=" + vdxDriver);
        String vdxPrefix = this.config.getString("vdx.prefix");
        if (vdxPrefix == null) {
            this.fatalError("vdx.prefix is missing from config file.");
        }
        this.logger.info("config: vdx.prefix=" + vdxPrefix);
        String vdxURL = this.config.getString("vdx.url");
        if (vdxURL == null) {
            this.fatalError("vdx.url is missing from config file.");
        }
        this.logger.info("config: vdx.url=" + vdxURL);
        String vdxName = this.config.getString("vdx.name");
        if (vdxName == null) {
            this.fatalError("vdx.name is missing from config file.");
        }
        this.logger.info("config: vdx.name=" + vdxName);
        this.sqlDataSourceHandler = new SQLDataSourceHandler(vdxDriver, vdxURL, vdxPrefix);
        this.sqlDataSourceDescriptor = this.sqlDataSourceHandler.getDataSourceDescriptor(vdxName);
        if (this.sqlDataSourceDescriptor == null) {
            this.logger.log(Level.SEVERE, vdxName + " not in vdxSources.config");
            System.exit(-1);
        }
        this.sqlDataSource = (SQLRSAMDataSource)this.sqlDataSourceDescriptor.getSQLDataSource();
    }

    protected void processDefaultOptions() {
        this.defaultOptions = new Options();
        this.defaultOptions.bufThreshold = 1;
        this.defaultOptions.timeThreshold = 1.0;
        this.defaultOptions.maxBacklog = 100;
        this.defaultOptions.maxDays = 0;
        this.defaultOptions.rsamEnable = true;
        this.defaultOptions.rsamDelta = 10;
        this.defaultOptions.rsamDuration = 60;
        ConfigFile dcf = this.config.getSubConfig("Default");
        this.defaultOptions = Options.createOptions(dcf, this.defaultOptions);
        this.logger.info("config, options, Default: " + this.defaultOptions);
    }

    protected void processOptions() {
        this.optionFilters = new ArrayList<OptionsFilter>();
        List<String> optionSets = this.config.getList("options");
        for (String options : optionSets) {
            if (options.equals("Default")) continue;
            ConfigFile tc = this.config.getSubConfig(options);
            try {
                OptionsFilter filter = new OptionsFilter(options, tc, this.defaultOptions);
                this.optionFilters.add(filter);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Could not create options: ", ex);
            }
        }
        for (OptionsFilter filter : this.optionFilters) {
            this.logger.info("config, options, " + filter.getName() + ": " + filter);
        }
    }

    protected void processFilters() {
        this.traceBufFilters = new ArrayList<TraceBufFilter>();
        List<String> filters = this.config.getList("filter");
        for (String filterName : filters) {
            ConfigFile fc = this.config.getSubConfig(filterName);
            try {
                TraceBufFilter filter = (TraceBufFilter)Class.forName(fc.getString("class")).newInstance();
                filter.configure(fc);
                this.traceBufFilters.add(filter);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "Could not create TraceBuf filter: ", ex);
            }
        }
        Collections.sort(this.traceBufFilters);
        for (TraceBufFilter filter : this.traceBufFilters) {
            this.logger.info("config, filter: " + filter);
        }
    }

    protected TraceBufFilter matchFilter(TraceBuf tb) {
        Options options = this.getOptions(tb);
        for (TraceBufFilter filter : this.traceBufFilters) {
            if (!filter.match(tb, options)) continue;
            Map<String, String> m = filter.getMetadata();
            if (m != null) {
                this.addMetadata(tb.toWinstonString(), m);
            }
            if (!filter.isTerminal()) continue;
            return filter;
        }
        return null;
    }

    private void addMetadata(String c, Map<String, String> m) {
        Map<String, String> cm = this.channelMetadata.get(c);
        if (cm == null) {
            cm = new HashMap<String, String>();
            this.channelMetadata.put(c, cm);
        }
        cm.putAll(m);
    }

    protected void addTraceBufToQueue(TraceBuf tb) {
        String channel = tb.toWinstonString();
        ConcurrentLinkedQueue<TraceBuf> q = this.channelTraceBufs.get(channel);
        if (q == null) {
            q = new ConcurrentLinkedQueue();
            this.channelTraceBufs.put(channel, q);
        }
        Options ip = this.getOptions(tb);
        q.add(tb);
        while (q.size() > ip.maxBacklog) {
            q.poll();
            ++this.totalTraceBufsDropped;
            if (this.totalTraceBufsDropped % 100 != 1) continue;
            this.logger.fine("Overfull backlog, dropped TraceBuf");
        }
    }

    private void cycle(boolean force) {
        for (String key : this.channelTraceBufs.keySet()) {
            ConcurrentLinkedQueue<TraceBuf> q = this.channelTraceBufs.get(key);
            if (q.isEmpty()) continue;
            Options ip = this.getOptions(q.peek());
            if (!force && !ip.thresholdExceeded(q.peek().getStartTimeJ2K(), q.size())) continue;
            this.importChannel(q);
        }
    }

    private void importChannel(ConcurrentLinkedQueue<TraceBuf> q) {
        if (q.isEmpty()) {
            System.out.println("isempty: " + q.isEmpty());
            return;
        }
        TraceBuf tb2 = q.peek();
        String code = tb2.station() + "$" + tb2.channel() + "$" + tb2.network();
        if (!this.existingChannels.contains(code) && this.sqlDataSource.defaultGetChannel(code, this.sqlDataSource.getChannelTypesFlag()) == null) {
            this.logger.info("Creating new channel '" + code + "' in VDX database.");
            Channel channel = new Channel(0, code, code, Double.NaN, Double.NaN, Double.NaN, 1);
            this.sqlDataSource.defaultCreateChannel(channel, 1, this.sqlDataSource.getChannelsFlag(), this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), this.sqlDataSource.getColumnsFlag());
            this.sqlDataSource.create10MinAvgView(code);
        }
        this.existingChannels.add(code);
        ArrayList<TraceBuf> tbs = new ArrayList<TraceBuf>(q.size());
        while (!q.isEmpty()) {
            TraceBuf t = q.poll();
            tbs.add(t);
            if (!t.sendAck) continue;
            this.importGeneric.sendAck(t.seq);
        }
        for (TraceBuf tb2 : tbs) {
            DoubleMatrix2D dm = DoubleFactory2D.dense.make(1, 2);
            dm.setQuick(0, 0, tb2.getStartTimeJ2K());
            dm.setQuick(0, 1, (double)tb2.samples()[0]);
            GenericDataMatrix gdm = new GenericDataMatrix(dm);
            gdm.setColumnNames(new String[]{"j2ksec", "rsam"});
            this.sqlDataSource.defaultInsertData(code, gdm, this.sqlDataSource.getTranslationsFlag(), this.sqlDataSource.getRanksFlag(), 0);
            this.logger.log(Level.FINE, code + " " + Util.j2KToDateString(tb2.getStartTimeJ2K()) + " rsam:" + tb2.samples()[0]);
            ++this.totalTraceBufsWritten;
        }
        ChannelStatus status = this.channelStatus.get(code);
        if (status == null) {
            status = new ChannelStatus(code);
            this.channelStatus.put(code, status);
        }
    }

    @Override
    public void run() {
        TraceBufHandler tbh = new TraceBufHandler();
        this.importGeneric.addListener(MessageType.TYPE_TRACEBUF, tbh);
        this.importGeneric.addListener(MessageType.TYPE_TRACEBUF2, tbh);
        boolean connected = false;
        while (!connected) {
            connected = this.importGeneric.connect();
            if (connected) continue;
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {}
        }
        while (!this.quit) {
            try {
                this.cycle(true);
                Thread.sleep(10L);
            }
            catch (OutOfMemoryError e) {
                this.handleOutOfMemoryError(e);
            }
            catch (Throwable e) {
                this.logger.log(Level.SEVERE, "Main loop exception: ", e);
            }
        }
        try {
            this.cycle(true);
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Exception during final cycle: ", e);
        }
    }

    protected Options getOptions(TraceBuf tb) {
        String channel = tb.toWinstonString();
        Options ip = this.channelOptions.get(channel);
        if (ip == null) {
            ip = this.defaultOptions;
            for (OptionsFilter tf : this.optionFilters) {
                if (!tf.match(tb)) continue;
                ip = tf.getOptions();
                break;
            }
            this.channelOptions.put(channel, ip);
        }
        return ip;
    }

    public void setLogLevel(Level level) {
        System.out.println("Logging set to " + level);
        this.logger.setLevel(level);
    }

    public void quit() {
        this.importGeneric.shutdown();
        try {
            this.importGeneric.join();
        }
        catch (Throwable e) {
            this.logger.log(Level.SEVERE, "Failed to cleanly shutdown SeedLink Collector", e);
        }
        this.logger.fine("Quitting cleanly.");
        this.quit = true;
    }

    public void printStatus() {
        Date now = CurrentTime.getInstance().nowDate();
        long nowST = System.currentTimeMillis();
        double uptime = (double)(now.getTime() - this.importStartTime.getTime()) / 1000.0;
        ArrayList<String> strings = new ArrayList<String>(4);
        strings.add("------- ImportEWRSAM --------");
        strings.add("Status time: " + this.dateFormat.format(now));
        strings.add("Start time:  " + this.dateFormat.format(this.importStartTime));
        strings.add("Up time:     " + Util.timeDifferenceToString(uptime));
        long ht = this.importGeneric.getLastHeartbeatTime();
        double dt = (double)(nowST - ht) / 1000.0;
        if (ht == 0L) {
            strings.add("Last HB RX:  (never)");
        } else {
            strings.add("Last HB RX:  " + this.dateFormat.format(new Date(ht)) + ", " + Util.timeDifferenceToString(dt));
        }
        ht = this.importGeneric.getLastHeartbeatSentTime();
        dt = (double)(nowST - ht) / 1000.0;
        if (ht == 0L) {
            strings.add("Last HB TX:  (never)");
        } else {
            strings.add("Last HB TX:  " + this.dateFormat.format(new Date(ht)) + ", " + Util.timeDifferenceToString(dt));
        }
        Runtime rt = Runtime.getRuntime();
        strings.add(String.format("Memory (used / max): %.1fMB / %.1fMB", (double)(rt.totalMemory() - rt.freeMemory()) / 1024.0 / 1024.0, (double)rt.maxMemory() / 1024.0 / 1024.0));
        strings.add("---- TraceBufs");
        strings.add("Accepted: " + this.totalTraceBufsAccepted);
        strings.add("Written:  " + this.totalTraceBufsWritten);
        strings.add("Failed:   " + this.totalTraceBufsFailed);
        strings.add("Rejected: " + this.totalTraceBufsRejected);
        strings.add("Dropped:  " + this.totalTraceBufsDropped);
        int pending = this.totalTraceBufsAccepted - this.totalTraceBufsWritten - this.totalTraceBufsFailed - this.totalTraceBufsRejected - this.totalTraceBufsDropped;
        strings.add("Pending:  " + pending);
        strings.add("---- Timing");
        strings.add(String.format("Total input time:        %s", Util.timeDifferenceToString(this.inputTimer.getTotalTimeMillis() / 1000.0)));
        strings.add(String.format("Input time per TraceBuf: %.2fms", this.inputTimer.getTotalTimeMillis() / (double)this.totalTraceBufsWritten));
        for (String s : strings) {
            System.out.println(s);
        }
    }

    public void printChannels(String s) {
        char col = 'C';
        if (s.length() > 1) {
            col = s.charAt(1);
        }
        boolean desc = s.endsWith("-");
        System.out.println("------- Channels --------");
        System.out.println(ChannelStatus.getHeaderString());
        ArrayList<ChannelStatus> channels = new ArrayList<ChannelStatus>(this.channelStatus.size());
        channels.addAll(this.channelStatus.values());
        Collections.sort(channels, ChannelStatus.getComparator(ChannelStatus.SortOrder.parse(col), desc));
        for (ChannelStatus channel : channels) {
            System.out.println(channel.toString());
        }
        System.out.println(ChannelStatus.getHeaderString());
    }

    public static JSAPResult getArguments(String[] args) {
        JSAPResult config = null;
        try {
            SimpleJSAP jsap = new SimpleJSAP(JSAP_PROGRAM_NAME, JSAP_EXPLANATION_PREFACE + DEFAULT_JSAP_EXPLANATION, DEFAULT_JSAP_PARAMETERS);
            config = jsap.parse(args);
            if (jsap.messagePrinted()) {
                if (!config.getBoolean("help")) {
                    System.err.println("Try using the --help flag.");
                }
                System.exit(1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        return config;
    }

    public static void printKeys() {
        StringBuffer sb = new StringBuffer();
        sb.append("Keys:\n");
        sb.append(" 0-3: logging level\n");
        sb.append("   i: stop accepting console commands\n");
        sb.append("   s: print status\n");
        sb.append("   c: print channels\n");
        sb.append("   q: quit\n");
        sb.append("   ?: display keys\n");
        System.out.println(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void consoleInputManager(ImportEWRSAM im) {
        im.logger.entering(im.getClass().getName(), "consoleInputManager");
        boolean acceptCommands = true;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        im.logger.info("Enter ? for console commands.");
        while (acceptCommands) {
            try {
                String s = null;
                try {
                    s = in.readLine();
                }
                catch (IOException ioex) {
                    im.logger.log(Level.SEVERE, "IOException encountered while attempting to read console input.", ioex);
                }
                if (s == null) continue;
                if ((s = s.toLowerCase().trim()).equals("q")) {
                    im.quit();
                    try {
                        im.join();
                    }
                    catch (Throwable e) {
                        im.logger.log(Level.SEVERE, "Failed to quit cleanly.", e);
                    }
                    finally {
                        im.printStatus();
                    }
                    System.exit(0);
                    continue;
                }
                if (s.equals("s")) {
                    im.printStatus();
                    continue;
                }
                if (s.startsWith("c")) {
                    im.printChannels(s);
                    continue;
                }
                if (s.equals("0")) {
                    im.setLogLevel(Level.OFF);
                    continue;
                }
                if (s.equals("1")) {
                    im.setLogLevel(Level.WARNING);
                    continue;
                }
                if (s.equals("2")) {
                    im.setLogLevel(Level.FINE);
                    continue;
                }
                if (s.equals("3")) {
                    im.setLogLevel(Level.ALL);
                    continue;
                }
                if (s.equals("i")) {
                    acceptCommands = false;
                    im.logger.warning("No longer accepting console commands.");
                    continue;
                }
                if (s.equals("?")) {
                    ImportEWRSAM.printKeys();
                    continue;
                }
                ImportEWRSAM.printKeys();
            }
            catch (OutOfMemoryError e) {
                im.handleOutOfMemoryError(e);
            }
        }
        im.logger.exiting(im.getClass().getName(), "consoleInputManager");
    }

    public static void main(String[] args) {
        JSAPResult config = ImportEWRSAM.getArguments(args);
        String fn = Util.stringToString(config.getString("configFilename"), DEFAULT_CONFIG_FILENAME);
        Level logLevel = Level.parse(DEFAULT_LOG_LEVEL);
        if (config.getString("logLevel") != null) {
            try {
                logLevel = Level.parse(config.getString("logLevel"));
            }
            catch (IllegalArgumentException ex) {
                System.err.println("Invalid log level: " + config.getString("logLevel"));
                System.err.println("Using default log level: " + logLevel);
            }
        } else {
            if (config.getBoolean("logoff")) {
                logLevel = Level.OFF;
            }
            if (config.getBoolean("lognormal")) {
                logLevel = Level.WARNING;
            }
            if (config.getBoolean("loghigh")) {
                logLevel = Level.FINE;
            }
            if (config.getBoolean("logall")) {
                logLevel = Level.ALL;
            }
        }
        ImportEWRSAM im = new ImportEWRSAM(fn);
        im.setLogLevel(logLevel);
        im.start();
        if (!config.getBoolean("noinput")) {
            ImportEWRSAM.consoleInputManager(im);
        }
    }

    class TraceBufHandler
    implements MessageListener {
        TraceBufHandler() {
        }

        @Override
        public void messageReceived(Message msg) {
            ++ImportEWRSAM.this.totalTraceBufs;
            TraceBuf tb = (TraceBuf)msg;
            ImportEWRSAM.this.logger.finest("RX: " + tb.toString());
            TraceBufFilter matchingFilter = ImportEWRSAM.this.matchFilter(tb);
            boolean accept = false;
            if (matchingFilter != null) {
                accept = matchingFilter.isAccept();
                if (ImportEWRSAM.this.logger.isLoggable(matchingFilter.getLogLevel())) {
                    ImportEWRSAM.this.logger.log(matchingFilter.getLogLevel(), String.format("%s: %s", matchingFilter, tb.toString()));
                }
            } else {
                ImportEWRSAM.this.logger.finest("No matching filter, rejected: " + tb);
            }
            if (accept) {
                ++ImportEWRSAM.this.totalTraceBufsAccepted;
                ImportEWRSAM.this.addTraceBufToQueue(tb);
            } else {
                ++ImportEWRSAM.this.totalTraceBufsRejected;
                if (msg.sendAck) {
                    ImportEWRSAM.this.importGeneric.sendAck(tb.seq);
                }
                if (matchingFilter.keepRejects()) {
                    // empty if block
                }
            }
        }
    }
}

