/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.db;

import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.GroupNode;
import gov.usgs.winston.Instrument;
import gov.usgs.winston.db.WinstonDatabase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class Channels {
    private WinstonDatabase winston;

    public Channels(WinstonDatabase w) {
        this.winston = w;
    }

    public Map<Integer, GroupNode> getGroupNodes() {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            HashMap<Integer, GroupNode> result = new HashMap<Integer, GroupNode>();
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT * FROM groupnodes");
            while (rs.next()) {
                GroupNode gn = new GroupNode(rs);
                result.put(gn.nid, gn);
            }
            GroupNode.buildTree(result);
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get groups.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public List<Channel> getChannels() {
        return this.getChannels(false);
    }

    public List<Channel> getChannelsByLastInsert() {
        List<Channel> sts = this.getChannels();
        Collections.sort(sts, new Comparator<Channel>(){

            @Override
            public int compare(Channel c1, Channel c2) {
                Double t1 = c1.getMaxTime();
                Double t2 = c2.getMaxTime();
                return t2.compareTo(t1);
            }
        });
        return sts;
    }

    public List<Channel> getChannels(boolean fullMetadata) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT sid, instruments.iid, code, alias, unit, linearA, linearB, st, et, instruments.lon, instruments.lat, height, name, description, timezone FROM channels LEFT JOIN instruments ON channels.iid=instruments.iid ORDER BY code ASC");
            HashMap<Integer, Channel> channelsMap = new HashMap<Integer, Channel>();
            ArrayList<Channel> channels = new ArrayList<Channel>();
            while (rs.next()) {
                Channel ch = new Channel(rs);
                channelsMap.put(ch.getSID(), ch);
                channels.add(ch);
            }
            rs.close();
            Map<Integer, GroupNode> nodes = this.getGroupNodes();
            rs = this.winston.executeQuery("SELECT sid, nid FROM grouplinks");
            while (rs.next()) {
                GroupNode gn;
                int sid = rs.getInt(1);
                int nid = rs.getInt(2);
                Channel ch = (Channel)channelsMap.get(sid);
                if (ch == null || (gn = nodes.get(nid)) == null) continue;
                ch.addGroup(gn.toString());
            }
            rs.close();
            if (fullMetadata) {
                PreparedStatement ps = this.winston.getPreparedStatement("SELECT * FROM channelmetadata WHERE sid=? ORDER BY name ASC");
                for (Channel ch : channels) {
                    HashMap<String, String> md = null;
                    ps.setInt(1, ch.getSID());
                    rs = ps.executeQuery();
                    while (rs.next()) {
                        if (md == null) {
                            md = new HashMap<String, String>();
                        }
                        md.put(rs.getString("name"), rs.getString("value"));
                    }
                    ch.setMetadata(md);
                }
            }
            return channels;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channels.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public int getChannelID(String code) {
        if (!this.winston.checkConnect()) {
            return -1;
        }
        try {
            int result = -1;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT sid FROM channels WHERE code='" + code + "'");
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channel ID.", e);
            return -1;
        }
    }

    public List<String> getChannelCodes(String chx) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        ArrayList<String> codes = new ArrayList<String>();
        try {
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT code FROM channels WHERE code LIKE '" + chx + "' ORDER BY code ASC");
            while (rs.next()) {
                codes.add(rs.getString(1));
            }
            rs.close();
            return codes;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channel codes.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public int getInstrumentId(String name) {
        if (!this.winston.checkConnect()) {
            return -1;
        }
        try {
            int result = -1;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT iid FROM instruments WHERE name='" + name + "'");
            if (rs.next()) {
                result = rs.getInt(1);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get instrument ID.", e);
            return -1;
        }
    }

    public String getChannelCode(int sid) {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            String result = null;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT code FROM channels WHERE sid=" + sid);
            if (rs.next()) {
                result = rs.getString(1);
            }
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get channel code.", Util.getLineNumber(this, e));
            return null;
        }
    }

    public boolean channelExists(String code) {
        if (!this.winston.checkConnect()) {
            return false;
        }
        try {
            boolean result = false;
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.getStatement().executeQuery("SELECT sid FROM channels WHERE code='" + code + "'");
            result = rs.next();
            rs.close();
            return result;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not determine channel existence.", Util.getLineNumber(this, e));
            return false;
        }
    }

    public boolean instrumentExists(String name) {
        return this.getInstrumentId(name) > 0;
    }

    public boolean createChannel(String code) {
        if (!this.winston.checkConnect()) {
            return false;
        }
        try {
            this.winston.useRootDatabase();
            this.winston.getStatement().execute("INSERT INTO channels (code, st, et) VALUES ('" + code + "', 1E300, -1E300)");
            this.winston.getStatement().execute("CREATE DATABASE `" + this.winston.databasePrefix + "_" + code + "`");
            this.winston.getStatement().execute("USE `" + this.winston.databasePrefix + "_" + code + "`");
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not create channel.  Are permissions set properly?", Util.getLineNumber(this, e));
        }
        return false;
    }

    public void updateInstrument(Instrument inst) {
        if (!this.winston.checkConnect()) {
            return;
        }
        try {
            boolean instrumentExists;
            this.winston.useRootDatabase();
            int iid = this.getInstrumentId(inst.getName());
            PreparedStatement ps = null;
            boolean bl = instrumentExists = iid > 0;
            if (instrumentExists) {
                ps = this.winston.getPreparedStatement("UPDATE instruments SET name=?, description=?, lon=?, lat=?, height=? where iid=?;");
                ps.setInt(6, iid);
            } else {
                ps = this.winston.getPreparedStatement("INSERT INTO instruments (name, description, lon, lat, height) VALUES (?,?,?,?,?);");
            }
            ps.setString(1, inst.getName());
            ps.setString(2, inst.getDescription());
            ps.setDouble(3, inst.getLongitude());
            ps.setDouble(4, inst.getLatitude());
            ps.setDouble(5, inst.getHeight());
            this.winston.getLogger().log(Level.FINEST, ps.toString());
            ps.execute();
            if (!instrumentExists) {
                iid = this.getInstrumentId(inst.getName());
                ps = this.winston.getPreparedStatement("UPDATE channels set iid=? WHERE code LIKE ?;");
                ps.setInt(1, iid);
                ps.setString(2, inst.getName() + "$%");
                this.winston.getLogger().log(Level.FINEST, ps.toString());
                ps.execute();
            }
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not create channel.  Are permissions set properly?", Util.getLineNumber(this, e));
            this.winston.getLogger().log(Level.SEVERE, e.getMessage());
            System.exit(1);
        }
    }

    public List<Instrument> getInstruments() {
        if (!this.winston.checkConnect()) {
            return null;
        }
        try {
            this.winston.useRootDatabase();
            ResultSet rs = this.winston.executeQuery("SELECT * FROM instruments ORDER BY name ASC");
            ArrayList<Instrument> insts = new ArrayList<Instrument>();
            while (rs.next()) {
                Instrument inst = new Instrument(rs);
                insts.add(inst);
            }
            rs.close();
            PreparedStatement ps = this.winston.getPreparedStatement("SELECT * FROM instrumentmetadata WHERE iid=? ORDER BY name ASC");
            for (Instrument inst : insts) {
                HashMap<String, String> md = null;
                ps.setInt(1, inst.getID());
                rs = ps.executeQuery();
                while (rs.next()) {
                    if (md == null) {
                        md = new HashMap<String, String>();
                    }
                    md.put(rs.getString("name"), rs.getString("value"));
                }
                inst.setMetadata(md);
            }
            return insts;
        }
        catch (Exception e) {
            this.winston.getLogger().log(Level.SEVERE, "Could not get instruments.", Util.getLineNumber(this, e));
            return null;
        }
    }
}

