/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.monitor.server;

import gov.usgs.net.CommandHandler;
import gov.usgs.net.NetTools;
import gov.usgs.winston.monitor.MonitorServer;
import gov.usgs.winston.monitor.server.BaseCommand;
import gov.usgs.winston.monitor.server.HttpGetCommand;
import java.nio.channels.SocketChannel;

public class ServerHandler
extends CommandHandler {
    private static final int PROTOCOL_VERSION = 3;
    private static int instances = 0;
    private NetTools netTools;
    private MonitorServer mon;

    public ServerHandler(MonitorServer s) {
        super(s, "MonitorServerHandler-" + instances++);
        this.mon = s;
        this.netTools = new NetTools();
        this.netTools.setServer(this.mon);
        this.setupCommandHandlers();
    }

    @Override
    protected void setupCommandHandlers() {
        this.addCommand("VERSION", new BaseCommand(this.netTools, this.mon){

            @Override
            public void doCommand(Object info, SocketChannel channel) {
                this.netTools.writeString("PROTOCOL_VERSION: 3\n", channel);
            }
        });
        this.addCommand("GET", new HttpGetCommand(this.netTools, this.mon, this));
    }
}

