/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server;

import gov.usgs.earthworm.WaveServer;
import gov.usgs.net.ReadListener;
import gov.usgs.plot.data.HelicorderData;
import gov.usgs.plot.data.RSAMData;
import gov.usgs.plot.data.Wave;
import gov.usgs.plot.data.file.FileType;
import gov.usgs.plot.data.file.SeismicDataFile;
import gov.usgs.util.Arguments;
import gov.usgs.util.Log;
import gov.usgs.util.Retriable;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.Channel;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WWSClient
extends WaveServer {
    protected ReadListener readListener;
    protected static final Logger logger = Log.getLogger("gov.usgs.winston.server.WaveServer");

    public WWSClient(String h, int p) {
        super(h, p);
        this.setTimeout(60000);
    }

    public void setReadListener(ReadListener rl) {
        this.readListener = rl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProtocolVersion() {
        int version = 1;
        try {
            if (!this.connected()) {
                this.connect();
            }
            this.socket.setSoTimeout(1000);
            this.writeString("VERSION\n");
            String result = this.readString();
            version = Integer.parseInt(result.split(" ")[1]);
        }
        catch (Exception e) {
        }
        finally {
            try {
                this.socket.setSoTimeout(this.timeout);
            }
            catch (Exception e) {}
        }
        return version;
    }

    protected byte[] getData(final String req, final boolean compressed) {
        byte[] ret = null;
        Retriable<byte[]> rt = new Retriable<byte[]>("WWSClient.getData()", this.maxRetries){

            @Override
            public void attemptFix() {
                WWSClient.this.close();
            }

            @Override
            public boolean attempt() throws UtilException {
                try {
                    if (!WWSClient.this.connected()) {
                        WWSClient.this.connect();
                    }
                    WWSClient.this.writeString(req);
                    String info = WWSClient.this.readString();
                    if (info.startsWith("ERROR")) {
                        logger.warning("Sent: " + req);
                        logger.warning("Got: " + info);
                        return false;
                    }
                    String[] ss = info.split(" ");
                    int bytes = Integer.parseInt(ss[1]);
                    if (bytes == 0) {
                        return true;
                    }
                    byte[] buf = WWSClient.this.readBinary(bytes, WWSClient.this.readListener);
                    if (compressed) {
                        buf = Util.decompress(buf);
                    }
                    this.result = buf;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    logger.warning("WWSClient.getData() timeout.");
                }
                catch (IOException e) {
                    logger.warning("WWSClient.getData() IOException: " + e.getMessage());
                }
                catch (NumberFormatException e) {
                    logger.warning("WWSClent.getData() couldn't parse server response. Is remote server a Winston Wave Server?");
                }
                return false;
            }
        };
        try {
            ret = (byte[])rt.go();
        }
        catch (UtilException e) {
            // empty catch block
        }
        return ret;
    }

    public List<Channel> getChannels() {
        return this.getChannels(false);
    }

    public List<Channel> getChannels(final boolean meta) {
        String[] result = null;
        Retriable<String[]> rt = new Retriable<String[]>("WWSClient.getChannels()", this.maxRetries){

            @Override
            public void attemptFix() {
                WWSClient.this.close();
            }

            @Override
            public boolean attempt() throws UtilException {
                try {
                    if (!WWSClient.this.connected()) {
                        WWSClient.this.connect();
                    }
                    String cmd = "GETCHANNELS: GC";
                    if (meta) {
                        cmd = cmd + " METADATA";
                    }
                    WWSClient.this.writeString(cmd + "\n");
                    String info = WWSClient.this.readString();
                    String[] ss = info.split(" ");
                    int lines = Integer.parseInt(ss[1]);
                    if (lines == 0) {
                        return true;
                    }
                    ss = new String[lines];
                    for (int i = 0; i < ss.length; ++i) {
                        ss[i] = WWSClient.this.readString();
                    }
                    this.result = ss;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    logger.warning("WWSClient.getChannels() timeout.");
                }
                catch (IOException e) {
                    logger.warning("WWSClient.getChannels() IOException: " + e.getMessage());
                }
                return false;
            }
        };
        try {
            result = (String[])rt.go();
        }
        catch (UtilException e) {
            // empty catch block
        }
        if (result == null) {
            return null;
        }
        ArrayList<Channel> chs = new ArrayList<Channel>(result.length);
        for (String s : result) {
            Channel ch = new Channel(s);
            chs.add(ch);
        }
        return chs;
    }

    public Wave getWave(String station, String comp, String network, String location, double start, double end, boolean compress) {
        String req = String.format(Locale.US, "GETWAVERAW: GS %s %s %s %s %f %f %s\n", station, comp, network, location == null ? "--" : location, start, end, compress ? "1" : "0");
        byte[] buf = this.getData(req, compress);
        if (buf == null) {
            return null;
        }
        return new Wave(ByteBuffer.wrap(buf));
    }

    public HelicorderData getHelicorder(String station, String comp, String network, String location, double start, double end, boolean compress) {
        String req = String.format(Locale.US, "GETSCNLHELIRAW: GS %s %s %s %s %f %f %s\n", station, comp, network, location, start, end, compress ? "1" : "0");
        byte[] buf = this.getData(req, compress);
        if (buf == null) {
            return null;
        }
        return new HelicorderData(ByteBuffer.wrap(buf));
    }

    public String[] getStatus() throws UtilException {
        return this.getStatus(0.0);
    }

    public String[] getStatus(Double d) throws UtilException {
        final double ageThreshold = d;
        Retriable<String[]> rt = new Retriable<String[]>("WWSClient.getStatus()", this.maxRetries){

            @Override
            public void attemptFix() {
                WWSClient.this.close();
            }

            @Override
            public boolean attempt() {
                try {
                    if (!WWSClient.this.connected()) {
                        WWSClient.this.connect();
                    }
                    String cmd = "STATUS: GC " + ageThreshold;
                    WWSClient.this.writeString(cmd + "\n");
                    String info = WWSClient.this.readString();
                    String[] ss = info.split(": ");
                    int lines = Integer.parseInt(ss[1]);
                    if (lines == 0) {
                        return true;
                    }
                    ss = new String[lines];
                    for (int i = 0; i < ss.length; ++i) {
                        ss[i] = WWSClient.this.readString();
                    }
                    this.result = ss;
                    return true;
                }
                catch (SocketTimeoutException e) {
                    logger.warning("WWSClient.getStatus() timeout.");
                }
                catch (IOException e) {
                    logger.warning("WWSClient.getChannels() IOException: " + e.getMessage());
                }
                return false;
            }
        };
        return (String[])rt.go();
    }

    public RSAMData getRSAMData(String station, String comp, String network, String location, double start, double end, int period, boolean compress) {
        String req = String.format(Locale.US, "GETSCNLRSAMRAW: GS %s %s %s %s %f %f %d %s\n", station, comp, network, location, start, end, period, compress ? "1" : "0");
        byte[] buf = this.getData(req, compress);
        if (buf == null) {
            return null;
        }
        return new RSAMData(ByteBuffer.wrap(buf), period);
    }

    public static void outputSac(String s, int p, Double st, Double et, String c) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String date = df.format(Util.j2KToDate(st)) + "-" + df.format(Util.j2KToDate(et));
        WWSClient.outputSac(s, p, st, et, c, c.replace('$', '_') + "_" + date + ".sac");
    }

    public static void outputSac(String s, int p, Double st, Double et, String c, String fn) {
        WWSClient winston = new WWSClient(s, p);
        winston.connect();
        String[] chan = c.split("\\$");
        String sta = chan[0];
        String comp = chan[1];
        String net = chan[2];
        String loc = chan.length == 4 ? chan[3] : null;
        Wave wave = winston.getWave(sta, comp, net, loc, st, et, false);
        if (wave != null) {
            wave = wave.subset(st, et);
            SeismicDataFile file = SeismicDataFile.getFile(fn, FileType.SAC);
            String channel = sta + "_" + comp + "_" + net;
            if (loc != null) {
                channel = channel + "_" + loc;
            }
            file.putWave(channel, wave);
            try {
                file.write();
            }
            catch (IOException e) {
                System.err.println("Couldn't write file: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("Wave not found");
        }
    }

    public static void outputSac(String server, int port, Double st, Double et, String c, String fn, double gulpSize, double gulpDelay) {
        Wave wave;
        Wave wavelet;
        WWSClient winston = new WWSClient(server, port);
        winston.connect();
        String[] chan = c.split("\\$");
        String sta = chan[0];
        String comp = chan[1];
        String net = chan[2];
        String loc = chan.length == 4 ? chan[3] : null;
        ArrayList<Wave> waves = new ArrayList<Wave>();
        double duration = et - st;
        int N = (int)Math.ceil(duration / gulpSize) - 1;
        double t1 = st;
        double t2 = 0.0;
        System.out.printf("Gulp size: %f (s), Gulp delay: %d (ms), Number of gulps: %d\n", gulpSize, (long)(gulpDelay * 1000.0), N + 1);
        for (int i = 0; i < N; ++i) {
            t2 = t1 + gulpSize;
            System.out.printf("Gulp #%d starting ... ", i + 1);
            wavelet = winston.getWave(sta, comp, net, loc, t1, t2, false);
            System.out.printf("done.\n", new Object[0]);
            if (wavelet != null) {
                waves.add(wavelet);
            }
            t1 = t2;
            if (gulpDelay == 0.0) continue;
            try {
                System.out.printf("Waiting ... ", new Object[0]);
                Thread.sleep((long)(gulpDelay * 1000.0));
                System.out.printf("done.\n\n", new Object[0]);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        t2 = et;
        System.out.printf("Gulp #%d starting ... ", N + 1);
        wavelet = winston.getWave(sta, comp, net, loc, t1, t2, false);
        System.out.printf("done.\n", N + 1);
        if (wavelet != null) {
            waves.add(wavelet);
        }
        if ((wave = Wave.join(waves)) != null) {
            wave = wave.subset(st, et);
            SeismicDataFile file = SeismicDataFile.getFile(fn, FileType.SAC);
            String channel = sta + "_" + comp + "_" + net;
            if (loc != null) {
                channel = channel + "_" + loc;
            }
            file.putWave(channel, wave);
            try {
                file.write();
            }
            catch (IOException e) {
                System.err.println("Couldn't write file: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("Wave not found");
        }
    }

    public static void outputText(String s, int p, Double st, Double et, String c) {
        System.out.println("dumping samples as text\n");
        WWSClient winston = new WWSClient(s, p);
        winston.connect();
        String[] chan = c.split("\\$");
        String sta = chan[0];
        String comp = chan[1];
        String net = chan[2];
        String loc = chan.length == 4 ? chan[3] : null;
        Wave wave = winston.getWave(sta, comp, net, loc, st, et, false);
        if (wave != null) {
            wave = wave.subset(st, et);
            for (int i : wave.buffer) {
                System.out.println(i);
            }
        } else {
            System.out.println("Wave not found");
        }
    }

    public static void main(String[] as) {
        Logger logger = Log.getLogger("gov.usgs.winston");
        logger.setLevel(Level.INFO);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        Double st = null;
        Double et = null;
        HashSet<String> keys = new HashSet<String>();
        HashSet<String> flags = new HashSet<String>();
        flags.add("--help");
        flags.add("-sac");
        flags.add("-txt");
        keys.add("-s");
        keys.add("-p");
        keys.add("-st");
        keys.add("-et");
        keys.add("-c");
        Arguments args = new Arguments(as, flags, keys);
        if (args.flagged("--help") | as.length == 0) {
            System.err.println("java gov.usgs.winston.server.WWSClient [OPTIONS]\n");
            System.out.println("-s [server]\t\tWinston server");
            System.out.println("-p [port]\t\tport");
            System.out.println("-st [yyyymmddHHmmss]\tstart time");
            System.out.println("-et [yyyymmddHHmmss]\tend time");
            System.out.println("-c [s$c$n$l]\t\tchannel");
            System.out.println("-sac\t\t\toutput sac file");
            System.out.println("-txt\t\t\toutput text");
            System.exit(-1);
        }
        String s = args.get("-s");
        int p = Integer.parseInt(args.get("-p"));
        try {
            st = Util.dateToJ2K(df.parse(args.get("-st")));
            et = Util.dateToJ2K(df.parse(args.get("-et")));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String c = args.get("-c");
        if (args.flagged("-sac")) {
            System.out.println(s + ":" + p + ":" + st + ":" + et + ":" + c);
            WWSClient.outputSac(s, p, st, et, c);
        }
        if (args.flagged("-txt")) {
            WWSClient.outputText(s, p, st, et, c);
        }
    }
}

