/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.NetTools;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.WWSCommandString;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetSCNCommand
extends BaseCommand {
    public GetSCNCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    public void doCommand(Object info, SocketChannel channel) {
        int totalBytes = 0;
        WWSCommandString cmd = new WWSCommandString((String)info);
        if (!cmd.isLegalSCNTT(8)) {
            return;
        }
        int sid = this.emulator.getChannelID(cmd.getS(), cmd.getC(), cmd.getN());
        if (sid == -1) {
            this.sendNoChannelResponse(cmd.getID(), 0, cmd.getS(), cmd.getC(), cmd.getN(), null, channel);
            return;
        }
        double t1 = Util.ewToJ2K(cmd.getT1(false));
        t1 = this.timeOrMaxDays(t1);
        double t2 = Util.ewToJ2K(cmd.getT2(false));
        double[] bounds = this.checkTimes(sid, t1, t2 = this.timeOrMaxDays(t2));
        if (!this.allowTransaction(bounds)) {
            this.netTools.writeString(cmd.getEarthwormErrorString(sid, this.getError(bounds)), channel);
            return;
        }
        Wave wave = null;
        try {
            wave = this.data.getWave(sid, t1, t2, 0);
        }
        catch (UtilException e) {
            // empty catch block
        }
        if (wave != null) {
            totalBytes = this.writeWaveAsAscii(wave, sid, cmd.getID(), cmd.getS(), cmd.getC(), cmd.getN(), null, t1, t2, cmd.getString(7), channel);
        } else {
            this.netTools.writeString(cmd.getEarthwormErrorString(sid, "FG s4"), channel);
        }
        String scn = cmd.getS() + "_" + cmd.getC() + "_" + cmd.getN();
        String time = Util.j2KToDateString(t1) + " - " + Util.j2KToDateString(t2);
        this.wws.log(Level.FINER, "GETSCN " + scn + " : " + time + ", " + totalBytes + " bytes.", channel);
    }
}

