/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd;

import gov.usgs.net.NetTools;
import gov.usgs.plot.data.Wave;
import gov.usgs.util.Util;
import gov.usgs.util.UtilException;
import gov.usgs.winston.db.WinstonDatabase;
import gov.usgs.winston.server.WWS;
import gov.usgs.winston.server.WWSCommandString;
import gov.usgs.winston.server.cmd.BaseCommand;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class GetSCNLCommand
extends BaseCommand {
    public GetSCNLCommand(NetTools nt, WinstonDatabase db, WWS wws) {
        super(nt, db, wws);
    }

    @Override
    public void doCommand(Object info, SocketChannel channel) {
        int totalBytes = 0;
        WWSCommandString cmd = new WWSCommandString((String)info);
        if (!cmd.isLegalSCNLTT(9)) {
            return;
        }
        int sid = this.emulator.getChannelID(cmd.getS(), cmd.getC(), cmd.getN(), cmd.getL());
        if (sid == -1) {
            this.sendNoChannelResponse(cmd.getID(), 0, cmd.getS(), cmd.getC(), cmd.getN(), cmd.getL(), channel);
            return;
        }
        double t1 = Util.ewToJ2K(cmd.getT1(true));
        t1 = this.timeOrMaxDays(t1);
        double t2 = Util.ewToJ2K(cmd.getT2(true));
        double[] bounds = this.checkTimes(sid, t1, t2 = this.timeOrMaxDays(t2));
        if (!this.allowTransaction(bounds)) {
            this.netTools.writeString(cmd.getEarthwormErrorString(sid, this.getError(bounds)), channel);
            return;
        }
        Wave wave = null;
        try {
            wave = this.data.getWave(sid, t1, t2, 0);
        }
        catch (UtilException e) {
            // empty catch block
        }
        if (wave != null) {
            totalBytes = this.writeWaveAsAscii(wave, sid, cmd.getID(), cmd.getS(), cmd.getC(), cmd.getN(), cmd.getL(), t1, t2, cmd.getString(8), channel);
        } else {
            this.netTools.writeString(cmd.getEarthwormErrorString(sid, "FG s4"), channel);
        }
        String scn = cmd.getS() + "_" + cmd.getC() + "_" + cmd.getN() + "_" + cmd.getL();
        String time = Util.j2KToDateString(t1) + " - " + Util.j2KToDateString(t2);
        this.wws.log(Level.FINER, "GETSCNL " + scn + " : " + time + ", " + totalBytes + " bytes.", channel);
    }
}

