/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.winston.server.cmd.http.fdsn.constraint;

import gov.usgs.util.Util;
import gov.usgs.winston.Channel;
import gov.usgs.winston.server.cmd.http.fdsn.FdsnException;
import gov.usgs.winston.server.cmd.http.fdsn.constraint.FdsnTimeConstraint;
import java.text.ParseException;

public class FdsnTimeWindowConstraint
extends FdsnTimeConstraint {
    double startBefore;
    double startAfter;
    double endBefore;
    double endAfter;

    public FdsnTimeWindowConstraint(String startBefore, String startAfter, String endBefore, String endAfter) throws FdsnException {
        try {
            this.startBefore = this.dateStringToDouble(startBefore, "2070-01-01T00:00:00.0000");
            this.startAfter = this.dateStringToDouble(startAfter, "1970-01-01T00:00:00.0000");
            this.endBefore = this.dateStringToDouble(endBefore, "2070-01-01T00:00:00.0000");
            this.endAfter = this.dateStringToDouble(endAfter, "1970-01-01T00:00:00.0000");
        }
        catch (ParseException e) {
            throw new FdsnException(400, "Can't parse time constraint: " + this);
        }
    }

    @Override
    public boolean matches(Channel chan) {
        double start = chan.getMinTime();
        if (start > this.startBefore || start < this.startAfter) {
            return false;
        }
        double end = chan.getMaxTime();
        return !(end > this.endBefore) && !(end < this.endAfter);
    }

    public String toString() {
        return "FdsnTimeWindowConstraint: " + Util.j2KToDateString(this.startBefore) + " : " + Util.j2KToDateString(this.startAfter) + " : " + Util.j2KToDateString(this.endBefore) + " : " + Util.j2KToDateString(this.endAfter);
    }
}

