/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.earthworm;

import edu.sc.seis.seisFile.earthworm.BufferingEarthwormExport;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBufferingEarthwormExport
extends BufferingEarthwormExport {
    File bufferDir = new File("buffer");
    String filePrefix = "earthwormBuf";
    int fileNum = 1;
    int maxFiles = 1000;
    List<File> fileBuffers = Collections.synchronizedList(new ArrayList());
    List<TraceBuf2> popBuffer = Collections.synchronizedList(new ArrayList(this.maxSize));
    private static final Logger logger = LoggerFactory.getLogger(FileBufferingEarthwormExport.class);

    public FileBufferingEarthwormExport(int port, int module, int institution, String heartbeatMessage, int heartbeatSeconds, int bufferSize, int sleepMillis) throws UnknownHostException, IOException {
        super(port, module, institution, heartbeatMessage, heartbeatSeconds, bufferSize, sleepMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void offer(TraceBuf2 tb) {
        List list = this.buffer;
        synchronized (list) {
            if (this.buffer.size() == this.getMaxSize()) {
                ArrayList tempBuf = new ArrayList(this.getMaxSize());
                Collections.copy(tempBuf, this.buffer);
                this.buffer.clear();
                File bufFile = this.nextBufferFile();
                this.fileBuffers.add(bufFile);
                try {
                    DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(bufFile)));
                    for (TraceBuf2 traceBuf2 : tempBuf) {
                        traceBuf2.write(dos);
                    }
                }
                catch (FileNotFoundException e) {
                    logger.error("Unable to save to file", (Throwable)e);
                }
                catch (IOException e) {
                    logger.error("Unable to save to file", (Throwable)e);
                }
            }
            super.offer(tb);
        }
    }

    @Override
    public TraceBuf2 pop() {
        while (this.popBuffer.size() == 0 && this.fileBuffers.size() != 0) {
            File next = this.fileBuffers.remove(0);
            try {
                DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(next)));
                while (in.available() > 0) {
                    TraceBuf2 tb = TraceBuf2.read(in);
                    this.popBuffer.add(tb);
                }
                return this.popBuffer.remove(0);
            }
            catch (FileNotFoundException e) {
                logger.error("Unable to load from file: " + next, (Throwable)e);
            }
            catch (EOFException e) {
                logger.error("IOException loading from file: " + next, (Throwable)e);
            }
            catch (IOException e) {
                logger.error("IOException loading from file: " + next, (Throwable)e);
            }
        }
        if (this.popBuffer.size() != 0) {
            return this.popBuffer.remove(0);
        }
        return super.pop();
    }

    File nextBufferFile() {
        String filename = "" + this.fileNum++;
        if (this.fileNum > this.maxFiles) {
            this.fileNum = 0;
        }
        while (filename.length() < 4) {
            filename = "0" + filename;
        }
        filename = this.filePrefix + filename;
        return new File(this.bufferDir, filename);
    }
}

