/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.client.AbstractClient;
import edu.sc.seis.seisFile.fdsnws.FDSNWSException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class AbstractFDSNQuerier {
    String userAgent = AbstractClient.DEFAULT_USER_AGENT;
    int responseCode;
    boolean error;
    String errorMessage;
    boolean empty;
    XMLEventReader reader;
    InputStream inputStream;
    protected URI connectionUri;
    protected int connectTimeout = DEFAULT_CONNECT_TIMEOUT;
    protected int readTimeout = DEFAULT_READ_TIMEOUT;
    public static int DEFAULT_CONNECT_TIMEOUT = 10000;
    public static int DEFAULT_READ_TIMEOUT = 60000;
    private static final Logger logger = LoggerFactory.getLogger(AbstractFDSNQuerier.class);

    protected void connect(URI uri) throws FDSNWSException {
        this.connectionUri = uri;
        try {
            URLConnection urlConn = uri.toURL().openConnection();
            urlConn.setConnectTimeout(this.getConnectTimeout());
            urlConn.setReadTimeout(this.getReadTimeout());
            if (urlConn instanceof HttpURLConnection) {
                ((HttpURLConnection)urlConn).setRequestProperty("User-Agent", this.getUserAgent());
                ((HttpURLConnection)urlConn).setRequestProperty("Accept", "application/xml");
                ((HttpURLConnection)urlConn).setRequestProperty("Accept-Encoding", "gzip, deflate");
            }
            this.processConnection(urlConn);
        }
        catch (IOException e) {
            throw new FDSNWSException("Problem with connection", e, uri);
        }
        catch (RuntimeException e) {
            throw new FDSNWSException("Problem with connection", e, uri);
        }
    }

    protected void processConnection(URLConnection urlConn) throws IOException {
        if (urlConn instanceof HttpURLConnection) {
            HttpURLConnection conn = (HttpURLConnection)urlConn;
            this.responseCode = conn.getResponseCode();
            if (this.responseCode == 204) {
                this.empty = true;
                return;
            }
            if (this.responseCode != 200) {
                this.error = true;
                this.errorMessage = "Code: " + this.responseCode + " " + AbstractFDSNQuerier.extractErrorMessage(conn);
                return;
            }
        }
        this.inputStream = "gzip".equals(urlConn.getContentEncoding()) ? new GZIPInputStream(new BufferedInputStream(urlConn.getInputStream())) : new BufferedInputStream(urlConn.getInputStream());
    }

    public static void validate(XMLStreamReader reader, URL schemaURL) throws SAXException, IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaURL);
        Validator validator = schema.newValidator();
        validator.validate(new StAXSource(reader), null);
    }

    public void outputRaw(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream bufIn = new BufferedInputStream(in);
        BufferedOutputStream bufOut = new BufferedOutputStream(out);
        byte[] buf = new byte[1024];
        int numRead = bufIn.read(buf);
        while (numRead != -1) {
            bufOut.write(buf, 0, numRead);
            numRead = bufIn.read(buf);
        }
        bufIn.close();
        bufOut.flush();
    }

    public boolean isError() {
        this.checkConnectionInitiated();
        return this.error;
    }

    public String getErrorMessage() {
        this.checkConnectionInitiated();
        return this.errorMessage;
    }

    public boolean isEmpty() {
        this.checkConnectionInitiated();
        return this.empty;
    }

    public InputStream getInputStream() {
        this.checkConnectionInitiated();
        return this.inputStream;
    }

    public URI getConnectionUri() {
        this.checkConnectionInitiated();
        return this.connectionUri;
    }

    public void checkConnectionInitiated() {
        if (this.connectionUri == null) {
            throw new RuntimeException("Not connected yet");
        }
    }

    public XMLEventReader getReader() throws XMLStreamException {
        if (this.reader == null) {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            this.reader = factory.createXMLEventReader(this.getConnectionUri().toString(), this.getInputStream());
        }
        return this.reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String extractErrorMessage(HttpURLConnection conn) {
        String out = "";
        BufferedReader errReader = null;
        try {
            InputStream inError = conn.getErrorStream();
            if (inError == null) {
                out = "<Empty Error Message From Server>";
            } else {
                String line;
                if ("gzip".equals(conn.getContentEncoding())) {
                    inError = new GZIPInputStream(inError);
                }
                errReader = new BufferedReader(new InputStreamReader(inError));
                while ((line = errReader.readLine()) != null) {
                    out = out + line + "\n";
                }
            }
        }
        catch (IOException e) {
            out = out + "\nException reading error stream: " + e.toString();
        }
        finally {
            if (errReader != null) {
                try {
                    errReader.close();
                    conn.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return out;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setConnectTimeout(int milliseconds) {
        this.connectTimeout = milliseconds;
    }

    public void setReadTimeout(int milliseconds) {
        this.readTimeout = milliseconds;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }
}

