/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class FDSNDataSelectQueryParams
extends AbstractQueryParams
implements Cloneable {
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String NETWORK = "network";
    public static final String STATION = "station";
    public static final String LOCATION = "location";
    public static final String CHANNEL = "channel";
    public static final String QUALITY = "quality";
    public static final String MINIMUMLENGTH = "minimumlength";
    public static final String LONGESTONLY = "longestonly";
    public static final String DATASELECT_SERVICE = "dataselect";

    public FDSNDataSelectQueryParams() {
        this("service.iris.edu");
    }

    public FDSNDataSelectQueryParams(String host) {
        super(host == null ? "service.iris.edu" : host);
    }

    public FDSNDataSelectQueryParams clone() {
        FDSNDataSelectQueryParams out = new FDSNDataSelectQueryParams(this.getHost());
        for (String key : this.params.keySet()) {
            out.setParam(key, (String)this.params.get(key));
        }
        return out;
    }

    public FDSNDataSelectQueryParams setHost(String host) {
        this.host = host;
        return this;
    }

    public FDSNDataSelectQueryParams setStartTime(Date value) {
        this.setParam(STARTTIME, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearStartTime() {
        this.clearParam(STARTTIME);
        return this;
    }

    public FDSNDataSelectQueryParams setEndTime(Date value) {
        this.setParam(ENDTIME, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearEndTime() {
        this.clearParam(ENDTIME);
        return this;
    }

    public FDSNDataSelectQueryParams appendToNetwork(String value) {
        this.appendToParam(NETWORK, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearNetwork() {
        this.clearParam(NETWORK);
        return this;
    }

    public FDSNDataSelectQueryParams appendToStation(String value) {
        this.appendToParam(STATION, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearStation() {
        this.clearParam(STATION);
        return this;
    }

    public FDSNDataSelectQueryParams appendToLocation(String value) {
        if ("  ".equals(value)) {
            value = "--";
        }
        this.appendToParam(LOCATION, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearLocation() {
        this.clearParam(LOCATION);
        return this;
    }

    public FDSNDataSelectQueryParams appendToChannel(String value) {
        this.appendToParam(CHANNEL, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearChannel() {
        this.clearParam(CHANNEL);
        return this;
    }

    public FDSNDataSelectQueryParams setQuality(String value) {
        this.setParam(QUALITY, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearQuality() {
        this.clearParam(QUALITY);
        return this;
    }

    public FDSNDataSelectQueryParams setMinimumLength(int value) {
        this.setParam(MINIMUMLENGTH, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearMinimumLength() {
        this.clearParam(MINIMUMLENGTH);
        return this;
    }

    public FDSNDataSelectQueryParams setLongestOnly(boolean value) {
        this.setParam(LONGESTONLY, value);
        return this;
    }

    public FDSNDataSelectQueryParams clearLongestOnly() {
        this.clearParam(LONGESTONLY);
        return this;
    }

    public String formPostString() {
        ArrayList<ChannelTimeWindow> request = new ArrayList<ChannelTimeWindow>();
        String[] netSplit = this.getParam(NETWORK).split(",");
        String[] staSplit = this.getParam(STATION).split(",");
        String[] locSplit = this.getParam(LOCATION).split(",");
        String[] chanSplit = this.getParam(CHANNEL).split(",");
        SimpleDateFormat sdf = FDSNDataSelectQueryParams.createDateFormat();
        try {
            Date beginDate = sdf.parse(this.getParam(STARTTIME));
            Date endDate = sdf.parse(this.getParam(ENDTIME));
            for (int n = 0; n < netSplit.length; ++n) {
                for (int s = 0; s < staSplit.length; ++s) {
                    for (int l = 0; l < locSplit.length; ++l) {
                        for (int c = 0; c < chanSplit.length; ++c) {
                            request.add(new ChannelTimeWindow(netSplit[n], staSplit[s], locSplit[l], chanSplit[c], beginDate, endDate));
                        }
                    }
                }
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Problem parsing date", e);
        }
        return this.formPostString(request);
    }

    public String formPostString(List<ChannelTimeWindow> request) {
        StringBuffer out = new StringBuffer();
        if (this.getParam(QUALITY) != null) {
            out.append("quality=" + this.getParam(QUALITY) + "\n");
        }
        if (this.getParam(MINIMUMLENGTH) != null) {
            out.append("minimumlength=" + this.getParam(MINIMUMLENGTH) + "\n");
        }
        if (this.getParam(LONGESTONLY) != null) {
            out.append("longestonly=" + this.getParam(LONGESTONLY) + "\n");
        }
        String SEP = " ";
        for (ChannelTimeWindow ctw : request) {
            out.append(ctw.formString(SEP, FDSNDataSelectQueryParams.createDateFormat(), true) + "\n");
        }
        return out.toString();
    }

    @Override
    public String getServiceName() {
        return DATASELECT_SERVICE;
    }
}

