/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws;

import edu.sc.seis.seisFile.fdsnws.AbstractQueryParams;
import java.util.Date;

public class FDSNStationQueryParams
extends AbstractQueryParams
implements Cloneable {
    public static final String STARTTIME = "starttime";
    public static final String ENDTIME = "endtime";
    public static final String STARTBEFORE = "startbefore";
    public static final String STARTAFTER = "startafter";
    public static final String ENDBEFORE = "endbefore";
    public static final String ENDAFTER = "endafter";
    public static final String NETWORK = "network";
    public static final String STATION = "station";
    public static final String LOCATION = "location";
    public static final String CHANNEL = "channel";
    public static final String MINLATITUDE = "minlatitude";
    public static final String MAXLATITUDE = "maxlatitude";
    public static final String MINLONGITUDE = "minlongitude";
    public static final String MAXLONGITUDE = "maxlongitude";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String MINRADIUS = "minradius";
    public static final String MAXRADIUS = "maxradius";
    public static final String LEVEL = "level";
    public static final String INCLUDERESTRICTED = "includerestricted";
    public static final String INCLUDEAVAILABILITY = "includeavailability";
    public static final String UPDATEDAFTER = "updatedafter";
    public static final String LEVEL_NETWORK = "network";
    public static final String LEVEL_STATION = "station";
    public static final String LEVEL_CHANNEL = "channel";
    public static final String LEVEL_RESPONSE = "response";
    public static final String STATION_SERVICE = "station";

    public FDSNStationQueryParams() {
        this("service.iris.edu");
    }

    public FDSNStationQueryParams(String host) {
        super(host == null ? "service.iris.edu" : host);
    }

    public FDSNStationQueryParams clone() {
        FDSNStationQueryParams out = new FDSNStationQueryParams(this.getHost());
        for (String key : this.params.keySet()) {
            out.setParam(key, (String)this.params.get(key));
        }
        return out;
    }

    public FDSNStationQueryParams setHost(String host) {
        this.host = host;
        return this;
    }

    public FDSNStationQueryParams setStartTime(Date value) {
        this.setParam(STARTTIME, value);
        return this;
    }

    public FDSNStationQueryParams clearStartTime() {
        this.clearParam(STARTTIME);
        return this;
    }

    public FDSNStationQueryParams setEndTime(Date value) {
        this.setParam(ENDTIME, value);
        return this;
    }

    public FDSNStationQueryParams clearEndTime() {
        this.clearParam(ENDTIME);
        return this;
    }

    public FDSNStationQueryParams setStartBefore(Date value) {
        this.setParam(STARTBEFORE, value);
        return this;
    }

    public FDSNStationQueryParams clearStartBefore() {
        this.clearParam(STARTBEFORE);
        return this;
    }

    public FDSNStationQueryParams setStartAfter(Date value) {
        this.setParam(STARTAFTER, value);
        return this;
    }

    public FDSNStationQueryParams clearStartAfter() {
        this.clearParam(STARTAFTER);
        return this;
    }

    public FDSNStationQueryParams setEndBefore(Date value) {
        this.setParam(ENDBEFORE, value);
        return this;
    }

    public FDSNStationQueryParams clearEndBefore() {
        this.clearParam(ENDBEFORE);
        return this;
    }

    public FDSNStationQueryParams setEndAfter(Date value) {
        this.setParam(ENDAFTER, value);
        return this;
    }

    public FDSNStationQueryParams clearEndAfter() {
        this.clearParam(ENDAFTER);
        return this;
    }

    public FDSNStationQueryParams appendToNetwork(String value) {
        this.appendToParam("network", value);
        return this;
    }

    public FDSNStationQueryParams clearNetwork() {
        this.clearParam("network");
        return this;
    }

    public FDSNStationQueryParams appendToStation(String value) {
        this.appendToParam("station", value);
        return this;
    }

    public FDSNStationQueryParams clearStation() {
        this.clearParam("station");
        return this;
    }

    public FDSNStationQueryParams appendToLocation(String value) {
        if ("  ".equals(value)) {
            value = "--";
        }
        this.appendToParam(LOCATION, value);
        return this;
    }

    public FDSNStationQueryParams clearLocation() {
        this.clearParam(LOCATION);
        return this;
    }

    public FDSNStationQueryParams appendToChannel(String value) {
        this.appendToParam("channel", value);
        return this;
    }

    public FDSNStationQueryParams clearChannel() {
        this.clearParam("channel");
        return this;
    }

    public FDSNStationQueryParams setMinLatitude(float value) {
        this.setParam(MINLATITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMinLatitude() {
        this.clearParam(MINLATITUDE);
        return this;
    }

    public FDSNStationQueryParams setMaxLatitude(float value) {
        this.setParam(MAXLATITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMaxLatitude() {
        this.clearParam(MAXLATITUDE);
        return this;
    }

    public FDSNStationQueryParams setMinLongitude(float value) {
        this.setParam(MINLONGITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMinLongitude() {
        this.clearParam(MINLONGITUDE);
        return this;
    }

    public FDSNStationQueryParams setMaxLongitude(float value) {
        this.setParam(MAXLONGITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearMaxLongitude() {
        this.clearParam(MAXLONGITUDE);
        return this;
    }

    public FDSNStationQueryParams setLatitude(float value) {
        this.setParam(LATITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearLatitude() {
        this.clearParam(LATITUDE);
        return this;
    }

    public FDSNStationQueryParams setLongitude(float value) {
        this.setParam(LONGITUDE, value);
        return this;
    }

    public FDSNStationQueryParams clearLongitude() {
        this.clearParam(LONGITUDE);
        return this;
    }

    public FDSNStationQueryParams setMinRadius(float value) {
        this.setParam(MINRADIUS, value);
        return this;
    }

    public FDSNStationQueryParams clearMinRadius() {
        this.clearParam(MINRADIUS);
        return this;
    }

    public FDSNStationQueryParams setMaxRadius(float value) {
        this.setParam(MAXRADIUS, value);
        return this;
    }

    public FDSNStationQueryParams clearMaxRadius() {
        this.clearParam(MAXRADIUS);
        return this;
    }

    public FDSNStationQueryParams setLevel(String value) {
        this.setParam(LEVEL, value);
        return this;
    }

    public FDSNStationQueryParams clearLevel() {
        this.clearParam(LEVEL);
        return this;
    }

    public FDSNStationQueryParams setIncludeRestricted(boolean value) {
        this.setParam(INCLUDERESTRICTED, value);
        return this;
    }

    public FDSNStationQueryParams clearIncludeRestricted() {
        this.clearParam(INCLUDERESTRICTED);
        return this;
    }

    public FDSNStationQueryParams setIncludeAvailability(boolean value) {
        this.setParam(INCLUDEAVAILABILITY, value);
        return this;
    }

    public FDSNStationQueryParams clearIncludeAvailability() {
        this.clearParam(INCLUDEAVAILABILITY);
        return this;
    }

    public FDSNStationQueryParams setUpdatedAfter(Date value) {
        this.setParam(UPDATEDAFTER, value);
        return this;
    }

    public FDSNStationQueryParams clearUpdatedAfter() {
        this.clearParam(UPDATEDAFTER);
        return this;
    }

    public FDSNStationQueryParams area(float minLat, float maxLat, float minLon, float maxLon) {
        return this.setMinLatitude(minLat).setMaxLatitude(maxLat).setMinLongitude(minLon).setMaxLongitude(maxLon);
    }

    public FDSNStationQueryParams ring(float lat, float lon, float maxRadius) {
        return this.setLatitude(lat).setLongitude(lon).setMaxRadius(maxRadius);
    }

    public FDSNStationQueryParams donut(float lat, float lon, float minRadius, float maxRadius) {
        return this.ring(lat, lon, maxRadius).setMinRadius(minRadius);
    }

    @Override
    public String getServiceName() {
        return "station";
    }
}

