/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.fdsnws.quakeml;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.fdsnws.StaxUtil;
import edu.sc.seis.seisFile.fdsnws.quakeml.EventParameters;
import edu.sc.seis.seisFile.fdsnws.stationxml.FDSNStationXML;
import java.net.URL;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Quakeml {
    EventParameters eventParameters;
    XMLEventReader reader;
    String schemaVersion;

    public Quakeml(XMLEventReader reader) throws XMLStreamException, SeisFileException {
        this.reader = reader;
        StaxUtil.skipToStartElement(reader);
        StartElement startE = StaxUtil.expectStartElement("quakeml", reader);
        this.schemaVersion = startE.getName().getNamespaceURI();
        while (reader.hasNext()) {
            XMLEvent e = reader.peek();
            if (e.isStartElement()) {
                String elName = e.asStartElement().getName().getLocalPart();
                if (elName.equals("eventParameters")) {
                    this.eventParameters = new EventParameters(reader);
                    break;
                }
                System.err.println("QuakeML skipping " + elName);
                StaxUtil.skipToMatchingEnd(reader);
                continue;
            }
            if (e.isEndElement()) {
                reader.nextEvent();
                return;
            }
            XMLEvent xMLEvent = reader.nextEvent();
        }
    }

    public EventParameters getEventParameters() {
        return this.eventParameters;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public boolean checkSchemaVersion() {
        return "http://quakeml.org/xmlns/quakeml/1.2".equals(this.schemaVersion);
    }

    public static Quakeml createEmptyQuakeML() {
        try {
            URL url = Quakeml.class.getClassLoader().getResource("edu/sc/seis/seisFile/quakeml/1.2/empty.quakeml");
            XMLInputFactory factory = XMLInputFactory.newInstance();
            XMLEventReader r = factory.createXMLEventReader(url.toString(), url.openStream());
            return new Quakeml(r);
        }
        catch (Exception e) {
            throw new RuntimeException("Should not happen", e);
        }
    }

    public static URL loadSchema() {
        return FDSNStationXML.class.getClassLoader().getResource("edu/sc/seis/seisFile/quakeml/1.2/QuakeML-1.2.xsd");
    }
}

