/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.sc.seis.seisFile.earthworm.BufferingEarthwormExport;
import edu.sc.seis.seisFile.earthworm.TraceBuf2;
import edu.sc.seis.seisFile.gcf.Convert;
import edu.sc.seis.seisFile.gcf.GCFBlock;
import edu.sc.seis.seisFile.gcf.GCFFormatException;
import edu.sc.seis.seisFile.gcf.SerialTransportLayer;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TooManyListenersException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCFEarthwormExport
implements SerialPortEventListener {
    SerialPort serialPort;
    int seqNum = 0;
    DataInputStream in;
    DataOutputStream out;
    String serial = "/dev/ttyS0";
    Convert convert;
    BufferingEarthwormExport export;
    public static final String GCF_CHAN_PROP = "gcf2ew.channel.";
    private static final Logger logger = LoggerFactory.getLogger(GCFEarthwormExport.class);

    public GCFEarthwormExport(String serial, Map<String, String[]> sysId_StreamIdToSCNL, BufferingEarthwormExport export) {
        this.serial = serial;
        this.convert = new Convert(sysId_StreamIdToSCNL);
        this.export = export;
    }

    public void serialEvent(SerialPortEvent arg0) {
        try {
            SerialTransportLayer stl = SerialTransportLayer.read(this.in);
            this.out.write(1);
            this.out.write(stl.getStreamIdLSB());
            this.out.flush();
            if (stl.getPayload() instanceof GCFBlock) {
                GCFBlock block = (GCFBlock)stl.getPayload();
                TraceBuf2 tb = this.convert.toTraceBuf(block);
                this.export.offer(tb);
            }
        }
        catch (GCFFormatException e) {
            this.handleError(e);
        }
        catch (IOException e) {
            this.handleError(e);
        }
    }

    public void handleError(Throwable t) {
        logger.error("error, reconnecting serial port", t);
        try {
            this.in.close();
        }
        catch (IOException e1) {
            // empty catch block
        }
        this.in = null;
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    GCFEarthwormExport.this.connect();
                }
                catch (Throwable tt) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    GCFEarthwormExport.this.handleError(tt);
                }
            }
        }, 10L);
    }

    void connect() throws NoSuchPortException, PortInUseException, UnsupportedCommOperationException, IOException, TooManyListenersException {
        CommPortIdentifier portIdentifier;
        if (this.serialPort != null) {
            this.serialPort.close();
            try {
                Thread.sleep(500L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((portIdentifier = CommPortIdentifier.getPortIdentifier((String)this.serial)).isCurrentlyOwned()) {
            logger.error("Error: Port is currently in use");
        } else {
            logger.info("Connecting");
            CommPort commPort = portIdentifier.open(this.getClass().getName(), 2000);
            if (commPort instanceof SerialPort) {
                this.serialPort = (SerialPort)commPort;
                this.serialPort.setSerialPortParams(19200, 8, 1, 0);
                logger.info("serial in buffer" + this.serialPort.getInputBufferSize());
                this.in = new DataInputStream(new BufferedInputStream(this.serialPort.getInputStream(), 4096));
                this.out = new DataOutputStream(this.serialPort.getOutputStream());
                logger.info("serial connect, clean buffer");
                int cleanBytes = 0;
                while (this.in.available() > 0) {
                    this.in.read();
                    ++cleanBytes;
                }
                logger.info("serial buffer cleaned: " + cleanBytes + " bytes discarded.");
                this.serialPort.addEventListener((SerialPortEventListener)this);
                this.serialPort.notifyOnDataAvailable(true);
            } else {
                logger.error("Error: Only serial ports are handled by this example.");
            }
        }
    }

    public static void main(String[] args) throws IOException, NoSuchPortException, PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        BasicConfigurator.configure();
        int port = 3000;
        int module = 999;
        int institution = 999;
        int heartbeat = 30;
        int buffer = 1000;
        String serial = "/dev/ttyS0";
        String propsFilename = null;
        Properties props = new Properties();
        for (int i = 0; i < args.length; ++i) {
            if (i >= args.length - 1) continue;
            if (args[i].equals("--module")) {
                module = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("--inst")) {
                institution = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("--heartbeat")) {
                heartbeat = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("--serial")) {
                serial = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("--port")) {
                port = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (args[i].equals("--buffer")) {
                buffer = Integer.parseInt(args[i + 1]);
                ++i;
                continue;
            }
            if (!args[i].equals("-p")) continue;
            propsFilename = args[i + 1];
            ++i;
        }
        if (propsFilename != null) {
            props.load(new BufferedReader(new FileReader(propsFilename)));
            PropertyConfigurator.configure((Properties)props);
        }
        logger.info("Start: port=" + port + " mod=" + module + " inst=" + institution + " heartbeat=" + heartbeat + " serial=" + serial + " buffer=" + buffer);
        BufferingEarthwormExport export = new BufferingEarthwormExport(port, module, institution, "heartbeat", heartbeat, buffer, 50);
        HashMap<String, String[]> sysId_StreamIdToSCNL = new HashMap<String, String[]>();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(GCF_CHAN_PROP)) continue;
            String sys_streamid = key.substring(GCF_CHAN_PROP.length());
            String[] scnl = props.getProperty(key).split("\\.");
            if (scnl.length != 4) {
                System.err.println("error with property " + key + "=" + props.getProperty(key));
            }
            sysId_StreamIdToSCNL.put(sys_streamid, scnl);
        }
        GCFEarthwormExport gcfExport = new GCFEarthwormExport(serial, sysId_StreamIdToSCNL, export);
        gcfExport.connect();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(10000L);
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
    }
}

