/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.gcf;

import edu.sc.seis.seisFile.gcf.AbstractGCFBlock;
import edu.sc.seis.seisFile.gcf.GCFHeader;
import java.io.DataOutput;
import java.io.IOException;

public class GCFStatusBlock
extends AbstractGCFBlock {
    String status;

    public GCFStatusBlock(GCFHeader header, String status) {
        super(header);
        this.header = header;
        this.status = status;
    }

    @Override
    public int getSize() {
        int size = 24;
        return size += (this.status.length() + 3) / 4 * 4;
    }

    @Override
    public void write(DataOutput out) throws NumberFormatException, IOException {
        this.header.write(out);
        out.writeChars(this.status);
        for (int i = 0; i < 4 - this.status.length() % 4; ++i) {
            out.writeChar(32);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GCFStatusBlock other = (GCFStatusBlock)obj;
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }
}

