/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.syncFile;

import edu.sc.seis.seisFile.SeisFileException;
import edu.sc.seis.seisFile.syncFile.GMTSyncFile;
import edu.sc.seis.seisFile.syncFile.SyncFile;
import edu.sc.seis.seisFile.syncFile.SyncLine;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SyncFileCompare {
    Date earliest;
    Date latest;
    SyncFile a;
    SyncFile b;
    SyncFile inAinB;
    SyncFile notAinB;
    SyncFile inAnotB;
    boolean verbose = false;

    public SyncFileCompare(SyncFile a, SyncFile b) {
        this.a = a;
        this.b = b;
        this.process();
    }

    void process() {
        String now = SyncLine.dateToString(new Date());
        if (!this.a.isEmpty()) {
            this.earliest = this.a.getEarliest();
            this.latest = this.a.getLatest();
        }
        if (!this.b.isEmpty()) {
            Date tmp = this.b.getEarliest();
            if (this.earliest == null || tmp.before(this.earliest)) {
                this.earliest = tmp;
            }
            tmp = this.b.getLatest();
            if (this.latest == null || tmp.after(this.latest)) {
                this.latest = tmp;
            }
        }
        this.inAinB = new SyncFile(this.a.dccName + " " + this.b.getDccName(), now, new String[]{"sync compare inAinB"});
        this.notAinB = new SyncFile("not " + this.a.dccName + " in " + this.b.getDccName(), now, new String[]{"sync compare notAinB"});
        this.inAnotB = new SyncFile("in " + this.a.dccName + " not " + this.b.getDccName(), now, new String[]{"sync compare inAnotB"});
        List<SyncLine> aLines = this.a.getSyncLines();
        Collections.sort(aLines);
        List<SyncLine> bLines = this.b.getSyncLines();
        Collections.sort(bLines);
        Iterator<SyncLine> bIterator = bLines.iterator();
        Iterator<SyncLine> aIterator = aLines.iterator();
        SyncLine[] out = new SyncLine[]{null, null};
        while (out[0] != null || out[1] != null || aIterator.hasNext() || bIterator.hasNext()) {
            if (out[0] == null && aIterator.hasNext()) {
                out[0] = aIterator.next();
            }
            if (out[1] == null && bIterator.hasNext()) {
                out[1] = bIterator.next();
            }
            out = SyncFileCompare.processItem(out[0], out[1], this.inAinB, this.notAinB, this.inAnotB);
        }
    }

    static SyncLine[] processItem(SyncLine aLine, SyncLine bLine, SyncFile inAinB, SyncFile notAinB, SyncFile inAnotB) {
        if (aLine != null && bLine != null) {
            if (!aLine.isSameChannel(bLine)) {
                if (aLine.compareTo(bLine) < 0) {
                    inAnotB.addLine(aLine, true);
                    aLine = null;
                } else {
                    notAinB.addLine(bLine, true);
                    bLine = null;
                }
            } else if (aLine.getEndTime().before(bLine.getStartTime())) {
                inAnotB.addLine(aLine, true);
                aLine = null;
            } else if (bLine.getEndTime().before(aLine.getStartTime())) {
                notAinB.addLine(bLine, true);
                bLine = null;
            } else if (aLine.getStartTime().equals(bLine.getStartTime()) && aLine.getEndTime().equals(bLine.getEndTime())) {
                inAinB.addLine(aLine);
                aLine = null;
                bLine = null;
            } else if (aLine.getStartTime().equals(bLine.getStartTime())) {
                if (aLine.getEndTime().before(bLine.getEndTime())) {
                    inAinB.addLine(aLine);
                    bLine = bLine.split(aLine.getEndTime())[1];
                    aLine = null;
                } else {
                    inAinB.addLine(bLine);
                    aLine = aLine.split(bLine.getEndTime())[1];
                    bLine = null;
                }
            } else if (aLine.getStartTime().before(bLine.getStartTime())) {
                SyncLine[] split = aLine.split(bLine.getStartTime());
                inAnotB.addLine(split[0]);
                if (split.length != 1) {
                    return SyncFileCompare.processItem(split[1], bLine, inAinB, notAinB, inAnotB);
                }
            } else if (bLine.getStartTime().before(aLine.getStartTime())) {
                SyncLine[] split = bLine.split(aLine.getStartTime());
                notAinB.addLine(split[0]);
                if (split.length != 1) {
                    return SyncFileCompare.processItem(aLine, split[1], inAinB, notAinB, inAnotB);
                }
            }
        } else if (aLine != null) {
            inAnotB.addLine(aLine);
            aLine = null;
        } else if (bLine != null) {
            notAinB.addLine(bLine);
            bLine = null;
        }
        return new SyncLine[]{aLine, bLine};
    }

    public SyncFile getA() {
        return this.a;
    }

    public SyncFile getB() {
        return this.b;
    }

    public SyncFile getInAinB() {
        return this.inAinB;
    }

    public SyncFile getNotAinB() {
        return this.notAinB;
    }

    public SyncFile getInAnotB() {
        return this.inAnotB;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Date getEarliest() {
        return this.earliest;
    }

    public Date getLatest() {
        return this.latest;
    }

    static void printUsage() {
        System.err.println("Usage: syncFileCompare [--gmt] -a file1.sync -b file2.sync");
    }

    static String trimDotSync(String filename) {
        String fileBase = new File(filename).getAbsoluteFile().getName();
        if (fileBase.endsWith(".sync")) {
            fileBase = fileBase.substring(0, fileBase.lastIndexOf(".sync"));
        }
        return fileBase;
    }

    static Date earliest(Date earliest, SyncFile sf) {
        if (!sf.isEmpty()) {
            Date tmp = sf.getEarliest();
            if (earliest == null || tmp.before(earliest)) {
                earliest = tmp;
            }
        }
        return earliest;
    }

    static Date latest(Date latest, SyncFile sf) {
        if (!sf.isEmpty()) {
            Date tmp = sf.getLatest();
            if (latest == null || tmp.after(latest)) {
                latest = tmp;
            }
        }
        return latest;
    }

    public static Date[] range(Collection<SyncFile> sfSet) {
        Date earliest = null;
        Date latest = null;
        for (SyncFile syncFile : sfSet) {
            earliest = SyncFileCompare.earliest(earliest, syncFile);
            latest = SyncFileCompare.latest(latest, syncFile);
        }
        return new Date[]{earliest, latest};
    }

    public static void main(String[] args) throws IOException, SeisFileException {
        boolean doGMT = false;
        String file1Name = "";
        String file2Name = "";
        for (int i = 0; i < args.length; ++i) {
            if ("--help".equals(args[i])) {
                SyncFileCompare.printUsage();
                return;
            }
            if ("--gmt".equals(args[i])) {
                doGMT = true;
                continue;
            }
            if ("-a".equals(args[i])) {
                file1Name = args[i + 1];
                ++i;
                continue;
            }
            if ("-b".equals(args[i])) {
                file2Name = args[i + 1];
                ++i;
                continue;
            }
            System.err.println("I don't understand '" + args[i] + "'");
            SyncFileCompare.printUsage();
            return;
        }
        if (file1Name.length() == 0 || file2Name.length() == 0) {
            System.err.println("Both a and b filenames are required: '" + file1Name + "' '" + file2Name + "'");
            SyncFileCompare.printUsage();
            return;
        }
        String file1Base = SyncFileCompare.trimDotSync(file1Name);
        String file2Base = SyncFileCompare.trimDotSync(file2Name);
        SyncFile file1 = SyncFile.load(new File(file1Name));
        SyncFile file2 = SyncFile.load(new File(file2Name));
        HashMap<String, SyncFile> file1Map = file1.splitByChannel();
        HashMap<String, SyncFile> file2Map = file2.splitByChannel();
        HashSet<String> chanKeys = new HashSet<String>(file1Map.keySet());
        chanKeys.addAll(file2Map.keySet());
        ArrayList<String> chanKeyList = new ArrayList<String>(chanKeys);
        Collections.sort(chanKeyList);
        HashMap<String, SyncFileCompare> compareMap = new HashMap<String, SyncFileCompare>();
        Date[] range1 = SyncFileCompare.range(file1Map.values());
        Date[] range2 = SyncFileCompare.range(file2Map.values());
        Date earliest = range1[0].before(range2[0]) ? range1[0] : range2[0];
        Date latest = range1[1].after(range2[1]) ? range1[1] : range2[1];
        for (String key : chanKeyList) {
            SyncFile b;
            SyncFile a;
            String chanPrefix = "";
            if (chanKeys.size() != 1) {
                chanPrefix = key + "_";
            }
            if ((a = file1Map.get(key)) == null) {
                a = new SyncFile(file1.dccName);
            }
            if ((b = file2Map.get(key)) == null) {
                b = new SyncFile(file2.dccName);
            }
            earliest = SyncFileCompare.earliest(earliest, a);
            earliest = SyncFileCompare.earliest(earliest, b);
            latest = SyncFileCompare.latest(latest, a);
            latest = SyncFileCompare.latest(latest, b);
            SyncFileCompare sfc = new SyncFileCompare(a, b);
            compareMap.put(key, sfc);
            sfc.getInAinB().saveToFile(chanPrefix + "in_" + file1Base + "_in_" + file2Base + ".sync");
            sfc.getNotAinB().saveToFile(chanPrefix + "not_" + file1Base + "_in_" + file2Base + ".sync");
            sfc.getInAnotB().saveToFile(chanPrefix + "in_" + file1Base + "_not_" + file2Base + ".sync");
            if (!sfc.isVerbose()) continue;
            System.out.println("Done: " + chanPrefix + "A: " + a.getSyncLines().size() + " B: " + b.getSyncLines().size() + " inAinB: " + sfc.getInAinB().getSyncLines().size() + " notAinB: " + sfc.getNotAinB().getSyncLines().size() + " inAnotB: " + sfc.getInAnotB().getSyncLines().size());
        }
        if (doGMT) {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("syncCompare.gmt")));
            int numChannels = chanKeyList.size();
            GMTSyncFile gmtPlotter = new GMTSyncFile(numChannels + 2, earliest, latest, out);
            Color bothColor = new Color(51, 255, 102);
            Color file1Color = new Color(51, 102, 255);
            Color file2Color = new Color(255, 51, 102);
            gmtPlotter.gmtHeader();
            gmtPlotter.setTextColor(bothColor);
            gmtPlotter.setJustify("CM");
            gmtPlotter.label(new Date((earliest.getTime() + latest.getTime()) / 2L), numChannels + 1, "Both");
            gmtPlotter.setTextColor(file1Color);
            gmtPlotter.setJustify("LM");
            gmtPlotter.label(earliest, numChannels + 1, "Only " + file1Base);
            gmtPlotter.setTextColor(file2Color);
            gmtPlotter.setJustify("RM");
            gmtPlotter.label(latest, numChannels + 1, "Only " + file2Base);
            int chanIndex = 0;
            Collections.reverse(chanKeyList);
            for (String chanKey : chanKeyList) {
                SyncFileCompare sfc = (SyncFileCompare)compareMap.get(chanKey);
                gmtPlotter.setLineColor(bothColor);
                gmtPlotter.plot(sfc.getInAinB(), ++chanIndex);
                gmtPlotter.setLineColor(file1Color);
                gmtPlotter.plot(sfc.getInAnotB(), chanIndex);
                gmtPlotter.setLineColor(file2Color);
                gmtPlotter.plot(sfc.getNotAinB(), chanIndex);
                gmtPlotter.setJustify("LB");
                gmtPlotter.setTextColor(Color.BLACK);
                gmtPlotter.label(earliest, chanIndex, chanKey);
            }
            gmtPlotter.gmtTrailer();
            out.close();
        }
    }
}

