/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.waveserver;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MenuItem {
    String station;
    String network;
    String channel;
    String location;
    double start;
    double end;
    int pin;
    String dataType;

    public MenuItem(String network, String station, String location, String channel, double start, double end, int pin, String dataType) {
        this.station = station;
        this.network = network;
        this.channel = channel;
        this.location = location;
        if ("--".equals(location)) {
            this.location = "  ";
        }
        this.start = start;
        this.end = end;
        this.pin = pin;
        this.dataType = dataType;
    }

    public String toString() {
        return this.network + " " + this.station + " " + this.location + " " + this.channel + " " + MenuItem.formatDate(MenuItem.toDate(this.start)) + " " + MenuItem.formatDate(MenuItem.toDate(this.end));
    }

    public static Date toDate(double val) {
        return new Date(Math.round(1000.0 * val));
    }

    public static String formatDate(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(d);
    }

    public String getStation() {
        return this.station;
    }

    public String getNetwork() {
        return this.network;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getLocation() {
        return this.location;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.end;
    }

    public Date getStartDate() {
        return MenuItem.toDate(this.start);
    }

    public Date getEndDate() {
        return MenuItem.toDate(this.end);
    }

    public int getPin() {
        return this.pin;
    }

    public String getDataType() {
        return this.dataType;
    }
}

