/*
 * Decompiled with CFR 0.152.
 */
package com.isti.dhi2mseed;

import com.isti.dhi.ChannelInfo;
import com.isti.dhi.IChannelInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class SCNLFileReader {
    private int lineno = 0;
    private final BufferedReader scnlReader;

    public SCNLFileReader(File scnlFile) throws FileNotFoundException {
        this.scnlReader = new BufferedReader(new FileReader(scnlFile));
    }

    public IChannelInfo getNextChannelInfo() {
        String line = this.getNextLine();
        if (line == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(line);
        int tokenCount = stringTokenizer.countTokens();
        if (tokenCount != 4) {
            System.err.println("Invalid number of tokens " + tokenCount + " on line " + this.lineno + ": " + line);
        }
        String stationName = stringTokenizer.nextToken();
        String channelName = stringTokenizer.nextToken();
        String networkName = stringTokenizer.nextToken();
        String locationName = stringTokenizer.nextToken();
        if (stationName == null || channelName == null || networkName == null || locationName == null) {
            System.err.println("Error parsing SCNL file (" + this.lineno + "): " + stationName + " " + channelName + " " + networkName + " " + locationName + " ");
            return null;
        }
        System.out.println("Processing SCNL file (" + this.lineno + "): " + stationName + " " + channelName + " " + networkName + " " + locationName + " ");
        return new ChannelInfo(stationName, channelName, networkName, locationName);
    }

    protected String getNextLine() {
        try {
            String line;
            do {
                if ((line = this.scnlReader.readLine()) == null) continue;
                ++this.lineno;
            } while (line != null && line.startsWith("#"));
            return line;
        }
        catch (IOException ex) {
            System.err.println("Error reading line " + this.lineno + ": " + ex);
            return null;
        }
    }
}

