/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetDatabase;
import com.ooc.OB.CodeSetIORInterceptor_impl;
import com.ooc.OB.PIManager;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.ProfileInfo;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CONV_FRAME.CodeSetComponentInfoHolder;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CONV_FRAME.CodeSetContextHolder;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;

public final class CodeSetUtil {
    private static int native_cs_ = 65537;
    private static int native_wcs_ = 65801;
    private static int default_wcs_;
    private static Vector supportedCharCodeSets_;
    private static Vector supportedWcharCodeSets_;

    static int native_cs() {
        return native_cs_;
    }

    public static void native_cs(int n) {
        native_cs_ = n;
    }

    static int native_wcs() {
        return native_wcs_;
    }

    public static void native_wcs(int n) {
        native_wcs_ = n;
    }

    public static void default_wcs(int n) {
        default_wcs_ = n;
    }

    static void addCharCodeSet(int n) {
        supportedCharCodeSets_.addElement(new Integer(n));
    }

    static void addWcharCodeSet(int n) {
        supportedCharCodeSets_.addElement(new Integer(n));
        supportedWcharCodeSets_.addElement(new Integer(n));
    }

    static CodeSetComponentInfo createCodeSetComponentInfo() {
        CodeSetComponent codeSetComponent = CodeSetUtil.createCharCodeSetComponent(native_cs_);
        CodeSetComponent codeSetComponent2 = CodeSetUtil.createWcharCodeSetComponent(native_wcs_);
        return new CodeSetComponentInfo(codeSetComponent, codeSetComponent2);
    }

    static CodeSetComponent createCharCodeSetComponent(int n) {
        CodeSetDatabase.instance();
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = n;
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration enumeration = supportedCharCodeSets_.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 == n) continue;
            vector.addElement(n2);
        }
        codeSetComponent.conversion_code_sets = new int[vector.size()];
        enumeration = vector.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            codeSetComponent.conversion_code_sets[n3++] = (Integer)enumeration.nextElement();
        }
        return codeSetComponent;
    }

    static CodeSetComponent createWcharCodeSetComponent(int n) {
        CodeSetDatabase.instance();
        CodeSetComponent codeSetComponent = new CodeSetComponent();
        codeSetComponent.native_code_set = n;
        Vector<Integer> vector = new Vector<Integer>();
        Enumeration enumeration = supportedWcharCodeSets_.elements();
        while (enumeration.hasMoreElements()) {
            Integer n2 = (Integer)enumeration.nextElement();
            if (n2 == n) continue;
            vector.addElement(n2);
        }
        codeSetComponent.conversion_code_sets = new int[vector.size()];
        enumeration = vector.elements();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            codeSetComponent.conversion_code_sets[n3++] = (Integer)enumeration.nextElement();
        }
        return codeSetComponent;
    }

    static boolean getCodeSetInfoFromComponents(ProfileInfo profileInfo, CodeSetComponentInfoHolder codeSetComponentInfoHolder) {
        if (profileInfo.major == 1 && profileInfo.minor == 0) {
            return false;
        }
        int n = 0;
        while (n < profileInfo.components.length) {
            if (CodeSetUtil.checkForCodeSetInfo(profileInfo.components[n], codeSetComponentInfoHolder)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    static CodeConverters getCodeConverters(ProfileInfo profileInfo) {
        CodeSetComponentInfoHolder codeSetComponentInfoHolder = new CodeSetComponentInfoHolder();
        codeSetComponentInfoHolder.value = new CodeSetComponentInfo();
        codeSetComponentInfoHolder.value.ForCharData = new CodeSetComponent();
        codeSetComponentInfoHolder.value.ForWcharData = new CodeSetComponent();
        codeSetComponentInfoHolder.value.ForCharData.native_code_set = 65537;
        codeSetComponentInfoHolder.value.ForCharData.conversion_code_sets = new int[0];
        codeSetComponentInfoHolder.value.ForWcharData.native_code_set = default_wcs_;
        codeSetComponentInfoHolder.value.ForWcharData.conversion_code_sets = new int[0];
        CodeSetUtil.getCodeSetInfoFromComponents(profileInfo, codeSetComponentInfoHolder);
        CodeSetDatabase codeSetDatabase = CodeSetDatabase.instance();
        CodeConverters codeConverters = new CodeConverters();
        CodeSetComponent codeSetComponent = CodeSetUtil.createCharCodeSetComponent(CodeSetUtil.native_cs());
        int n = codeSetDatabase.determineTCS(codeSetComponent, codeSetComponentInfoHolder.value.ForCharData, 0x5010001);
        codeConverters.inputCharConverter = codeSetDatabase.getConverter(CodeSetUtil.native_cs(), n);
        codeConverters.outputCharConverter = codeSetDatabase.getConverter(n, CodeSetUtil.native_cs());
        CodeSetComponent codeSetComponent2 = CodeSetUtil.createWcharCodeSetComponent(CodeSetUtil.native_wcs());
        int n2 = codeSetDatabase.determineTCS(codeSetComponent2, codeSetComponentInfoHolder.value.ForWcharData, 65801);
        codeConverters.wcharConverter = codeSetDatabase.getConverter(n2, CodeSetUtil.native_wcs());
        return codeConverters;
    }

    static boolean checkForCodeSetInfo(TaggedComponent taggedComponent, CodeSetComponentInfoHolder codeSetComponentInfoHolder) {
        if (taggedComponent.tag == 1) {
            byte[] byArray = taggedComponent.component_data;
            Buffer buffer = new Buffer(byArray, byArray.length);
            InputStream inputStream = new InputStream(buffer, 0, false, null, false);
            inputStream._OB_readEndian();
            codeSetComponentInfoHolder.value = CodeSetComponentInfoHelper.read(inputStream);
            return true;
        }
        return false;
    }

    static void extractCodeSetContext(ServiceContext serviceContext, CodeSetContextHolder codeSetContextHolder) {
        byte[] byArray = serviceContext.context_data;
        Buffer buffer = new Buffer(byArray, byArray.length);
        InputStream inputStream = new InputStream(buffer, 0, false, null, false);
        inputStream._OB_readEndian();
        codeSetContextHolder.value = CodeSetContextHelper.read(inputStream);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void unicodeToUtf8(OutputStream outputStream, char n) throws DATA_CONVERSION {
        int n2;
        int n3;
        if (n < 128) {
            n3 = n;
            n2 = 1;
        } else if (n < 2047) {
            n3 = 192;
            n2 = 2;
        } else {
            if (n >= 65535) {
                throw new DATA_CONVERSION();
            }
            n3 = 224;
            n2 = 3;
        }
        while (n2 > 1) {
            outputStream.buf_.data_[outputStream.buf_.pos_ + --n2] = (byte)(0x80 | n & 0x3F);
            n = (char)(n >> 6);
        }
        n3 = (char)(n3 | n);
        outputStream.buf_.data_[outputStream.buf_.pos_] = (byte)n3;
    }

    /*
     * Unable to fully structure code
     */
    static char utf8ToUnicode(InputStream var0) throws DATA_CONVERSION {
        if (((var1_1 = var0.buf_.data_[var0.buf_.pos_++]) & 128) == 0) {
            return (char)var1_1;
        }
        if ((var1_1 & 224) == 192) {
            var2_2 = 1;
            var3_3 = (char)(var1_1 & 31);
        } else if ((var1_1 & 240) == 224) {
            var2_2 = 2;
            var3_3 = (char)(var1_1 & 15);
        } else if ((var1_1 & 248) == 240) {
            var2_2 = 3;
            var3_3 = (char)(var1_1 & 7);
        } else if ((var1_1 & 252) == 248) {
            var2_2 = 4;
            var3_3 = (char)(var1_1 & 3);
        } else if ((var1_1 & 254) == 252) {
            var2_2 = 5;
            var3_3 = (char)(var1_1 & 1);
        } else {
            throw new DATA_CONVERSION();
        }
        if (var2_2 < 3) ** GOTO lbl31
        throw new DATA_CONVERSION();
lbl-1000:
        // 1 sources

        {
            if ((var0.buf_.data_[var0.buf_.pos_] & 192) != 128) {
                throw new DATA_CONVERSION();
            }
            var3_3 = (char)(var3_3 << 6);
            var3_3 = (char)(var3_3 | var0.buf_.data_[var0.buf_.pos_++] & 63);
            --var2_2;
lbl31:
            // 2 sources

            ** while (var2_2 != 0)
        }
lbl32:
        // 1 sources

        return var3_3;
    }

    public static void registerIORInterceptor(PIManager pIManager) {
        try {
            pIManager.addIORInterceptor(new CodeSetIORInterceptor_impl());
            return;
        }
        catch (DuplicateName duplicateName) {
            Assert.assert(false);
            return;
        }
    }

    static {
        supportedCharCodeSets_ = new Vector();
        supportedWcharCodeSets_ = new Vector();
    }
}

