/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.InputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.ClientManager;
import com.ooc.OB.ClientProfilePair;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.Downcall;
import com.ooc.OB.FailureException;
import com.ooc.OB.LocationForward;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.PIArgsDowncall;
import com.ooc.OB.PIDIIDowncall;
import com.ooc.OB.PIDowncall;
import com.ooc.OB.ParameterDesc;
import com.ooc.OB.RefCountPolicyList;
import com.ooc.OCI.ConnectorInfo;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.ProfileInfoHolder;
import com.ooc.OCI.TransportInfo;
import java.util.Vector;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.NO_RESOURCES;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.IOP.IOR;

public final class DowncallStub {
    private ORBInstance orbInstance_;
    private IOR IOR_;
    private IOR origIOR_;
    private RefCountPolicyList policies_;
    private Vector clientProfilePairs_ = null;

    private synchronized Client getClientProfilePair(ProfileInfoHolder profileInfoHolder) throws FailureException {
        java.lang.Object object;
        if (this.clientProfilePairs_ == null) {
            object = this.orbInstance_.getClientManager();
            this.clientProfilePairs_ = ((ClientManager)object).getClientProfilePairs(this.IOR_, this.policies_.value);
        }
        if (this.clientProfilePairs_.size() == 0) {
            object = this.orbInstance_.getCoreTraceLevels();
            if (((CoreTraceLevels)object).traceRetry() >= 2) {
                this.orbInstance_.getLogger().trace("retry", "no profiles available");
            }
            throw new FailureException(new NO_RESOURCES("No profiles available", 0, CompletionStatus.COMPLETED_NO));
        }
        object = (ClientProfilePair)this.clientProfilePairs_.elementAt(0);
        profileInfoHolder.value = ((ClientProfilePair)object).profile;
        return ((ClientProfilePair)object).client;
    }

    private void destroy() {
        ClientManager clientManager = this.orbInstance_.getClientManager();
        if (clientManager != null && this.clientProfilePairs_ != null) {
            int n = 0;
            while (n < this.clientProfilePairs_.size()) {
                ClientProfilePair clientProfilePair = (ClientProfilePair)this.clientProfilePairs_.elementAt(n);
                clientManager.releaseClient(clientProfilePair.client);
                ++n;
            }
        }
        this.clientProfilePairs_.removeAllElements();
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public DowncallStub(ORBInstance oRBInstance, IOR iOR, IOR iOR2, RefCountPolicyList refCountPolicyList) {
        this.orbInstance_ = oRBInstance;
        this.IOR_ = iOR;
        this.origIOR_ = iOR2;
        this.policies_ = refCountPolicyList;
    }

    public Downcall createDowncall(String string, boolean bl) throws FailureException {
        ProfileInfoHolder profileInfoHolder = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profileInfoHolder);
        Assert.assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profileInfoHolder.value, this.policies_, string, bl);
        }
        return new PIDowncall(this.orbInstance_, client, profileInfoHolder.value, this.policies_, string, bl, this.IOR_, this.origIOR_);
    }

    public Downcall createPIArgsDowncall(String string, boolean bl, ParameterDesc[] parameterDescArray, ParameterDesc parameterDesc, TypeCode[] typeCodeArray) throws FailureException {
        ProfileInfoHolder profileInfoHolder = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profileInfoHolder);
        Assert.assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profileInfoHolder.value, this.policies_, string, bl);
        }
        return new PIArgsDowncall(this.orbInstance_, client, profileInfoHolder.value, this.policies_, string, bl, this.IOR_, this.origIOR_, parameterDescArray, parameterDesc, typeCodeArray);
    }

    public Downcall createPIDIIDowncall(String string, boolean bl, NVList nVList, NamedValue namedValue, ExceptionList exceptionList) throws FailureException {
        ProfileInfoHolder profileInfoHolder = new ProfileInfoHolder();
        Client client = this.getClientProfilePair(profileInfoHolder);
        Assert.assert(client != null);
        if (!this.policies_.interceptor) {
            return new Downcall(this.orbInstance_, client, profileInfoHolder.value, this.policies_, string, bl);
        }
        return new PIDIIDowncall(this.orbInstance_, client, profileInfoHolder.value, this.policies_, string, bl, this.IOR_, this.origIOR_, nVList, namedValue, exceptionList);
    }

    public com.ooc.CORBA.OutputStream preMarshal(Downcall downcall) throws LocationForward, FailureException {
        return downcall.preMarshal();
    }

    public void marshalEx(Downcall downcall, SystemException systemException) throws LocationForward, FailureException {
        downcall.marshalEx(systemException);
    }

    public void postMarshal(Downcall downcall) throws LocationForward, FailureException {
        downcall.postMarshal();
    }

    public void request(Downcall downcall) throws LocationForward, FailureException {
        downcall.request();
    }

    public void oneway(Downcall downcall) throws LocationForward, FailureException {
        downcall.oneway();
    }

    public void deferred(Downcall downcall) throws LocationForward, FailureException {
        downcall.deferred();
    }

    public void response(Downcall downcall) throws LocationForward, FailureException {
        downcall.response();
    }

    public boolean poll(Downcall downcall) throws LocationForward, FailureException {
        return downcall.poll();
    }

    public InputStream preUnmarshal(Downcall downcall) throws LocationForward, FailureException {
        return downcall.preUnmarshal();
    }

    public InputStream preUnmarshal(Downcall downcall, BooleanHolder booleanHolder) throws LocationForward, FailureException {
        InputStream inputStream = downcall.preUnmarshal();
        booleanHolder.value = downcall.userException();
        return inputStream;
    }

    public void unmarshalEx(Downcall downcall, SystemException systemException) throws LocationForward, FailureException {
        downcall.unmarshalEx(systemException);
    }

    public void postUnmarshal(Downcall downcall) throws LocationForward, FailureException {
        downcall.postUnmarshal();
    }

    public String unmarshalExceptionId(Downcall downcall) {
        return downcall.unmarshalExceptionId();
    }

    public void setUserException(Downcall downcall, UserException userException, String string) {
        downcall.setUserException(userException, string);
    }

    public void setUserException(Downcall downcall, UserException userException) {
        downcall.setUserException(userException);
    }

    public synchronized void handleFailureException(Downcall downcall, FailureException failureException) throws FailureException {
        java.lang.Object object;
        java.lang.Object object2;
        Assert.assert(failureException.exception != null);
        Client client = downcall.client();
        ProfileInfo profileInfo = downcall.profileInfo();
        int n = 0;
        while (n < this.clientProfilePairs_.size()) {
            object2 = (ClientProfilePair)this.clientProfilePairs_.elementAt(n);
            if (((ClientProfilePair)object2).client == client && ((ClientProfilePair)object2).profile == profileInfo) {
                object = this.orbInstance_.getClientManager();
                if (object == null) {
                    throw new BAD_INV_ORDER(MinorCodes.describeBadInvOrder(1330446340), 1330446340, CompletionStatus.COMPLETED_NO);
                }
                ((ClientManager)object).releaseClient(((ClientProfilePair)object2).client);
                this.clientProfilePairs_.removeElementAt(n);
                break;
            }
            ++n;
        }
        try {
            throw failureException.exception;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
        }
        catch (TRANSIENT tRANSIENT) {
        }
        catch (NO_RESPONSE nO_RESPONSE) {
        }
        catch (SystemException systemException) {
            throw failureException;
        }
        if (this.policies_.retry == 0) {
            throw failureException;
        }
        if (this.policies_.retry == 1 && failureException.exception.completed != CompletionStatus.COMPLETED_NO) {
            throw failureException;
        }
        if (this.clientProfilePairs_.size() == 0) {
            object2 = this.orbInstance_.getCoreTraceLevels();
            if (((CoreTraceLevels)object2).traceRetry() >= 2) {
                object = "no profiles left to try\n" + failureException.exception.getMessage();
                this.orbInstance_.getLogger().trace("retry", (String)object);
            }
            throw failureException;
        }
        object2 = this.orbInstance_.getCoreTraceLevels();
        if (((CoreTraceLevels)object2).traceRetry() >= 2) {
            object = "trying next profile\n" + failureException.exception.getMessage();
            this.orbInstance_.getLogger().trace("retry", (String)object);
        }
    }

    public ConnectorInfo get_oci_connector_info() {
        try {
            ProfileInfoHolder profileInfoHolder = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfoHolder);
            Assert.assert(client != null);
            return client.connectorInfo();
        }
        catch (FailureException failureException) {
            Assert.assert(false);
            return null;
        }
    }

    public TransportInfo get_oci_transport_info() {
        try {
            ProfileInfoHolder profileInfoHolder = new ProfileInfoHolder();
            Client client = this.getClientProfilePair(profileInfoHolder);
            Assert.assert(client != null);
            return client.transportInfo();
        }
        catch (FailureException failureException) {
            Assert.assert(false);
            return null;
        }
    }

    public OutputStream setupRequest(Object object, String string, boolean bl) throws LocationForward, FailureException {
        while (true) {
            Downcall downcall = this.createDowncall(string, bl);
            try {
                com.ooc.CORBA.OutputStream outputStream = this.preMarshal(downcall);
                InvocationContext invocationContext = new InvocationContext();
                invocationContext.downcallStub = this;
                invocationContext.downcall = downcall;
                outputStream._OB_invocationContext(invocationContext);
                return outputStream;
            }
            catch (FailureException failureException) {
                this.handleFailureException(downcall, failureException);
                continue;
            }
            break;
        }
    }

    public org.omg.CORBA.portable.InputStream invoke(Object object, OutputStream outputStream) throws ApplicationException, RemarshalException, LocationForward, FailureException {
        com.ooc.CORBA.OutputStream outputStream2 = (com.ooc.CORBA.OutputStream)outputStream;
        InvocationContext invocationContext = (InvocationContext)outputStream2._OB_invocationContext();
        Assert.assert(invocationContext != null);
        if (invocationContext.downcallStub != this) {
            throw new RemarshalException();
        }
        Downcall downcall = invocationContext.downcall;
        try {
            downcall.postMarshal();
            boolean bl = downcall.responseExpected();
            if (bl) {
                downcall.request();
            } else {
                downcall.oneway();
            }
            if (bl) {
                InputStream inputStream = downcall.preUnmarshal();
                if (downcall.userException()) {
                    String string = null;
                    try {
                        string = downcall.unmarshalExceptionId();
                    }
                    catch (SystemException systemException) {
                        downcall.unmarshalEx(systemException);
                    }
                    downcall.setUserException(string);
                    downcall.postUnmarshal();
                    throw new ApplicationException(string, inputStream);
                }
                downcall.postUnmarshal();
                return inputStream;
            }
            downcall.preUnmarshal();
            downcall.postUnmarshal();
            return null;
        }
        catch (FailureException failureException) {
            this.handleFailureException(downcall, failureException);
            throw new RemarshalException();
        }
    }

    private class InvocationContext {
        DowncallStub downcallStub;
        Downcall downcall;

        InvocationContext() {
            DowncallStub.this = DowncallStub.this;
        }
    }
}

