/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.OutputStream;
import com.ooc.CORBA.OutputStreamHolder;
import com.ooc.OB.Assert;
import com.ooc.OB.Client;
import com.ooc.OB.CodeConverters;
import com.ooc.OB.CodeSetUtil;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.Downcall;
import com.ooc.OB.DowncallEmitter;
import com.ooc.OB.GIOPClientWorker;
import com.ooc.OB.GIOPClientWorkerBlocking;
import com.ooc.OB.GIOPClientWorkerThreaded;
import com.ooc.OB.GIOPOutgoingMessage;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.Connector;
import com.ooc.OCI.ConnectorInfo;
import com.ooc.OCI.ProfileInfo;
import com.ooc.OCI.Transport;
import com.ooc.OCI.TransportInfo;
import java.util.Vector;
import org.omg.CONV_FRAME.CodeSetContext;
import org.omg.CONV_FRAME.CodeSetContextHelper;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;

final class GIOPClient
extends Client {
    protected ORBInstance orbInstance_;
    protected int nextRequestId_;
    protected Object nextRequestIdMutex_ = new Object();
    protected Connector connector_;
    protected GIOPClientWorker worker_;
    protected ServiceContext codeSetSC_;
    protected int acmTimeout_;
    protected boolean destroy_;

    protected void finalize() throws Throwable {
        Assert.assert(this.destroy_);
        Assert.assert(this.worker_ == null);
        super.finalize();
    }

    protected synchronized GIOPClientWorker getWorker(boolean bl, int n) {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        if (this.worker_ == null && bl) {
            Object object;
            IDLEntity iDLEntity;
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                iDLEntity = this.connector_.get_info();
                object = "trying to establish connection\n";
                object = String.valueOf(object) + "timeout: ";
                if (n >= 0) {
                    object = String.valueOf(object) + n;
                    object = String.valueOf(object) + "ms\n";
                } else {
                    object = String.valueOf(object) + "none\n";
                }
                object = String.valueOf(object) + iDLEntity.describe();
                this.orbInstance_.getLogger().trace("outgoing", (String)object);
            }
            if (n >= 0) {
                iDLEntity = this.connector_.connect_timeout(n);
                if (iDLEntity == null) {
                    throw new NO_RESPONSE("Connection timeout", 0, CompletionStatus.COMPLETED_NO);
                }
            } else {
                iDLEntity = this.connector_.connect();
                Assert.assert(iDLEntity != null);
            }
            switch (this.concModel_) {
                case 0: {
                    this.worker_ = new GIOPClientWorkerBlocking(this.orbInstance_, this, (Transport)iDLEntity, this.acmTimeout_);
                    break;
                }
                case 2: {
                    this.worker_ = new GIOPClientWorkerThreaded(this.orbInstance_, this, (Transport)iDLEntity, this.acmTimeout_);
                    break;
                }
            }
            if (this.codeSetSC_ == null) {
                object = new CodeSetContext();
                CodeConverters codeConverters = this.codeConverters();
                ((CodeSetContext)object).char_data = codeConverters.outputCharConverter.getTo().rgy_value;
                ((CodeSetContext)object).wchar_data = codeConverters.wcharConverter != null ? codeConverters.wcharConverter.getTo().rgy_value : 0;
                Buffer buffer = new Buffer();
                OutputStream outputStream = new OutputStream(buffer);
                outputStream._OB_writeEndian();
                CodeSetContextHelper.write(outputStream, (CodeSetContext)object);
                this.codeSetSC_ = new ServiceContext();
                this.codeSetSC_.context_id = 1;
                int n2 = buffer.length();
                byte[] byArray = buffer.data();
                this.codeSetSC_.context_data = new byte[n2];
                System.arraycopy(byArray, 0, this.codeSetSC_.context_data, 0, n2);
            }
        }
        return this.worker_;
    }

    GIOPClient(ORBInstance oRBInstance, Connector connector, int n, CodeConverters codeConverters, int n2) {
        super(n, codeConverters);
        this.orbInstance_ = oRBInstance;
        this.connector_ = connector;
        this.acmTimeout_ = n2;
        this.destroy_ = false;
    }

    public void destroy() {
        GIOPClientWorker gIOPClientWorker = null;
        GIOPClient gIOPClient = this;
        synchronized (gIOPClient) {
            if (this.destroy_) {
                Object var3_3 = null;
                return;
            }
            this.destroy_ = true;
            gIOPClientWorker = this.worker_;
            this.worker_ = null;
        }
        if (gIOPClientWorker != null) {
            gIOPClientWorker.destroy();
        }
    }

    public synchronized void removeWorker(GIOPClientWorker gIOPClientWorker) {
        if (this.worker_ == gIOPClientWorker) {
            this.worker_ = null;
        }
    }

    public int requestId() {
        Object object = this.nextRequestIdMutex_;
        synchronized (object) {
            int n = this.nextRequestId_++;
            Object var3_3 = null;
            return n;
        }
    }

    public ProfileInfo[] getUsableProfiles(IOR iOR, Policy[] policyArray) {
        Object[] objectArray;
        ProfileInfo[] profileInfoArray = this.connector_.get_usable_profiles(iOR, policyArray);
        Vector<ProfileInfo> vector = new Vector<ProfileInfo>();
        int n = 0;
        while (n < profileInfoArray.length) {
            objectArray = CodeSetUtil.getCodeConverters(profileInfoArray[n]);
            if (this.codeConverters().equals(objectArray)) {
                vector.addElement(profileInfoArray[n]);
            }
            ++n;
        }
        objectArray = new ProfileInfo[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ConnectorInfo connectorInfo() {
        return this.connector_.get_info();
    }

    public TransportInfo transportInfo() {
        GIOPClientWorker gIOPClientWorker = this.getWorker(false, -1);
        if (gIOPClientWorker == null) {
            return null;
        }
        Transport transport = gIOPClientWorker.transport();
        return transport.get_info();
    }

    public DowncallEmitter startDowncall(Downcall downcall, OutputStreamHolder outputStreamHolder) {
        GIOPClientWorker gIOPClientWorker = null;
        try {
            gIOPClientWorker = this.getWorker(true, downcall.policies().connectTimeout);
        }
        catch (SystemException systemException) {
            Assert.assert(systemException.completed == CompletionStatus.COMPLETED_NO);
            downcall.setFailureException(systemException);
            return null;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            byte by = downcall.profileInfo().major;
            byte by2 = downcall.profileInfo().minor;
            if (!(gIOPClientWorker.messageSent() || by <= 1 && by2 < 1)) {
                object3 = this.orbInstance_.getCoreTraceLevels();
                if (((CoreTraceLevels)object3).traceConnections() >= 2) {
                    object2 = this.codeConverters();
                    object = "sending transmission code sets";
                    object = String.valueOf(object) + "\nchar code set: ";
                    object = String.valueOf(object) + ((CodeConverters)object2).outputCharConverter.getTo().description;
                    object = String.valueOf(object) + "\nwchar code set: ";
                    object = ((CodeConverters)object2).wcharConverter != null ? String.valueOf(object) + ((CodeConverters)object2).wcharConverter.getTo().description : String.valueOf(object) + "none";
                    this.orbInstance_.getLogger().trace("outgoing", (String)object);
                }
                Assert.assert(this.codeSetSC_ != null);
                downcall.addToRequestSCL(this.codeSetSC_);
            }
            object3 = downcall.profileInfo();
            object2 = new Buffer(12);
            ((Buffer)object2).pos(12);
            outputStreamHolder.value = new OutputStream((Buffer)object2, this.codeConverters(), ((ProfileInfo)object3).major == 1 && ((ProfileInfo)object3).minor < 2);
            object = new GIOPOutgoingMessage(this.orbInstance_, outputStreamHolder.value, (ProfileInfo)object3);
            ((GIOPOutgoingMessage)object).writeRequestHeader(downcall.requestId(), downcall.operation(), downcall.responseExpected(), downcall.getRequestSCL());
            return gIOPClientWorker;
        }
        catch (SystemException systemException) {
            Assert.assert(systemException.completed == CompletionStatus.COMPLETED_NO);
            downcall.setFailureException(systemException);
            return null;
        }
    }

    public boolean equal(Client client) {
        GIOPClient gIOPClient = null;
        try {
            gIOPClient = (GIOPClient)client;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.connector_.equal(gIOPClient.connector_)) {
            return false;
        }
        if (!this.codeConverters().equals(gIOPClient.codeConverters())) {
            return false;
        }
        return this.acmTimeout_ == gIOPClient.acmTimeout_;
    }
}

