/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.OutputStream;
import com.ooc.OB.Assert;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.ProfileInfo;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.GIOP.IORAddressingInfo;
import org.omg.GIOP.IORAddressingInfoHelper;
import org.omg.GIOP.LocateStatusType_1_2;
import org.omg.GIOP.MsgType_1_1;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.omg.GIOP.TargetAddress;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHelper;

public final class GIOPOutgoingMessage {
    private static int maxMessageSize_;
    private ORBInstance orbInstance_;
    private OutputStream out_;
    private ProfileInfo profileInfo_;

    private void writeServiceContextList(ServiceContext[] serviceContextArray) {
        int n = serviceContextArray.length;
        this.out_.write_ulong(n);
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                ServiceContext serviceContext = serviceContextArray[n2];
                this.out_.write_ulong(serviceContext.context_id);
                int n3 = serviceContext.context_data.length;
                this.out_.write_ulong(n3);
                this.out_.write_octet_array(serviceContext.context_data, 0, n3);
                ++n2;
            }
        }
    }

    private void writeTargetAddress(TargetAddress targetAddress) {
        short s = targetAddress.discriminator();
        this.out_.write_short(s);
        switch (s) {
            case 0: {
                byte[] byArray = targetAddress.object_key();
                int n = byArray.length;
                this.out_.write_ulong(n);
                if (n <= 0) break;
                this.out_.write_octet_array(byArray, 0, n);
                return;
            }
            case 1: {
                TaggedProfile taggedProfile = targetAddress.profile();
                TaggedProfileHelper.write(this.out_, taggedProfile);
                return;
            }
            case 2: {
                IORAddressingInfo iORAddressingInfo = targetAddress.ior();
                IORAddressingInfoHelper.write(this.out_, iORAddressingInfo);
                return;
            }
            default: {
                Assert.assert(false);
            }
        }
    }

    GIOPOutgoingMessage(ORBInstance oRBInstance, OutputStream outputStream, ProfileInfo profileInfo) {
        this.orbInstance_ = oRBInstance;
        this.out_ = outputStream;
        this.profileInfo_ = profileInfo;
    }

    ProfileInfo profileInfo() {
        return this.profileInfo_;
    }

    void writeMessageHeader(MsgType_1_1 msgType_1_1, boolean bl, int n) {
        Assert.assert(msgType_1_1.value() >= 0 && msgType_1_1.value() <= 7);
        Assert.assert(this.profileInfo_.major != 1 || this.profileInfo_.minor != 0 || msgType_1_1.value() <= 6 && !bl);
        if (maxMessageSize_ > 0 && n > maxMessageSize_) {
            String string = "outgoing message size (" + n + ") exceeds maximum (" + maxMessageSize_ + ")";
            this.orbInstance_.getLogger().warning(string);
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        byte by = 0;
        if (bl) {
            by = (byte)(by | 2);
        }
        byte[] byArray = new byte[]{71, 73, 79, 80};
        this.out_.write_octet_array(byArray, 0, 4);
        this.out_.write_octet(this.profileInfo_.major);
        this.out_.write_octet(this.profileInfo_.minor);
        this.out_.write_octet(by);
        this.out_.write_octet((byte)msgType_1_1.value());
        this.out_.write_ulong(n);
    }

    void writeRequestHeader(int n, String string, boolean bl, ServiceContext[] serviceContextArray) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                this.writeServiceContextList(serviceContextArray);
                this.out_.write_ulong(n);
                this.out_.write_boolean(bl);
                byte[] byArray = new byte[3];
                this.out_.write_octet_array(byArray, 0, 3);
                int n2 = this.profileInfo_.key.length;
                this.out_.write_ulong(n2);
                this.out_.write_octet_array(this.profileInfo_.key, 0, n2);
                int n3 = string.length();
                this.out_.write_ulong(n3 + 1);
                this.out_.write_octet_array(string.getBytes(), 0, n3);
                this.out_.write_octet((byte)0);
                this.out_.write_ulong(0);
                return;
            }
            case 2: {
                this.out_.write_ulong(n);
                byte by = 0;
                if (bl) {
                    by = (byte)(by | 3);
                }
                this.out_.write_octet(by);
                byte[] byArray = new byte[3];
                this.out_.write_octet_array(byArray, 0, 3);
                this.out_.write_short((short)0);
                int n4 = this.profileInfo_.key.length;
                this.out_.write_ulong(n4);
                this.out_.write_octet_array(this.profileInfo_.key, 0, n4);
                int n5 = string.length();
                this.out_.write_ulong(n5 + 1);
                this.out_.write_octet_array(string.getBytes(), 0, n5);
                this.out_.write_octet((byte)0);
                this.writeServiceContextList(serviceContextArray);
                this.out_._OB_alignNext(8);
                return;
            }
        }
        Assert.assert(false);
    }

    void writeReplyHeader(int n, ReplyStatusType_1_2 replyStatusType_1_2, ServiceContext[] serviceContextArray) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                Assert.assert(replyStatusType_1_2.value() <= 3);
                this.writeServiceContextList(serviceContextArray);
                this.out_.write_ulong(n);
                this.out_.write_ulong(replyStatusType_1_2.value());
                return;
            }
            case 2: {
                this.out_.write_ulong(n);
                this.out_.write_ulong(replyStatusType_1_2.value());
                this.writeServiceContextList(serviceContextArray);
                this.out_._OB_alignNext(8);
                return;
            }
        }
        Assert.assert(false);
    }

    void writeCancelRequestHeader(int n) {
        this.out_.write_ulong(n);
    }

    void writeLocateRequestHeader(int n) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                this.out_.write_ulong(n);
                int n2 = this.profileInfo_.key.length;
                this.out_.write_ulong(n2);
                this.out_.write_octet_array(this.profileInfo_.key, 0, n2);
                return;
            }
            case 2: {
                this.out_.write_ulong(n);
                this.out_.write_short((short)0);
                int n3 = this.profileInfo_.key.length;
                this.out_.write_ulong(n3);
                this.out_.write_octet_array(this.profileInfo_.key, 0, n3);
                return;
            }
        }
        Assert.assert(false);
    }

    void writeLocateReplyHeader(int n, LocateStatusType_1_2 locateStatusType_1_2) {
        switch (this.profileInfo_.minor) {
            case 0: 
            case 1: {
                Assert.assert(locateStatusType_1_2.value() <= 2);
                this.out_.write_ulong(n);
                this.out_.write_ulong(locateStatusType_1_2.value());
                return;
            }
            case 2: {
                this.out_.write_ulong(n);
                this.out_.write_ulong(locateStatusType_1_2.value());
                this.out_._OB_alignNext(8);
                return;
            }
        }
        Assert.assert(false);
    }

    void writeFragmentHeader(int n) {
        Assert.assert(this.profileInfo_.major != 1 || this.profileInfo_.minor > 1);
        this.out_.write_ulong(n);
    }

    public static void setMaxMessageSize(int n) {
        maxMessageSize_ = n;
    }
}

