/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.CoreTraceLevels;
import com.ooc.OB.GIOPServerWorker;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OCI.Acceptor;
import com.ooc.OCI.AcceptorInfo;
import java.util.Vector;
import org.omg.CORBA.SystemException;

abstract class GIOPServerStarter {
    protected ORBInstance orbInstance_;
    protected Acceptor acceptor_;
    protected OAInterface oaInterface_;
    protected Vector workers_ = new Vector();
    public static final int StateActive = 0;
    public static final int StateHolding = 1;
    public static final int StateClosed = 2;
    protected int state_;

    protected void finalize() throws Throwable {
        Assert.assert(this.state_ == 2);
        super.finalize();
    }

    protected void logCloseAcceptor() {
        CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
        if (coreTraceLevels.traceConnections() > 0) {
            AcceptorInfo acceptorInfo = this.acceptor_.get_info();
            String string = "stopped accepting connections\n";
            string = String.valueOf(string) + acceptorInfo.describe();
            this.orbInstance_.getLogger().trace("incoming", string);
        }
    }

    GIOPServerStarter(ORBInstance oRBInstance, Acceptor acceptor, OAInterface oAInterface) {
        this.orbInstance_ = oRBInstance;
        this.acceptor_ = acceptor;
        this.oaInterface_ = oAInterface;
        this.state_ = 1;
        try {
            CoreTraceLevels coreTraceLevels = this.orbInstance_.getCoreTraceLevels();
            if (coreTraceLevels.traceConnections() > 0) {
                AcceptorInfo acceptorInfo = this.acceptor_.get_info();
                String string = "accepting connections\n";
                string = String.valueOf(string) + acceptorInfo.describe();
                this.orbInstance_.getLogger().trace("incoming", string);
            }
            this.acceptor_.listen();
            return;
        }
        catch (SystemException systemException) {
            this.acceptor_.close();
            this.state_ = 2;
            throw systemException;
        }
    }

    public abstract void setState(int var1);

    public synchronized void removeWorker(GIOPServerWorker gIOPServerWorker) {
        int n = 0;
        while (n < this.workers_.size()) {
            if (this.workers_.elementAt(n) == gIOPServerWorker) {
                this.workers_.removeElementAt(n);
                return;
            }
            ++n;
        }
    }
}

