/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.OB.Assert;
import com.ooc.OB.GIOPServerStarterThreaded;
import com.ooc.OB.GIOPServerWorker;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.OAInterface;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.Upcall;
import com.ooc.OCI.Buffer;
import com.ooc.OCI.Transport;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.IMP_LIMIT;
import org.omg.CORBA.SystemException;

final class GIOPServerWorkerThreaded
extends GIOPServerWorker {
    protected Thread senderThread_;
    protected Thread receiverThread_;

    protected void add(Buffer buffer) {
        super.add(buffer);
        this.notifyAll();
    }

    protected boolean setStateNoSync(int n) {
        if (!super.setStateNoSync(n)) {
            return false;
        }
        this.notifyAll();
        return true;
    }

    GIOPServerWorkerThreaded(ORBInstance oRBInstance, GIOPServerStarterThreaded gIOPServerStarterThreaded, Transport transport, OAInterface oAInterface) {
        super(oRBInstance, gIOPServerStarterThreaded, transport, oAInterface);
        try {
            ThreadGroup threadGroup = this.orbInstance_.getServerWorkerGroup();
            this.senderThread_ = new SenderThread(threadGroup, this);
            this.senderThread_.start();
            this.receiverThread_ = new ReceiverThread(threadGroup, this);
            this.receiverThread_.start();
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.transport_.close();
            this.state_ = 4;
            throw new IMP_LIMIT(MinorCodes.describeImpLimit(1330577410), 1330577410, CompletionStatus.COMPLETED_NO);
        }
    }

    public synchronized boolean setState(int n) {
        return this.setStateNoSync(n);
    }

    public synchronized void upcallEndReply(Upcall upcall) {
        this.addUpcall(upcall);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void senderRun() {
        while (true) {
            Buffer buffer = null;
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this;
            synchronized (gIOPServerWorkerThreaded) {
                while (true) {
                    long l;
                    if (this.state_ == 4) {
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 2 && this.upcallCount_ == 0) {
                        this.logCloseConnection();
                        this.transport_.shutdown();
                        return;
                    }
                    if (this.unsent_.isEmpty() && this.state_ == 3) {
                        this.setStateNoSync(4);
                        return;
                    }
                    if (!this.unsent_.isEmpty()) {
                        buffer = (Buffer)this.unsent_.firstElement();
                        this.unsent_.removeElementAt(0);
                        break;
                    }
                    if (this.acmTimeout_ > 0 && this.upcallCount_ == 0 && (l = System.currentTimeMillis() / 1000L) >= this.timestamp_ + (long)this.acmTimeout_) {
                        this.setStateNoSync(2);
                        continue;
                    }
                    try {
                        if (this.acmTimeout_ > 0 && this.upcallCount_ == 0) {
                            this.wait(this.acmTimeout_ * 1000);
                            continue;
                        }
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            try {
                if (!this.transport_.send_detect(buffer, true)) {
                    gIOPServerWorkerThreaded = this;
                    synchronized (gIOPServerWorkerThreaded) {
                        this.setStateNoSync(4);
                        return;
                    }
                }
                Assert.assert(buffer.is_full());
            }
            catch (SystemException systemException) {
                GIOPServerWorkerThreaded gIOPServerWorkerThreaded2 = this;
                synchronized (gIOPServerWorkerThreaded2) {
                    this.exception(4, systemException);
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiverRun() {
        while (true) {
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded;
            Object object;
            Assert.assert(this.buf_ == null);
            this.buf_ = new Buffer(12);
            try {
                if (!this.transport_.receive_detect(this.buf_, true)) {
                    object = this;
                    synchronized (object) {
                        this.setStateNoSync(4);
                        return;
                    }
                }
                Assert.assert(this.buf_.is_full());
            }
            catch (SystemException systemException) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(4, systemException);
                    return;
                }
            }
            try {
                this.incoming_.extractHeader(this.buf_);
                this.buf_.realloc(12 + this.incoming_.size());
            }
            catch (SystemException systemException) {
                gIOPServerWorkerThreaded = this;
                synchronized (gIOPServerWorkerThreaded) {
                    this.exception(3, systemException);
                    return;
                }
            }
            if (!this.buf_.is_full()) {
                try {
                    if (!this.transport_.receive_detect(this.buf_, true)) {
                        object = this;
                        synchronized (object) {
                            this.setStateNoSync(4);
                            return;
                        }
                    }
                    Assert.assert(this.buf_.is_full());
                }
                catch (SystemException systemException) {
                    gIOPServerWorkerThreaded = this;
                    synchronized (gIOPServerWorkerThreaded) {
                        this.exception(4, systemException);
                        return;
                    }
                }
            }
            object = null;
            gIOPServerWorkerThreaded = this;
            synchronized (gIOPServerWorkerThreaded) {
                while (true) {
                    if (this.state_ != 1) {
                        if (this.state_ == 0 || this.state_ == 2) break;
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                object = this.execute();
            }
            if (object == null) continue;
            ((Upcall)object).invoke();
        }
    }

    protected static final class SenderThread
    extends Thread {
        private GIOPServerWorkerThreaded worker_;

        SenderThread(ThreadGroup threadGroup, GIOPServerWorkerThreaded gIOPServerWorkerThreaded) {
            super(threadGroup, "ORBacus:Server:SenderThread");
            this.worker_ = gIOPServerWorkerThreaded;
        }

        public void run() {
            try {
                this.worker_.senderRun();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                Assert.assert(false);
            }
            while (true) {
                try {
                    if (this.worker_.shutdownTimeout_ > 0) {
                        this.worker_.receiverThread_.join(this.worker_.shutdownTimeout_ * 1000);
                        break;
                    }
                    this.worker_.receiverThread_.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            GIOPServerWorkerThreaded gIOPServerWorkerThreaded = this.worker_;
            synchronized (gIOPServerWorkerThreaded) {
                this.worker_.setStateNoSync(4);
            }
            this.worker_ = null;
        }
    }

    protected static final class ReceiverThread
    extends Thread {
        private GIOPServerWorkerThreaded worker_;

        ReceiverThread(ThreadGroup threadGroup, GIOPServerWorkerThreaded gIOPServerWorkerThreaded) {
            super(threadGroup, "ORBacus:Server:ReceiverThread");
            this.worker_ = gIOPServerWorkerThreaded;
        }

        public void run() {
            try {
                this.worker_.receiverRun();
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
                Assert.assert(false);
            }
            this.worker_ = null;
        }
    }
}

