/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OB;

import com.ooc.CORBA.LocalObject;
import com.ooc.OB.Assert;
import com.ooc.OB.MinorCodes;
import com.ooc.OB.ORBInstance;
import com.ooc.OB.ObjectFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;

public final class InitialServiceManager {
    private Hashtable services_ = new Hashtable(37);
    private String defaultInitRef_;
    private boolean destroy_ = false;
    private ORBInstance orbInstance_;

    protected void finalize() throws Throwable {
        Assert.assert(this.destroy_);
        super.finalize();
    }

    synchronized void destroy() {
        Assert.assert(!this.destroy_);
        this.destroy_ = true;
        this.services_ = null;
        this.orbInstance_ = null;
    }

    public void setORBInstance(ORBInstance oRBInstance) {
        this.orbInstance_ = oRBInstance;
        Properties properties = this.orbInstance_.getProperties();
        String string = properties.getProperty("ooc.orb.default_init_ref");
        this.defaultInitRef_ = string == null ? "" : string;
        String string2 = "ooc.orb.service.";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.startsWith(string2)) continue;
            string = properties.getProperty(string3);
            Assert.assert(string != null);
            string3 = string3.substring(string2.length());
            try {
                this.addInitialReference(string3, string, true);
            }
            catch (InvalidName invalidName) {
                Assert.assert(false);
            }
        }
    }

    public synchronized String[] listInitialServices() {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        String[] stringArray = new String[this.services_.size()];
        int n = 0;
        Enumeration enumeration = this.services_.keys();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public synchronized Object resolveInitialReferences(String string) throws InvalidName {
        java.lang.Object object;
        java.lang.Object object2;
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assert(string != null);
        ObjectFactory objectFactory = this.orbInstance_.getObjectFactory();
        Object object3 = null;
        Service service = (Service)this.services_.get(string);
        if (service != null) {
            if (service.obj != null) {
                object3 = service.obj;
            } else if (service.ref.length() > 0) {
                service.obj = object3 = objectFactory.stringToObject(service.ref);
                this.services_.put(string, service);
            }
        }
        if (object3 == null && this.defaultInitRef_.length() > 0 && !this.services_.containsKey(string)) {
            object2 = String.valueOf(this.defaultInitRef_) + '/' + string;
            object3 = objectFactory.stringToObject((String)object2);
        }
        if (object3 == null) {
            throw new InvalidName();
        }
        if (object3 instanceof LocalObject) {
            return object3;
        }
        object2 = objectFactory.policies();
        Vector<java.lang.Object[]> vector = new Vector<java.lang.Object[]>();
        int n = 0;
        while (n < ((Policy[])object2).length) {
            object = null;
            try {
                object = object3._get_policy(object2[n].policy_type());
            }
            catch (INV_POLICY iNV_POLICY) {}
            if (object == null) {
                object = object2[n];
            }
            vector.addElement((java.lang.Object[])object);
            ++n;
        }
        object = new Policy[vector.size()];
        vector.copyInto((java.lang.Object[])object);
        return object3._set_policy_override((Policy[])object, SetOverrideType.SET_OVERRIDE);
    }

    public void addInitialReference(String string, Object object) throws InvalidName {
        this.addInitialReference(string, object, false);
    }

    public synchronized void addInitialReference(String string, String string2, boolean bl) throws InvalidName {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assert(string != null && string2 != null);
        if (this.services_.containsKey(string) && !bl) {
            throw new InvalidName();
        }
        Service service = new Service();
        service.ref = string2;
        this.services_.put(string, service);
    }

    public synchronized void addInitialReference(String string, Object object, boolean bl) throws InvalidName {
        if (this.destroy_) {
            throw new INITIALIZE(MinorCodes.describeInitialize(1330577409), 1330577409, CompletionStatus.COMPLETED_NO);
        }
        Assert.assert(string != null);
        if (this.services_.containsKey(string) && !bl) {
            throw new InvalidName();
        }
        Service service = new Service();
        service.ref = "";
        service.obj = object;
        this.services_.put(string, service);
    }

    private class Service {
        String ref;
        Object obj;

        Service() {
            InitialServiceManager.this = InitialServiceManager.this;
        }
    }
}

