/*
 * Decompiled with CFR 0.152.
 */
package com.ooc.OBPortableServer;

import com.ooc.OB.Assert;
import org.omg.PortableServer.Servant;

class TableEntry {
    private Servant servant_;
    int ACTIVE;
    int DEACTIVATE_PENDING = 1;
    int DEACTIVATED = 2;
    private int state_;
    private int outstandingRequests_;

    TableEntry(Servant servant) {
        this.servant_ = servant;
        this.state_ = this.ACTIVE;
        this.outstandingRequests_ = 0;
    }

    void setServant(Servant servant) {
        Assert.assert(servant != null);
        this.servant_ = servant;
    }

    void clearServant() {
        this.servant_ = null;
    }

    Servant getServant() {
        return this.servant_;
    }

    boolean active() {
        return this.state_ == this.ACTIVE;
    }

    void setDeactivatePending() {
        this.state_ = this.DEACTIVATE_PENDING;
    }

    synchronized void setDeactivated() {
        this.state_ = this.DEACTIVATED;
        this.notifyAll();
    }

    synchronized void waitDeactivated() {
        Assert.assert(this.state_ != this.ACTIVE);
        while (this.state_ != this.DEACTIVATED) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    int getOutstandingRequests() {
        return this.outstandingRequests_;
    }

    void incOutstandingRequest() {
        ++this.outstandingRequests_;
    }

    int decOutstandingRequest() {
        return --this.outstandingRequests_;
    }
}

