/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.model;

import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.LeapSecondHistory;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MicroSecondDate
extends Date
implements Serializable {
    protected long microseconds;
    protected int leapSecondVersion;
    protected LeapSecondHistory leapHistory;

    public MicroSecondDate() {
        this.leapSecondVersion = 0;
        this.microseconds = 0L;
    }

    public MicroSecondDate(long microseconds) {
        this(microseconds, 0);
    }

    public MicroSecondDate(long microseconds, int leapSeconds) {
        super(microseconds / 1000L);
        this.microseconds = microseconds % 1000L;
        this.leapSecondVersion = leapSeconds;
    }

    public MicroSecondDate(Date d) {
        this(d.getTime() * 1000L, 0);
    }

    public MicroSecondDate(MicroSecondDate d) {
        this(d.getMicroSecondTime());
    }

    public MicroSecondDate(Timestamp ts, int leapSeconds) {
        this(MicroSecondDate.fixTimestamp(ts), leapSeconds);
    }

    static long fixTimestamp(Timestamp ts) {
        long tsFracSeconds = ts.getTime() % 1000L;
        if (tsFracSeconds == 0L) {
            return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000);
        }
        return ts.getTime() * 1000L + (long)(ts.getNanos() / 1000 % 1000);
    }

    public MicroSecondDate(Timestamp ts) {
        this(ts, 0);
    }

    public MicroSecondDate(Time t) {
        this(new ISOTime(t.date_time).getDate().getMicroSecondTime(), t.leap_seconds_version);
    }

    public long getMicroSecondTime() {
        return super.getTime() * 1000L + this.microseconds;
    }

    public long getMicroSeconds() {
        return this.microseconds;
    }

    public Timestamp getTimestamp() {
        Timestamp t = new Timestamp(this.getTime());
        int nanos = t.getNanos();
        nanos = (int)((long)nanos + this.microseconds * 1000L);
        t.setNanos(nanos);
        return t;
    }

    public Time getFissuresTime() {
        return new Time(ISOTime.getISOString(this), this.leapSecondVersion);
    }

    public int getLeapSecondVersion() {
        return this.leapSecondVersion;
    }

    public MicroSecondDate add(TimeInterval interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Cannot add() a null TimeInterval");
        }
        return new MicroSecondDate(this.getMicroSecondTime() + Math.round(interval.convertTo(UnitImpl.MICROSECOND).getValue()));
    }

    public MicroSecondDate subtract(TimeInterval interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Cannot subtract() a null TimeInterval");
        }
        return new MicroSecondDate(this.getMicroSecondTime() - Math.round(interval.convertTo(UnitImpl.MICROSECOND).getValue()));
    }

    public TimeInterval subtract(MicroSecondDate otherDate) {
        if (otherDate == null) {
            throw new IllegalArgumentException("Cannot difference() a null MicroSecondDate");
        }
        return new TimeInterval((double)(this.getMicroSecondTime() - otherDate.getMicroSecondTime()), UnitImpl.MICROSECOND);
    }

    public TimeInterval difference(MicroSecondDate otherDate) {
        if (otherDate == null) {
            throw new IllegalArgumentException("Cannot difference() a null MicroSecondDate");
        }
        long otherTime = otherDate.getMicroSecondTime();
        long myTime = this.getMicroSecondTime();
        if (this.before(otherDate)) {
            return new TimeInterval((double)(otherTime - myTime), UnitImpl.MICROSECOND);
        }
        return new TimeInterval((double)(myTime - otherTime), UnitImpl.MICROSECOND);
    }

    public boolean equals(Object otherDate) {
        if (otherDate == this) {
            return true;
        }
        if (super.equals(otherDate)) {
            if (otherDate instanceof MicroSecondDate) {
                MicroSecondDate oMSD = (MicroSecondDate)otherDate;
                return this.getMicroSecondTime() == oMSD.getMicroSecondTime() && this.leapSecondVersion == oMSD.leapSecondVersion;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean after(Date otherDate) {
        if (super.after(otherDate)) {
            return true;
        }
        return super.equals(otherDate) && otherDate instanceof MicroSecondDate && this.getMicroSecondTime() > ((MicroSecondDate)otherDate).getMicroSecondTime();
    }

    public boolean before(Date otherDate) {
        if (super.before(otherDate)) {
            return true;
        }
        return super.equals(otherDate) && otherDate instanceof MicroSecondDate && this.getMicroSecondTime() < ((MicroSecondDate)otherDate).getMicroSecondTime();
    }

    public String toString() {
        SimpleDateFormat df = new SimpleDateFormat("G yyyy.MM.dd HH:mm:ss.SSS zzz");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(this);
    }
}

