/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.seisFile.mseed;

import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Utility;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;

public abstract class DataBlockette
extends Blockette
implements Serializable {
    protected byte[] info;

    public DataBlockette(byte[] info) {
        this.info = info;
    }

    public DataBlockette(int size) {
        this.info = new byte[size];
        System.arraycopy(Utility.intToByteArray(this.getType()), 2, this.info, 0, 2);
    }

    protected void trimToSize(int size) {
        if (this.info.length < size) {
            throw new IllegalArgumentException("Blockette " + this.getType() + " must have " + size + " bytes, but got " + this.info.length);
        }
        if (this.info.length > size) {
            byte[] tmp = new byte[size];
            System.arraycopy(this.info, 0, tmp, 0, size);
            this.info = tmp;
        }
    }

    public void write(DataOutputStream dos, short nextOffset) throws IOException {
        dos.write(this.toBytes(nextOffset));
    }

    public byte[] toBytes(short nextOffset) {
        System.arraycopy(Utility.intToByteArray(nextOffset), 2, this.info, 2, 2);
        return this.info;
    }

    public byte[] toBytes() {
        return this.toBytes((short)0);
    }
}

