package pickstatistics;

import java.util.ArrayList;

public class StationGroup extends ArrayList<Station> {

    long duration;

    public StationGroup(long duration) {
        this.duration = duration;
    }

    public void addPick(String[] scnl, long time) {
        // Check if station is already registered
        Station curSta = null;
        for (Station station : this) {
            if (station.isSCNL(scnl)) {
                curSta = station;
                break;
            }
        }
        // Create new station, if necessary
        if (curSta == null) {
            curSta = new Station(scnl, duration);
            this.add(curSta);
        }
        // Add pick
        curSta.addPick(time);
    }
    
    
}
