package pickewanalysis;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pickewanalysis.PickEWAnalysis;

public class TracePanelMouseListener implements MouseListener, MouseMotionListener {

    private TracePanel panel;
    private int startX = -1;
    private int endX = -1;
    private boolean inDrag = false;

    public TracePanelMouseListener(TracePanel aThis) {
        this.panel = aThis;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == MouseEvent.BUTTON3) {
            //Zoom out
            ((PickEWAnalysis) panel.getTopLevelAncestor()).zoom(1.5);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != MouseEvent.BUTTON1) {
            return;
        }
        Point p = e.getPoint();
        startX = p.x;
        inDrag = true;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != MouseEvent.BUTTON1) {
            return;
        }
        Point p = e.getPoint();
        endX = p.x;
        inDrag = false;
        panel.repaint();
        int[] box = getDrawBox();
        if (box[2] > 5 && box[3] > 5) {
            //This looks like a zoom in
            double timeSpan = panel.endtime - panel.starttime;
            if (timeSpan <= 0) {
                return;
            }
            long starttime = panel.starttime
                    + (long) ((double) startX / (double) panel.getWidth() * timeSpan + 0.5);
            long endtime = panel.starttime
                    + (long) ((double) endX / (double) panel.getWidth() * timeSpan + 0.5);
            if (starttime > endtime) {
                //Order is swapped
                ((PickEWAnalysis) panel.getTopLevelAncestor()).zoom(endtime, starttime);
            } else {
                ((PickEWAnalysis) panel.getTopLevelAncestor()).zoom(starttime, endtime);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = e.getPoint();
        endX = p.x;
        panel.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = e.getPoint();
        String tip = panel.isPick(p.x, p.y);
        if (tip == null) {
            panel.setToolTipText(null);
            return;
        }
        panel.setToolTipText(tip);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        //Do nothing
    }

    @Override
    public void mouseExited(MouseEvent e) {
        //Do nothing
    }

    public void drawBox(Graphics2D g) {
        if (!inDrag) {
            return;
        }
        int[] box = getDrawBox();
        Rectangle rect = new Rectangle(box[0], box[1], box[2], box[3]);
        Composite originalComposite = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(AlphaComposite.SRC_OVER, 0.2f));
        g.setPaint(new Color(230, 230, 100)); //Light yellow
        g.fill(rect);
        g.setComposite(originalComposite);
        g.drawRect(box[0], box[1], box[2], box[3]);
    }

    private int[] getDrawBox() {
        int x = 0, y = 0, w = 0, h = 0;
        if (startX < endX) {
            x = startX;
            w = endX - startX;
        } else {
            x = endX;
            w = startX - endX;
        }
        y = 1;
        h = panel.getHeight() - 3;
        return new int[]{x, y, w, h};
    }
}
