package pickewanalysis.ewmessages;


import java.text.SimpleDateFormat;
import java.util.Date;

public class PickSCNL extends EWMessage {

    public final int msgType = TYPE_PICK_SCNL;
    public int instID;
    public int modID;
    public int seqNo;
    public String SCNL;
    public char FirstMotion;
    public int Weight;
    public double arrivalTime;
    public int[] peaks;
    //public double time;
    public String Station;
    public String Channel;
    public String Network;
    public String Location;

    /*
     * Construct introducing all data
     */
    public PickSCNL(String rawMsg) throws Exception {
        parseRawMsg(rawMsg);
    }

    public PickSCNL(int modID,
            int instID,
            int seqNo,
            String SCNL,
            char FirstMotion,
            int Weight,
            double arrivalTime,
            int[] peaks) {
        this.instID = instID;
        this.modID = modID;
        this.seqNo = seqNo;
        this.SCNL = SCNL;
        String[] parts = SCNL.split("[\\s]+");
        this.Station = parts[0];
        this.Channel = parts[1];
        this.Network = parts[2];
        this.Location = parts[3];
        this.FirstMotion = FirstMotion;
        this.Weight = Weight;
        this.arrivalTime = arrivalTime;
        this.peaks = peaks;
    }

    public boolean parseRawMsg(String rawMsg) throws Exception {
        String[] parts = rawMsg.split("[\\s]+");
        int candidateType = Integer.valueOf(parts[0]);
        if (candidateType != this.msgType) {
            throw new Exception("Wrong message type.");
        }
        instID = Integer.valueOf(parts[2]);
        modID = Integer.valueOf(parts[1]);
        seqNo = Integer.valueOf(parts[3]);
        SCNL = parts[4].replace('.', ' ');
        String[] partsSCNL = SCNL.split("[\\s]+");
        this.Station = partsSCNL[0];
        this.Channel = partsSCNL[1];
        this.Network = partsSCNL[2];
        this.Location = partsSCNL[3];
        FirstMotion = parts[5].charAt(0);
        Weight = parts[5].charAt(1);
        arrivalTime = (double) new SimpleDateFormat("yyyyMMddHHmmss.SSS").parse(parts[6]).getTime() / 1000;
        peaks = new int[]{Integer.valueOf(parts[7]), Integer.valueOf(parts[8]), Integer.valueOf(parts[9])};
        return true;
    }

    public String getRawMsg() {
        return getRawMsg(seqNo);
    }
    
    public String toString() {
        return getRawMsg(seqNo);
    }

    public String getRawMsg(int customSeqNo) {
        return String.valueOf(msgType) + " "
                + String.valueOf(modID) + " "
                + String.valueOf(instID) + " "
                + String.valueOf(customSeqNo) + " "
                + SCNL.replace(' ', '.') + " "
                + ((FirstMotion == ' ') ? '?' : FirstMotion)
                + Weight + " "
                + new SimpleDateFormat("yyyyMMddHHmmss.SSS").format(new Date((long) (arrivalTime * 1000))) + " "
                + String.valueOf(peaks[0]) + " "
                + String.valueOf(peaks[1]) + " "
                + String.valueOf(peaks[2]) + " ";
    }

    public int getType() {
        return msgType;
    }

    public byte[] getBytes() {
        return getRawMsg().getBytes();
    }
}
