package pickewanalysis.ewpicker;

import java.util.Locale;

public class PickEWStation {

    //Variables from sta file
    public int flag = 1, pinno = 0, Itr1 = 3, MinSmallZC = 40, MinBigZC = 3,
            MinPeakSize = 25, MaxMint = 500, ClipCount = 32768000, MinCodaLen = 3;
    public double RawDataFilt = 0.988, CharFuncFilt = 3.0,
            StaFilt = 0.4, LtaFilt = 0.015, EventThresh = 2.5,
            RmavFilt = 0.9961, DeadSta = 19200, CodaTerm = 15.0, AltCoda = 0.8,
            PreEvent = 1.5, Erefs = 50000.0;
    public String stat = "", chan = "", net = "", loc = "";
    //Variables required for the picker
    public Coda coda = new Coda();
    public Pick pick = new Pick();
    public double cocrit = 0;
    public double crtinc = 0;
    public double eabs = 0;
    public double ecrit = 0;
    public double elta = 0;
    public int enddata = 0;
    public double endtime = 0;
    public double eref = 0;
    public double esta = 0;
    public int evlen = 0;
    public int first = 0;
    public int isml = 0;
    public int k = 0;
    public int m = 0;
    public int mint;
    public int ndrt = 0;
    public int next = 0;
    public int nzero = 0;
    public int old_sample = 0;
    public int ns_restart;
    public double rdat = 0;
    public double rbig = 0;
    public double rlast = 0;
    public double rold = 0;
    public double rsrdat = 0;
    public int[] sarray = new int[10];
    public double tmax;
    public int xdot = 0;
    public double xfrz = 0;

    public void initVar() {
        cocrit = 0;
        crtinc = 0;
        eabs = 0;
        ecrit = 0;
        elta = 0;
        enddata = 0;
        endtime = 0;
        eref = 0;
        esta = 0;
        evlen = 0;
        first = 1;
        isml = 0;
        k = 0;
        m = 0;
        ndrt = 0;
        next = 0;
        nzero = 0;
        old_sample = 0;
        ns_restart = 0;
        rdat = 0;
        rbig = 0;
        rlast = 0;
        rold = 0;
        rsrdat = 0;
        tmax = 0;
        xdot = 0;
        xfrz = 0;

        int i;
        for (i = 0; i < 10; i++) {
            sarray[i] = 0;
        }

        //Pick variables
        pick.time = 0;
        for (i = 0; i < 3; i++) {
            pick.xpk[i] = 0;
        }
        pick.FirstMotion = '?';
        pick.weight = 0;
        pick.status = 0;

        //Coda variables
        for (i = 0; i < 6; i++) {
            coda.aav[i] = 0;
        }
        coda.len_sec = 0;
        coda.len_out = 0;
        coda.len_win = 0;
        coda.status = 0;
    }

    /*
     * Construct through a line of a station file
     */
    protected PickEWStation(String line) throws Exception {
        String[] parts = line.split("[\\s]+");
        flag = Integer.valueOf(parts[0]);
        pinno = Integer.valueOf(parts[1]);
        stat = parts[2];
        chan = parts[3];
        net = parts[4];
        loc = parts[5];
        Itr1 = Integer.valueOf(parts[6]);
        MinSmallZC = Integer.valueOf(parts[7]);
        MinBigZC = Integer.valueOf(parts[8]);
        MinPeakSize = Integer.valueOf(parts[9]);
        MaxMint = Integer.valueOf(parts[10]);
        MinCodaLen = Integer.valueOf(parts[11]);
        RawDataFilt = Double.valueOf(parts[12]);
        CharFuncFilt = Double.valueOf(parts[13]);
        StaFilt = Double.valueOf(parts[14]);
        LtaFilt = Double.valueOf(parts[15]);
        EventThresh = Double.valueOf(parts[16]);
        RmavFilt = Double.valueOf(parts[17]);
        DeadSta = Double.valueOf(parts[18]);
        CodaTerm = Double.valueOf(parts[19]);
        AltCoda = Double.valueOf(parts[20]);
        PreEvent = Double.valueOf(parts[21]);
        Erefs = Double.valueOf(parts[22]);
        if (parts.length >= 24) {
            ClipCount = Integer.valueOf(parts[23]);
        } else {
            ClipCount = Integer.MAX_VALUE;
        }
    }

    public String[] getSCNL() {
        return new String[]{
                    stat,
                    chan,
                    net,
                    loc};
    }

    public String getSCNLStr() {
        return stat + " " + chan + " " + net + " " + loc;
    }

    @Override
    public String toString() {
        return getSCNLStr();
    }
    
    
    public String toStationLine() {
        String stationLine = String.format(Locale.UK, "  %4d  %4d %5s %3s %2s %2s "
                + "%2d %3d %2d %4d %4d %2d "
                + "%4.3f %3.1f %4.3f %4.3f %3.1f "
                + "%6.4f %5.0f %5.1f %3.1f %3.1f %6.0f %8d",
                flag, pinno, stat, chan, net, loc.replace(' ', '-'),
                Itr1, MinSmallZC, MinBigZC, MinPeakSize, MaxMint, MinCodaLen,
                RawDataFilt, CharFuncFilt, StaFilt, LtaFilt, EventThresh,
                RmavFilt, DeadSta, CodaTerm, AltCoda, PreEvent, Erefs, ClipCount);
        return stationLine;
    }
}
